/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import android.annotation.TargetApi;
import android.media.DeniedByServerException;
import android.media.MediaCrypto;
import android.media.MediaCryptoException;
import android.media.MediaDrm;
import android.media.MediaDrmException;
import android.media.NotProvisionedException;
import android.media.UnsupportedSchemeException;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Handler;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.Log;

@JNINamespace(value="media")
@TargetApi(value=19)
public class MediaDrmBridge {
    private static final String TAG = "cr.media";
    private static final String SECURITY_LEVEL = "securityLevel";
    private static final String SERVER_CERTIFICATE = "serviceCertificate";
    private static final String PRIVACY_MODE = "privacyMode";
    private static final String SESSION_SHARING = "sessionSharing";
    private static final String ENABLE = "enable";
    private static final int INVALID_SESSION_ID = 0;
    private static final char[] HEX_CHAR_LOOKUP = "0123456789ABCDEF".toCharArray();
    private static final long INVALID_NATIVE_MEDIA_DRM_BRIDGE = 0L;
    private static final int KEY_STATUS_USABLE = 0;
    private static final int KEY_STATUS_INTERNAL_ERROR = 1;
    private static final int KEY_STATUS_EXPIRED = 2;
    private static final int KEY_STATUS_OUTPUT_NOT_ALLOWED = 3;
    private MediaDrm mMediaDrm;
    private long mNativeMediaDrmBridge;
    private UUID mSchemeUUID;
    private Handler mHandler;
    private byte[] mMediaCryptoSession;
    private MediaCrypto mMediaCrypto;
    private HashMap<ByteBuffer, String> mSessionIds;
    private ArrayDeque<PendingCreateSessionData> mPendingCreateSessionDataQueue;
    private boolean mResetDeviceCredentialsPending;
    private boolean mProvisioningPending;

    private static UUID getUUIDFromBytes(byte[] data) {
        int i;
        if (data.length != 16) {
            return null;
        }
        long mostSigBits = 0L;
        long leastSigBits = 0L;
        for (i = 0; i < 8; ++i) {
            mostSigBits = mostSigBits << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            leastSigBits = leastSigBits << 8 | (long)(data[i] & 0xFF);
        }
        return new UUID(mostSigBits, leastSigBits);
    }

    private static String bytesToHexString(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            hexString.append(HEX_CHAR_LOOKUP[bytes[i] >>> 4]);
            hexString.append(HEX_CHAR_LOOKUP[bytes[i] & 0xF]);
        }
        return hexString.toString();
    }

    private boolean isNativeMediaDrmBridgeValid() {
        return this.mNativeMediaDrmBridge != 0L;
    }

    private MediaDrmBridge(UUID schemeUUID, long nativeMediaDrmBridge) throws UnsupportedSchemeException {
        this.mSchemeUUID = schemeUUID;
        this.mMediaDrm = new MediaDrm(schemeUUID);
        this.mNativeMediaDrmBridge = nativeMediaDrmBridge;
        assert (this.isNativeMediaDrmBridgeValid());
        this.mHandler = new Handler();
        this.mSessionIds = new HashMap();
        this.mPendingCreateSessionDataQueue = new ArrayDeque();
        this.mResetDeviceCredentialsPending = false;
        this.mProvisioningPending = false;
        this.mMediaDrm.setOnEventListener((MediaDrm.OnEventListener)new MediaDrmListener());
        this.mMediaDrm.setPropertyString(PRIVACY_MODE, ENABLE);
        this.mMediaDrm.setPropertyString(SESSION_SHARING, ENABLE);
    }

    private boolean createMediaCrypto() throws NotProvisionedException {
        if (this.mMediaDrm == null) {
            return false;
        }
        assert (!this.mProvisioningPending);
        assert (this.mMediaCryptoSession == null);
        assert (this.mMediaCrypto == null);
        this.mMediaCryptoSession = this.openSession();
        if (this.mMediaCryptoSession == null) {
            Log.e(TAG, "Cannot create MediaCrypto Session.", new Object[0]);
            return false;
        }
        Log.d(TAG, "MediaCrypto Session created: %s", MediaDrmBridge.bytesToHexString(this.mMediaCryptoSession));
        try {
            if (MediaCrypto.isCryptoSchemeSupported((UUID)this.mSchemeUUID)) {
                this.mMediaCrypto = new MediaCrypto(this.mSchemeUUID, this.mMediaCryptoSession);
                Log.d(TAG, "MediaCrypto successfully created!");
                this.onMediaCryptoReady();
                return true;
            }
            Log.e(TAG, "Cannot create MediaCrypto for unsupported scheme.", new Object[0]);
        }
        catch (MediaCryptoException e) {
            Log.e(TAG, "Cannot create MediaCrypto", new Object[]{e});
        }
        this.release();
        return false;
    }

    private byte[] openSession() throws NotProvisionedException {
        assert (this.mMediaDrm != null);
        try {
            byte[] sessionId = this.mMediaDrm.openSession();
            return (byte[])sessionId.clone();
        }
        catch (RuntimeException e) {
            Log.e(TAG, "Cannot open a new session", e);
            this.release();
            return null;
        }
        catch (NotProvisionedException e) {
            throw e;
        }
        catch (MediaDrmException e) {
            Log.e(TAG, "Cannot open a new session", new Object[]{e});
            this.release();
            return null;
        }
    }

    @CalledByNative
    private static boolean isCryptoSchemeSupported(byte[] schemeUUID, String containerMimeType) {
        UUID cryptoScheme = MediaDrmBridge.getUUIDFromBytes(schemeUUID);
        if (containerMimeType.isEmpty()) {
            return MediaDrm.isCryptoSchemeSupported((UUID)cryptoScheme);
        }
        return MediaDrm.isCryptoSchemeSupported((UUID)cryptoScheme, (String)containerMimeType);
    }

    @CalledByNative
    private static MediaDrmBridge create(byte[] schemeUUID, long nativeMediaDrmBridge) {
        UUID cryptoScheme = MediaDrmBridge.getUUIDFromBytes(schemeUUID);
        if (cryptoScheme == null || !MediaDrm.isCryptoSchemeSupported((UUID)cryptoScheme)) {
            return null;
        }
        MediaDrmBridge mediaDrmBridge = null;
        try {
            mediaDrmBridge = new MediaDrmBridge(cryptoScheme, nativeMediaDrmBridge);
            Log.d(TAG, "MediaDrmBridge successfully created.");
        }
        catch (UnsupportedSchemeException e) {
            Log.e(TAG, "Unsupported DRM scheme", new Object[]{e});
        }
        catch (IllegalArgumentException e) {
            Log.e(TAG, "Failed to create MediaDrmBridge", e);
        }
        catch (IllegalStateException e) {
            Log.e(TAG, "Failed to create MediaDrmBridge", e);
        }
        return mediaDrmBridge;
    }

    @CalledByNative
    private boolean setSecurityLevel(String securityLevel) {
        if (this.mMediaDrm == null || this.mMediaCrypto != null) {
            return false;
        }
        String currentSecurityLevel = this.mMediaDrm.getPropertyString(SECURITY_LEVEL);
        Log.e(TAG, "Security level: current %s, new %s", currentSecurityLevel, securityLevel);
        if (securityLevel.equals(currentSecurityLevel)) {
            return true;
        }
        try {
            this.mMediaDrm.setPropertyString(SECURITY_LEVEL, securityLevel);
            return true;
        }
        catch (IllegalArgumentException e) {
            Log.e(TAG, "Failed to set security level %s", securityLevel, e);
        }
        catch (IllegalStateException e) {
            Log.e(TAG, "Failed to set security level %s", securityLevel, e);
        }
        Log.e(TAG, "Security level %s not supported!", securityLevel);
        return false;
    }

    @CalledByNative
    private boolean setServerCertificate(byte[] certificate) {
        try {
            this.mMediaDrm.setPropertyByteArray(SERVER_CERTIFICATE, certificate);
            return true;
        }
        catch (IllegalArgumentException e) {
            Log.e(TAG, "Failed to set server certificate", e);
        }
        catch (IllegalStateException e) {
            Log.e(TAG, "Failed to set server certificate", e);
        }
        return false;
    }

    @CalledByNative
    private MediaCrypto getMediaCrypto() {
        return this.mMediaCrypto;
    }

    @CalledByNative
    private void resetDeviceCredentials() {
        this.mResetDeviceCredentialsPending = true;
        MediaDrm.ProvisionRequest request = this.mMediaDrm.getProvisionRequest();
        PostRequestTask postTask = new PostRequestTask(request.getData());
        postTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new String[]{request.getDefaultUrl()});
    }

    @CalledByNative
    private void destroy() {
        this.mNativeMediaDrmBridge = 0L;
        if (this.mMediaDrm != null) {
            this.release();
        }
    }

    private void release() {
        for (PendingCreateSessionData data : this.mPendingCreateSessionDataQueue) {
            this.onPromiseRejected(data.promiseId(), "Create session aborted.");
        }
        this.mPendingCreateSessionDataQueue.clear();
        this.mPendingCreateSessionDataQueue = null;
        for (ByteBuffer sessionId : this.mSessionIds.keySet()) {
            try {
                this.mMediaDrm.removeKeys(sessionId.array());
            }
            catch (Exception e) {
                Log.e(TAG, "removeKeys failed: ", e);
            }
            this.mMediaDrm.closeSession(sessionId.array());
            this.onSessionClosed(sessionId.array());
        }
        this.mSessionIds.clear();
        this.mSessionIds = null;
        this.mMediaCryptoSession = null;
        if (this.mMediaCrypto != null) {
            this.mMediaCrypto.release();
            this.mMediaCrypto = null;
        }
        if (this.mMediaDrm != null) {
            this.mMediaDrm.release();
            this.mMediaDrm = null;
        }
    }

    private MediaDrm.KeyRequest getKeyRequest(byte[] sessionId, byte[] data, String mime, HashMap<String, String> optionalParameters) throws NotProvisionedException {
        MediaDrm.KeyRequest request;
        block6: {
            assert (this.mMediaDrm != null);
            assert (this.mMediaCrypto != null);
            assert (!this.mProvisioningPending);
            if (optionalParameters == null) {
                optionalParameters = new HashMap();
            }
            request = null;
            try {
                request = this.mMediaDrm.getKeyRequest(sessionId, data, mime, 1, optionalParameters);
            }
            catch (IllegalStateException e) {
                if (Build.VERSION.SDK_INT < 21 || !(e instanceof MediaDrm.MediaDrmStateException)) break block6;
                Log.e(TAG, "MediaDrmStateException fired during getKeyRequest().", e);
            }
        }
        String result = request != null ? "successed" : "failed";
        Log.d(TAG, "getKeyRequest %s!", result);
        return request;
    }

    private void savePendingCreateSessionData(byte[] initData, String mime, HashMap<String, String> optionalParameters, long promiseId) {
        Log.d(TAG, "savePendingCreateSessionData()");
        this.mPendingCreateSessionDataQueue.offer(new PendingCreateSessionData(initData, mime, optionalParameters, promiseId));
    }

    private void processPendingCreateSessionData() {
        Log.d(TAG, "processPendingCreateSessionData()");
        assert (this.mMediaDrm != null);
        while (this.mMediaDrm != null && !this.mProvisioningPending && !this.mPendingCreateSessionDataQueue.isEmpty()) {
            PendingCreateSessionData pendingData = this.mPendingCreateSessionDataQueue.poll();
            byte[] initData = pendingData.initData();
            String mime = pendingData.mimeType();
            HashMap optionalParameters = pendingData.optionalParameters();
            long promiseId = pendingData.promiseId();
            this.createSession(initData, mime, optionalParameters, promiseId);
        }
    }

    private void resumePendingOperations() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                MediaDrmBridge.this.processPendingCreateSessionData();
            }
        });
    }

    @CalledByNative
    private void createSessionFromNative(byte[] initData, String mime, String[] optionalParamsArray, long promiseId) {
        HashMap<String, String> optionalParameters = new HashMap<String, String>();
        if (optionalParamsArray != null) {
            if (optionalParamsArray.length % 2 != 0) {
                throw new IllegalArgumentException("Additional data array doesn't have equal keys/values");
            }
            for (int i = 0; i < optionalParamsArray.length; i += 2) {
                optionalParameters.put(optionalParamsArray[i], optionalParamsArray[i + 1]);
            }
        }
        this.createSession(initData, mime, optionalParameters, promiseId);
    }

    private void createSession(byte[] initData, String mime, HashMap<String, String> optionalParameters, long promiseId) {
        Log.d(TAG, "createSession()");
        if (this.mMediaDrm == null) {
            Log.e(TAG, "createSession() called when MediaDrm is null.", new Object[0]);
            return;
        }
        if (this.mProvisioningPending) {
            assert (this.mMediaCrypto == null);
            this.savePendingCreateSessionData(initData, mime, optionalParameters, promiseId);
            return;
        }
        boolean newSessionOpened = false;
        byte[] sessionId = null;
        try {
            if (this.mMediaCrypto == null && !this.createMediaCrypto()) {
                this.onPromiseRejected(promiseId, "MediaCrypto creation failed.");
                return;
            }
            assert (this.mMediaCryptoSession != null);
            assert (this.mMediaCrypto != null);
            sessionId = this.openSession();
            if (sessionId == null) {
                this.onPromiseRejected(promiseId, "Open session failed.");
                return;
            }
            newSessionOpened = true;
            assert (!this.sessionExists(sessionId));
            MediaDrm.KeyRequest request = null;
            request = this.getKeyRequest(sessionId, initData, mime, optionalParameters);
            if (request == null) {
                this.mMediaDrm.closeSession(sessionId);
                this.onPromiseRejected(promiseId, "Generate request failed.");
                return;
            }
            Log.d(TAG, "createSession(): Session (%s) created.", MediaDrmBridge.bytesToHexString(sessionId));
            this.onPromiseResolvedWithSession(promiseId, sessionId);
            this.onSessionMessage(sessionId, request);
            this.mSessionIds.put(ByteBuffer.wrap(sessionId), mime);
        }
        catch (NotProvisionedException e) {
            Log.e(TAG, "Device not provisioned", new Object[]{e});
            if (newSessionOpened) {
                this.mMediaDrm.closeSession(sessionId);
            }
            this.savePendingCreateSessionData(initData, mime, optionalParameters, promiseId);
            this.startProvisioning();
        }
    }

    private boolean sessionExists(byte[] sessionId) {
        if (this.mMediaCryptoSession == null) {
            assert (this.mSessionIds.isEmpty());
            Log.e(TAG, "Session doesn't exist because media crypto session is not created.", new Object[0]);
            return false;
        }
        return !Arrays.equals(sessionId, this.mMediaCryptoSession) && this.mSessionIds.containsKey(ByteBuffer.wrap(sessionId));
    }

    @CalledByNative
    private void closeSession(byte[] sessionId, long promiseId) {
        Log.d(TAG, "closeSession()");
        if (this.mMediaDrm == null) {
            this.onPromiseRejected(promiseId, "closeSession() called when MediaDrm is null.");
            return;
        }
        if (!this.sessionExists(sessionId)) {
            this.onPromiseRejected(promiseId, "Invalid sessionId in closeSession(): " + MediaDrmBridge.bytesToHexString(sessionId));
            return;
        }
        try {
            this.mMediaDrm.removeKeys(sessionId);
        }
        catch (Exception e) {
            Log.e(TAG, "removeKeys failed: ", e);
        }
        this.mMediaDrm.closeSession(sessionId);
        this.mSessionIds.remove(ByteBuffer.wrap(sessionId));
        this.onPromiseResolved(promiseId);
        this.onSessionClosed(sessionId);
        Log.d(TAG, "Session %s closed", MediaDrmBridge.bytesToHexString(sessionId));
    }

    @CalledByNative
    private void updateSession(byte[] sessionId, byte[] response, long promiseId) {
        Log.d(TAG, "updateSession()");
        if (this.mMediaDrm == null) {
            this.onPromiseRejected(promiseId, "updateSession() called when MediaDrm is null.");
            return;
        }
        if (!this.sessionExists(sessionId)) {
            this.onPromiseRejected(promiseId, "Invalid session in updateSession: " + MediaDrmBridge.bytesToHexString(sessionId));
            return;
        }
        try {
            try {
                this.mMediaDrm.provideKeyResponse(sessionId, response);
            }
            catch (IllegalStateException e) {
                Log.e(TAG, "Exception intentionally caught when calling provideKeyResponse()", e);
            }
            Log.d(TAG, "Key successfully added for session %s", MediaDrmBridge.bytesToHexString(sessionId));
            this.onPromiseResolved(promiseId);
            this.onSessionKeysChange(sessionId, true, 0);
            return;
        }
        catch (NotProvisionedException e) {
            Log.e(TAG, "failed to provide key response", new Object[]{e});
        }
        catch (DeniedByServerException e) {
            Log.e(TAG, "failed to provide key response", new Object[]{e});
        }
        this.onPromiseRejected(promiseId, "Update session failed.");
        this.release();
    }

    @CalledByNative
    private String getSecurityLevel() {
        if (this.mMediaDrm == null) {
            Log.e(TAG, "getSecurityLevel() called when MediaDrm is null.", new Object[0]);
            return null;
        }
        return this.mMediaDrm.getPropertyString(SECURITY_LEVEL);
    }

    private void startProvisioning() {
        Log.d(TAG, "startProvisioning");
        assert (this.mMediaDrm != null);
        assert (!this.mProvisioningPending);
        this.mProvisioningPending = true;
        MediaDrm.ProvisionRequest request = this.mMediaDrm.getProvisionRequest();
        PostRequestTask postTask = new PostRequestTask(request.getData());
        postTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new String[]{request.getDefaultUrl()});
    }

    private void onProvisionResponse(byte[] response) {
        Log.d(TAG, "onProvisionResponse()");
        assert (this.mProvisioningPending);
        this.mProvisioningPending = false;
        if (this.mMediaDrm == null) {
            return;
        }
        boolean success = this.provideProvisionResponse(response);
        if (this.mResetDeviceCredentialsPending) {
            this.onResetDeviceCredentialsCompleted(success);
            this.mResetDeviceCredentialsPending = false;
        }
        if (success) {
            this.resumePendingOperations();
        }
    }

    boolean provideProvisionResponse(byte[] response) {
        if (response == null || response.length == 0) {
            Log.e(TAG, "Invalid provision response.", new Object[0]);
            return false;
        }
        try {
            this.mMediaDrm.provideProvisionResponse(response);
            return true;
        }
        catch (DeniedByServerException e) {
            Log.e(TAG, "failed to provide provision response", new Object[]{e});
        }
        catch (IllegalStateException e) {
            Log.e(TAG, "failed to provide provision response", e);
        }
        return false;
    }

    private void onMediaCryptoReady() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (MediaDrmBridge.this.isNativeMediaDrmBridgeValid()) {
                    MediaDrmBridge.this.nativeOnMediaCryptoReady(MediaDrmBridge.this.mNativeMediaDrmBridge);
                }
            }
        });
    }

    private void onPromiseResolved(final long promiseId) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (MediaDrmBridge.this.isNativeMediaDrmBridgeValid()) {
                    MediaDrmBridge.this.nativeOnPromiseResolved(MediaDrmBridge.this.mNativeMediaDrmBridge, promiseId);
                }
            }
        });
    }

    private void onPromiseResolvedWithSession(final long promiseId, final byte[] sessionId) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (MediaDrmBridge.this.isNativeMediaDrmBridgeValid()) {
                    MediaDrmBridge.this.nativeOnPromiseResolvedWithSession(MediaDrmBridge.this.mNativeMediaDrmBridge, promiseId, sessionId);
                }
            }
        });
    }

    private void onPromiseRejected(final long promiseId, final String errorMessage) {
        Log.e(TAG, "onPromiseRejected: %s", errorMessage);
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (MediaDrmBridge.this.isNativeMediaDrmBridgeValid()) {
                    MediaDrmBridge.this.nativeOnPromiseRejected(MediaDrmBridge.this.mNativeMediaDrmBridge, promiseId, errorMessage);
                }
            }
        });
    }

    private void onSessionMessage(final byte[] sessionId, final MediaDrm.KeyRequest request) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (MediaDrmBridge.this.isNativeMediaDrmBridgeValid()) {
                    MediaDrmBridge.this.nativeOnSessionMessage(MediaDrmBridge.this.mNativeMediaDrmBridge, sessionId, request.getData(), request.getDefaultUrl());
                }
            }
        });
    }

    private void onSessionClosed(final byte[] sessionId) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (MediaDrmBridge.this.isNativeMediaDrmBridgeValid()) {
                    MediaDrmBridge.this.nativeOnSessionClosed(MediaDrmBridge.this.mNativeMediaDrmBridge, sessionId);
                }
            }
        });
    }

    private void onSessionKeysChange(final byte[] sessionId, final boolean hasAdditionalUsableKey, final int keyStatus) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (MediaDrmBridge.this.isNativeMediaDrmBridgeValid()) {
                    MediaDrmBridge.this.nativeOnSessionKeysChange(MediaDrmBridge.this.mNativeMediaDrmBridge, sessionId, hasAdditionalUsableKey, keyStatus);
                }
            }
        });
    }

    private void onLegacySessionError(final byte[] sessionId, final String errorMessage) {
        Log.e(TAG, "onLegacySessionError: %s", errorMessage);
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (MediaDrmBridge.this.isNativeMediaDrmBridgeValid()) {
                    MediaDrmBridge.this.nativeOnLegacySessionError(MediaDrmBridge.this.mNativeMediaDrmBridge, sessionId, errorMessage);
                }
            }
        });
    }

    private void onResetDeviceCredentialsCompleted(final boolean success) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (MediaDrmBridge.this.isNativeMediaDrmBridgeValid()) {
                    MediaDrmBridge.this.nativeOnResetDeviceCredentialsCompleted(MediaDrmBridge.this.mNativeMediaDrmBridge, success);
                }
            }
        });
    }

    private native void nativeOnMediaCryptoReady(long var1);

    private native void nativeOnPromiseResolved(long var1, long var3);

    private native void nativeOnPromiseResolvedWithSession(long var1, long var3, byte[] var5);

    private native void nativeOnPromiseRejected(long var1, long var3, String var5);

    private native void nativeOnSessionMessage(long var1, byte[] var3, byte[] var4, String var5);

    private native void nativeOnSessionClosed(long var1, byte[] var3);

    private native void nativeOnSessionKeysChange(long var1, byte[] var3, boolean var4, int var5);

    private native void nativeOnLegacySessionError(long var1, byte[] var3, String var4);

    private native void nativeOnResetDeviceCredentialsCompleted(long var1, boolean var3);

    private class PostRequestTask
    extends AsyncTask<String, Void, Void> {
        private static final String TAG = "PostRequestTask";
        private byte[] mDrmRequest;
        private byte[] mResponseBody;

        public PostRequestTask(byte[] drmRequest) {
            this.mDrmRequest = drmRequest;
        }

        protected Void doInBackground(String ... urls) {
            this.mResponseBody = this.postRequest(urls[0], this.mDrmRequest);
            if (this.mResponseBody != null) {
                Log.d(TAG, "response length=%d", this.mResponseBody.length);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] postRequest(String url, byte[] drmRequest) {
            HttpURLConnection urlConnection = null;
            try {
                URL request = new URL(url + "&signedRequest=" + new String(drmRequest));
                urlConnection = (HttpURLConnection)request.openConnection();
                urlConnection.setDoOutput(true);
                urlConnection.setDoInput(true);
                urlConnection.setUseCaches(false);
                urlConnection.setRequestMethod("POST");
                urlConnection.setRequestProperty("User-Agent", "Widevine CDM v1.0");
                urlConnection.setRequestProperty("Content-Type", "application/json");
                int responseCode = urlConnection.getResponseCode();
                if (responseCode == 200) {
                    BufferedInputStream bis = new BufferedInputStream(urlConnection.getInputStream());
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    int read = 0;
                    int bufferSize = 512;
                    byte[] buffer = new byte[bufferSize];
                    try {
                        while ((read = bis.read(buffer)) != -1) {
                            bos.write(buffer, 0, read);
                        }
                    }
                    finally {
                        bis.close();
                    }
                    byte[] byArray = bos.toByteArray();
                    return byArray;
                }
                Log.d(TAG, "Server returned HTTP error code %d", responseCode);
                byte[] byArray = null;
                return byArray;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
            finally {
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
            }
            return null;
        }

        protected void onPostExecute(Void v) {
            MediaDrmBridge.this.onProvisionResponse(this.mResponseBody);
        }
    }

    private class MediaDrmListener
    implements MediaDrm.OnEventListener {
        private MediaDrmListener() {
        }

        public void onEvent(MediaDrm mediaDrm, byte[] sessionId, int event, int extra, byte[] data) {
            if (sessionId == null) {
                Log.e(MediaDrmBridge.TAG, "MediaDrmListener: Null session.", new Object[0]);
                return;
            }
            if (!MediaDrmBridge.this.sessionExists(sessionId)) {
                Log.e(MediaDrmBridge.TAG, "MediaDrmListener: Invalid session %s", MediaDrmBridge.bytesToHexString(sessionId));
                return;
            }
            switch (event) {
                case 1: {
                    Log.d(MediaDrmBridge.TAG, "MediaDrm.EVENT_PROVISION_REQUIRED");
                    break;
                }
                case 2: {
                    Log.d(MediaDrmBridge.TAG, "MediaDrm.EVENT_KEY_REQUIRED");
                    if (MediaDrmBridge.this.mProvisioningPending) {
                        return;
                    }
                    String mime = (String)MediaDrmBridge.this.mSessionIds.get(ByteBuffer.wrap(sessionId));
                    MediaDrm.KeyRequest request = null;
                    try {
                        request = MediaDrmBridge.this.getKeyRequest(sessionId, data, mime, null);
                    }
                    catch (NotProvisionedException e) {
                        Log.e(MediaDrmBridge.TAG, "Device not provisioned", new Object[]{e});
                        MediaDrmBridge.this.startProvisioning();
                        return;
                    }
                    if (request != null) {
                        MediaDrmBridge.this.onSessionMessage(sessionId, request);
                        break;
                    }
                    MediaDrmBridge.this.onLegacySessionError(sessionId, "MediaDrm EVENT_KEY_REQUIRED: Failed to generate request.");
                    MediaDrmBridge.this.onSessionKeysChange(sessionId, false, 1);
                    break;
                }
                case 3: {
                    Log.d(MediaDrmBridge.TAG, "MediaDrm.EVENT_KEY_EXPIRED");
                    MediaDrmBridge.this.onLegacySessionError(sessionId, "MediaDrm EVENT_KEY_EXPIRED.");
                    MediaDrmBridge.this.onSessionKeysChange(sessionId, false, 2);
                    break;
                }
                case 4: {
                    Log.d(MediaDrmBridge.TAG, "MediaDrm.EVENT_VENDOR_DEFINED");
                    assert (false);
                    break;
                }
                default: {
                    Log.e(MediaDrmBridge.TAG, "Invalid DRM event " + event, new Object[0]);
                    return;
                }
            }
        }
    }

    private static class PendingCreateSessionData {
        private final byte[] mInitData;
        private final String mMimeType;
        private final HashMap<String, String> mOptionalParameters;
        private final long mPromiseId;

        private PendingCreateSessionData(byte[] initData, String mimeType, HashMap<String, String> optionalParameters, long promiseId) {
            this.mInitData = initData;
            this.mMimeType = mimeType;
            this.mOptionalParameters = optionalParameters;
            this.mPromiseId = promiseId;
        }

        private byte[] initData() {
            return this.mInitData;
        }

        private String mimeType() {
            return this.mMimeType;
        }

        private HashMap<String, String> optionalParameters() {
            return this.mOptionalParameters;
        }

        private long promiseId() {
            return this.mPromiseId;
        }
    }
}

