/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.util.Base64InputStream;
import android.view.Surface;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.Log;

@JNINamespace(value="media")
public class MediaPlayerBridge {
    private static ResourceLoadingFilter sResourceLoadFilter = null;
    private static final String TAG = "MediaPlayerBridge";
    private LoadDataUriTask mLoadDataUriTask;
    private MediaPlayer mPlayer;
    private long mNativeMediaPlayerBridge;

    public static void setResourceLoadingFilter(ResourceLoadingFilter filter) {
        sResourceLoadFilter = filter;
    }

    @CalledByNative
    private static MediaPlayerBridge create(long nativeMediaPlayerBridge) {
        return new MediaPlayerBridge(nativeMediaPlayerBridge);
    }

    protected MediaPlayerBridge(long nativeMediaPlayerBridge) {
        this.mNativeMediaPlayerBridge = nativeMediaPlayerBridge;
    }

    protected MediaPlayerBridge() {
    }

    @CalledByNative
    protected void destroy() {
        if (this.mLoadDataUriTask != null) {
            this.mLoadDataUriTask.cancel(true);
            this.mLoadDataUriTask = null;
        }
        this.mNativeMediaPlayerBridge = 0L;
    }

    protected MediaPlayer getLocalPlayer() {
        if (this.mPlayer == null) {
            this.mPlayer = new MediaPlayer();
        }
        return this.mPlayer;
    }

    @CalledByNative
    protected void setSurface(Surface surface) {
        this.getLocalPlayer().setSurface(surface);
    }

    @CalledByNative
    protected boolean prepareAsync() {
        try {
            this.getLocalPlayer().prepareAsync();
        }
        catch (IllegalStateException e) {
            Log.e(TAG, "Unable to prepare MediaPlayer.", e);
            return false;
        }
        return true;
    }

    @CalledByNative
    protected boolean isPlaying() {
        return this.getLocalPlayer().isPlaying();
    }

    @CalledByNative
    protected int getVideoWidth() {
        return this.getLocalPlayer().getVideoWidth();
    }

    @CalledByNative
    protected int getVideoHeight() {
        return this.getLocalPlayer().getVideoHeight();
    }

    @CalledByNative
    protected int getCurrentPosition() {
        return this.getLocalPlayer().getCurrentPosition();
    }

    @CalledByNative
    protected int getDuration() {
        return this.getLocalPlayer().getDuration();
    }

    @CalledByNative
    protected void release() {
        this.getLocalPlayer().release();
    }

    @CalledByNative
    protected void setVolume(double volume) {
        this.getLocalPlayer().setVolume((float)volume, (float)volume);
    }

    @CalledByNative
    protected void start() {
        this.getLocalPlayer().start();
    }

    @CalledByNative
    protected void pause() {
        this.getLocalPlayer().pause();
    }

    @CalledByNative
    protected void seekTo(int msec) throws IllegalStateException {
        this.getLocalPlayer().seekTo(msec);
    }

    @CalledByNative
    protected boolean setDataSource(Context context, String url, String cookies, String userAgent, boolean hideUrlLog) {
        Uri uri = Uri.parse((String)url);
        HashMap<String, String> headersMap = new HashMap<String, String>();
        if (hideUrlLog) {
            headersMap.put("x-hide-urls-from-log", "true");
        }
        if (!TextUtils.isEmpty((CharSequence)cookies)) {
            headersMap.put("Cookie", cookies);
        }
        if (!TextUtils.isEmpty((CharSequence)userAgent)) {
            headersMap.put("User-Agent", userAgent);
        }
        if (Build.VERSION.SDK_INT > 19) {
            headersMap.put("allow-cross-domain-redirect", "false");
        }
        try {
            if (sResourceLoadFilter != null && sResourceLoadFilter.shouldOverrideResourceLoading(this.getLocalPlayer(), context, uri)) {
                return true;
            }
            this.getLocalPlayer().setDataSource(context, uri, headersMap);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @CalledByNative
    protected boolean setDataSourceFromFd(int fd, long offset, long length) {
        try {
            ParcelFileDescriptor parcelFd = ParcelFileDescriptor.adoptFd((int)fd);
            this.getLocalPlayer().setDataSource(parcelFd.getFileDescriptor(), offset, length);
            parcelFd.close();
            return true;
        }
        catch (IOException e) {
            Log.e(TAG, "Failed to set data source from file descriptor: " + e, new Object[0]);
            return false;
        }
    }

    @CalledByNative
    protected boolean setDataUriDataSource(Context context, String url) {
        if (this.mLoadDataUriTask != null) {
            this.mLoadDataUriTask.cancel(true);
            this.mLoadDataUriTask = null;
        }
        if (!url.startsWith("data:")) {
            return false;
        }
        int headerStop = url.indexOf(44);
        if (headerStop == -1) {
            return false;
        }
        String header = url.substring(0, headerStop);
        String data = url.substring(headerStop + 1);
        String headerContent = header.substring(5);
        String[] headerInfo = headerContent.split(";");
        if (headerInfo.length != 2) {
            return false;
        }
        if (!"base64".equals(headerInfo[1])) {
            return false;
        }
        this.mLoadDataUriTask = new LoadDataUriTask(context, data);
        this.mLoadDataUriTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        return true;
    }

    protected void setOnBufferingUpdateListener(MediaPlayer.OnBufferingUpdateListener listener) {
        this.getLocalPlayer().setOnBufferingUpdateListener(listener);
    }

    protected void setOnCompletionListener(MediaPlayer.OnCompletionListener listener) {
        this.getLocalPlayer().setOnCompletionListener(listener);
    }

    protected void setOnErrorListener(MediaPlayer.OnErrorListener listener) {
        this.getLocalPlayer().setOnErrorListener(listener);
    }

    protected void setOnPreparedListener(MediaPlayer.OnPreparedListener listener) {
        this.getLocalPlayer().setOnPreparedListener(listener);
    }

    protected void setOnSeekCompleteListener(MediaPlayer.OnSeekCompleteListener listener) {
        this.getLocalPlayer().setOnSeekCompleteListener(listener);
    }

    protected void setOnVideoSizeChangedListener(MediaPlayer.OnVideoSizeChangedListener listener) {
        this.getLocalPlayer().setOnVideoSizeChangedListener(listener);
    }

    @CalledByNative
    protected AllowedOperations getAllowedOperations() {
        MediaPlayer player = this.getLocalPlayer();
        boolean canPause = true;
        boolean canSeekForward = true;
        boolean canSeekBackward = true;
        try {
            Method getMetadata = player.getClass().getDeclaredMethod("getMetadata", Boolean.TYPE, Boolean.TYPE);
            getMetadata.setAccessible(true);
            Object data = getMetadata.invoke((Object)player, false, false);
            if (data != null) {
                Class<?> metadataClass = data.getClass();
                Method hasMethod = metadataClass.getDeclaredMethod("has", Integer.TYPE);
                Method getBooleanMethod = metadataClass.getDeclaredMethod("getBoolean", Integer.TYPE);
                int pause = (Integer)metadataClass.getField("PAUSE_AVAILABLE").get(null);
                int seekForward = (Integer)metadataClass.getField("SEEK_FORWARD_AVAILABLE").get(null);
                int seekBackward = (Integer)metadataClass.getField("SEEK_BACKWARD_AVAILABLE").get(null);
                hasMethod.setAccessible(true);
                getBooleanMethod.setAccessible(true);
                canPause = (Boolean)hasMethod.invoke(data, pause) == false || (Boolean)getBooleanMethod.invoke(data, pause) != false;
                canSeekForward = (Boolean)hasMethod.invoke(data, seekForward) == false || (Boolean)getBooleanMethod.invoke(data, seekForward) != false;
                canSeekBackward = (Boolean)hasMethod.invoke(data, seekBackward) == false || (Boolean)getBooleanMethod.invoke(data, seekBackward) != false;
            }
        }
        catch (NoSuchMethodException e) {
            Log.e(TAG, "Cannot find getMetadata() method: " + e, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Log.e(TAG, "Cannot invoke MediaPlayer.getMetadata() method: " + e, new Object[0]);
        }
        catch (IllegalAccessException e) {
            Log.e(TAG, "Cannot access metadata: " + e, new Object[0]);
        }
        catch (NoSuchFieldException e) {
            Log.e(TAG, "Cannot find matching fields in Metadata class: " + e, new Object[0]);
        }
        return new AllowedOperations(canPause, canSeekForward, canSeekBackward);
    }

    private native void nativeOnDidSetDataUriDataSource(long var1, boolean var3);

    protected static class AllowedOperations {
        private final boolean mCanPause;
        private final boolean mCanSeekForward;
        private final boolean mCanSeekBackward;

        public AllowedOperations(boolean canPause, boolean canSeekForward, boolean canSeekBackward) {
            this.mCanPause = canPause;
            this.mCanSeekForward = canSeekForward;
            this.mCanSeekBackward = canSeekBackward;
        }

        @CalledByNative(value="AllowedOperations")
        private boolean canPause() {
            return this.mCanPause;
        }

        @CalledByNative(value="AllowedOperations")
        private boolean canSeekForward() {
            return this.mCanSeekForward;
        }

        @CalledByNative(value="AllowedOperations")
        private boolean canSeekBackward() {
            return this.mCanSeekBackward;
        }
    }

    private class LoadDataUriTask
    extends AsyncTask<Void, Void, Boolean> {
        private final String mData;
        private final Context mContext;
        private File mTempFile;

        public LoadDataUriTask(Context context, String data) {
            this.mData = data;
            this.mContext = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground(Void ... params) {
            FileOutputStream fos = null;
            try {
                int len;
                this.mTempFile = File.createTempFile("decoded", "mediadata");
                fos = new FileOutputStream(this.mTempFile);
                ByteArrayInputStream stream = new ByteArrayInputStream(this.mData.getBytes());
                Base64InputStream decoder = new Base64InputStream((InputStream)stream, 0);
                byte[] buffer = new byte[1024];
                while ((len = decoder.read(buffer)) != -1) {
                    fos.write(buffer, 0, len);
                }
                decoder.close();
                Boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                Boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }

        protected void onPostExecute(Boolean result) {
            if (this.isCancelled()) {
                this.deleteFile();
                return;
            }
            try {
                MediaPlayerBridge.this.getLocalPlayer().setDataSource(this.mContext, Uri.fromFile((File)this.mTempFile));
            }
            catch (IOException e) {
                result = false;
            }
            this.deleteFile();
            assert (MediaPlayerBridge.this.mNativeMediaPlayerBridge != 0L);
            MediaPlayerBridge.this.nativeOnDidSetDataUriDataSource(MediaPlayerBridge.this.mNativeMediaPlayerBridge, result);
        }

        private void deleteFile() {
            if (this.mTempFile == null) {
                return;
            }
            if (!this.mTempFile.delete()) {
                Log.e(MediaPlayerBridge.TAG, "Failed to delete temporary file: " + this.mTempFile, new Object[0]);
                assert (false);
            }
        }
    }

    public static class ResourceLoadingFilter {
        public boolean shouldOverrideResourceLoading(MediaPlayer mediaPlayer, Context context, Uri uri) {
            return false;
        }
    }
}

