/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import android.content.Context;
import android.graphics.ImageFormat;
import android.hardware.Camera;
import android.os.Build;
import java.util.ArrayList;
import org.chromium.base.Log;
import org.chromium.media.VideoCaptureCamera;
import org.chromium.media.VideoCaptureFormat;

public class VideoCaptureAndroid
extends VideoCaptureCamera {
    private int mExpectedFrameSize;
    private static final int NUM_CAPTURE_BUFFERS = 3;
    private static final String TAG = "cr.media";

    static int getNumberOfCameras() {
        return Camera.getNumberOfCameras();
    }

    static int getCaptureApiType(int id2) {
        if (VideoCaptureCamera.getCameraInfo(id2) == null) {
            return 5;
        }
        return 0;
    }

    static String getName(int id2) {
        Camera.CameraInfo cameraInfo = VideoCaptureCamera.getCameraInfo(id2);
        if (cameraInfo == null) {
            return null;
        }
        return "camera " + id2 + ", facing " + (cameraInfo.facing == 1 ? "front" : "back");
    }

    static VideoCaptureFormat[] getDeviceSupportedFormats(int id2) {
        Camera camera;
        try {
            camera = Camera.open((int)id2);
        }
        catch (RuntimeException ex) {
            Log.e(TAG, "Camera.open: ", ex);
            return null;
        }
        Camera.Parameters parameters = VideoCaptureAndroid.getCameraParameters(camera);
        if (parameters == null) {
            return null;
        }
        ArrayList<VideoCaptureFormat> formatList = new ArrayList<VideoCaptureFormat>();
        ArrayList<Integer> pixelFormats = parameters.getSupportedPreviewFormats();
        if (pixelFormats == null) {
            pixelFormats = new ArrayList<Integer>();
        }
        if (pixelFormats.size() == 0) {
            pixelFormats.add(0);
        }
        for (Integer previewFormat : pixelFormats) {
            int pixelFormat = 0;
            if (previewFormat == 842094169) {
                pixelFormat = 842094169;
            } else if (previewFormat == 17) continue;
            ArrayList<int[]> listFpsRange = parameters.getSupportedPreviewFpsRange();
            if (listFpsRange == null) {
                listFpsRange = new ArrayList<int[]>();
            }
            if (listFpsRange.size() == 0) {
                listFpsRange.add(new int[]{0, 0});
            }
            for (int[] fpsRange : listFpsRange) {
                ArrayList<Camera.Size> supportedSizes = parameters.getSupportedPreviewSizes();
                if (supportedSizes == null) {
                    supportedSizes = new ArrayList<Camera.Size>();
                }
                if (supportedSizes.size() == 0) {
                    Camera camera2 = camera;
                    camera2.getClass();
                    supportedSizes.add(new Camera.Size(camera2, 0, 0));
                }
                for (Camera.Size size : supportedSizes) {
                    formatList.add(new VideoCaptureFormat(size.width, size.height, (fpsRange[1] + 999) / 1000, pixelFormat));
                }
            }
        }
        camera.release();
        return formatList.toArray(new VideoCaptureFormat[formatList.size()]);
    }

    VideoCaptureAndroid(Context context, int id2, long nativeVideoCaptureDeviceAndroid) {
        super(context, id2, nativeVideoCaptureDeviceAndroid);
    }

    @Override
    protected void setCaptureParameters(int width, int height, int frameRate, Camera.Parameters cameraParameters) {
        this.mCaptureFormat = new VideoCaptureFormat(width, height, frameRate, BuggyDeviceHack.getImageFormat());
    }

    @Override
    protected void allocateBuffers() {
        this.mExpectedFrameSize = this.mCaptureFormat.mWidth * this.mCaptureFormat.mHeight * ImageFormat.getBitsPerPixel((int)this.mCaptureFormat.mPixelFormat) / 8;
        for (int i = 0; i < 3; ++i) {
            byte[] buffer = new byte[this.mExpectedFrameSize];
            this.mCamera.addCallbackBuffer(buffer);
        }
    }

    @Override
    protected void setPreviewCallback(Camera.PreviewCallback cb) {
        this.mCamera.setPreviewCallbackWithBuffer(cb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPreviewFrame(byte[] data, Camera camera) {
        this.mPreviewBufferLock.lock();
        try {
            if (!this.mIsRunning) {
                return;
            }
            if (data.length == this.mExpectedFrameSize) {
                this.nativeOnFrameAvailable(this.mNativeVideoCaptureDeviceAndroid, data, this.mExpectedFrameSize, this.getCameraRotation());
            }
        }
        finally {
            this.mPreviewBufferLock.unlock();
            if (camera != null) {
                camera.addCallbackBuffer(data);
            }
        }
    }

    private static class BuggyDeviceHack {
        private static final String[] COLORSPACE_BUGGY_DEVICE_LIST = new String[]{"SAMSUNG-SGH-I747", "ODROID-U2"};

        private BuggyDeviceHack() {
        }

        static int getImageFormat() {
            if (Build.VERSION.SDK_INT < 16) {
                return 17;
            }
            for (String buggyDevice : COLORSPACE_BUGGY_DEVICE_LIST) {
                if (!buggyDevice.contentEquals(Build.MODEL)) continue;
                return 17;
            }
            return 842094169;
        }
    }
}

