/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.opengl.GLES20;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.chromium.base.JNINamespace;
import org.chromium.base.Log;
import org.chromium.media.VideoCapture;

@JNINamespace(value="media")
@TargetApi(value=15)
public abstract class VideoCaptureCamera
extends VideoCapture
implements Camera.PreviewCallback {
    protected Camera mCamera;
    protected ReentrantLock mPreviewBufferLock = new ReentrantLock();
    protected boolean mIsRunning = false;
    protected int[] mGlTextures = null;
    protected SurfaceTexture mSurfaceTexture = null;
    protected static final int GL_TEXTURE_EXTERNAL_OES = 36197;
    private static final String TAG = "cr.media";

    protected static Camera.CameraInfo getCameraInfo(int id2) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        try {
            Camera.getCameraInfo((int)id2, (Camera.CameraInfo)cameraInfo);
        }
        catch (RuntimeException ex) {
            Log.e(TAG, "getCameraInfo: Camera.getCameraInfo: " + ex, new Object[0]);
            return null;
        }
        return cameraInfo;
    }

    protected static Camera.Parameters getCameraParameters(Camera camera) {
        Camera.Parameters parameters;
        try {
            parameters = camera.getParameters();
        }
        catch (RuntimeException ex) {
            Log.e(TAG, "getCameraParameters: android.hardware.Camera.getParameters: " + ex, new Object[0]);
            camera.release();
            return null;
        }
        return parameters;
    }

    VideoCaptureCamera(Context context, int id2, long nativeVideoCaptureDeviceAndroid) {
        super(context, id2, nativeVideoCaptureDeviceAndroid);
    }

    @Override
    public boolean allocate(int width, int height, int frameRate) {
        Log.d(TAG, "allocate: requested (%d x %d) @%dfps", width, height, frameRate);
        try {
            this.mCamera = Camera.open((int)this.mId);
        }
        catch (RuntimeException ex) {
            Log.e(TAG, "allocate: Camera.open: " + ex, new Object[0]);
            return false;
        }
        Camera.CameraInfo cameraInfo = VideoCaptureCamera.getCameraInfo(this.mId);
        if (cameraInfo == null) {
            this.mCamera.release();
            this.mCamera = null;
            return false;
        }
        this.mCameraNativeOrientation = cameraInfo.orientation;
        this.mInvertDeviceOrientationReadings = cameraInfo.facing == 0;
        Log.d(TAG, "allocate: Rotation dev=%d, cam=%d, facing back? %s", this.getDeviceRotation(), this.mCameraNativeOrientation, this.mInvertDeviceOrientationReadings);
        Camera.Parameters parameters = VideoCaptureCamera.getCameraParameters(this.mCamera);
        if (parameters == null) {
            this.mCamera = null;
            return false;
        }
        List listFpsRange = parameters.getSupportedPreviewFpsRange();
        if (listFpsRange == null || listFpsRange.size() == 0) {
            Log.e(TAG, "allocate: no fps range found", new Object[0]);
            return false;
        }
        int frameRateScaled = frameRate * 1000;
        int[] chosenFpsRange = (int[])listFpsRange.get(0);
        int frameRateNearest = Math.abs(frameRateScaled - chosenFpsRange[0]) < Math.abs(frameRateScaled - chosenFpsRange[1]) ? chosenFpsRange[0] : chosenFpsRange[1];
        int chosenFrameRate = (frameRateNearest + 999) / 1000;
        int fpsRangeSize = Integer.MAX_VALUE;
        for (int[] fpsRange : listFpsRange) {
            if (fpsRange[0] > frameRateScaled || frameRateScaled > fpsRange[1] || fpsRange[1] - fpsRange[0] > fpsRangeSize) continue;
            chosenFpsRange = fpsRange;
            chosenFrameRate = frameRate;
            fpsRangeSize = fpsRange[1] - fpsRange[0];
        }
        Log.d(TAG, "allocate: fps set to %d, [%d-%d]", chosenFrameRate, chosenFpsRange[0], chosenFpsRange[1]);
        List listCameraSize = parameters.getSupportedPreviewSizes();
        int minDiff = Integer.MAX_VALUE;
        int matchedWidth = width;
        int matchedHeight = height;
        for (Camera.Size size : listCameraSize) {
            int diff = Math.abs(size.width - width) + Math.abs(size.height - height);
            Log.d(TAG, "allocate: supported (%d, %d), diff=%d", size.width, size.height, diff);
            if (diff >= minDiff || size.width % 32 != 0) continue;
            minDiff = diff;
            matchedWidth = size.width;
            matchedHeight = size.height;
        }
        if (minDiff == Integer.MAX_VALUE) {
            Log.e(TAG, "allocate: can not find a multiple-of-32 resolution", new Object[0]);
            return false;
        }
        Log.d(TAG, "allocate: matched (%d x %d)", matchedWidth, matchedHeight);
        if (parameters.isVideoStabilizationSupported()) {
            Log.d(TAG, "Image stabilization supported, currently: " + parameters.getVideoStabilization() + ", setting it.");
            parameters.setVideoStabilization(true);
        } else {
            Log.d(TAG, "Image stabilization not supported.");
        }
        if (parameters.getSupportedFocusModes().contains("continuous-video")) {
            parameters.setFocusMode("continuous-video");
        } else {
            Log.d(TAG, "Continuous focus mode not supported.");
        }
        this.setCaptureParameters(matchedWidth, matchedHeight, chosenFrameRate, parameters);
        parameters.setPictureSize(matchedWidth, matchedHeight);
        parameters.setPreviewSize(matchedWidth, matchedHeight);
        parameters.setPreviewFpsRange(chosenFpsRange[0], chosenFpsRange[1]);
        parameters.setPreviewFormat(this.mCaptureFormat.mPixelFormat);
        try {
            this.mCamera.setParameters(parameters);
        }
        catch (RuntimeException ex) {
            Log.e(TAG, "setParameters: " + ex, new Object[0]);
            return false;
        }
        this.mGlTextures = new int[1];
        GLES20.glGenTextures((int)1, (int[])this.mGlTextures, (int)0);
        GLES20.glBindTexture((int)36197, (int)this.mGlTextures[0]);
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        this.mSurfaceTexture = new SurfaceTexture(this.mGlTextures[0]);
        this.mSurfaceTexture.setOnFrameAvailableListener(null);
        try {
            this.mCamera.setPreviewTexture(this.mSurfaceTexture);
        }
        catch (IOException ex) {
            Log.e(TAG, "allocate: " + ex, new Object[0]);
            return false;
        }
        this.allocateBuffers();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startCapture() {
        if (this.mCamera == null) {
            Log.e(TAG, "startCapture: camera is null", new Object[0]);
            return false;
        }
        this.mPreviewBufferLock.lock();
        try {
            if (this.mIsRunning) {
                boolean bl = true;
                return bl;
            }
            this.mIsRunning = true;
        }
        finally {
            this.mPreviewBufferLock.unlock();
        }
        this.setPreviewCallback(this);
        try {
            this.mCamera.startPreview();
        }
        catch (RuntimeException ex) {
            Log.e(TAG, "startCapture: Camera.startPreview: " + ex, new Object[0]);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stopCapture() {
        if (this.mCamera == null) {
            Log.e(TAG, "stopCapture: camera is null", new Object[0]);
            return true;
        }
        this.mPreviewBufferLock.lock();
        try {
            if (!this.mIsRunning) {
                boolean bl = true;
                return bl;
            }
            this.mIsRunning = false;
        }
        finally {
            this.mPreviewBufferLock.unlock();
        }
        this.mCamera.stopPreview();
        this.setPreviewCallback(null);
        return true;
    }

    @Override
    public void deallocate() {
        if (this.mCamera == null) {
            return;
        }
        this.stopCapture();
        try {
            this.mCamera.setPreviewTexture(null);
            if (this.mGlTextures != null) {
                GLES20.glDeleteTextures((int)1, (int[])this.mGlTextures, (int)0);
            }
            this.mCaptureFormat = null;
            this.mCamera.release();
            this.mCamera = null;
        }
        catch (IOException ex) {
            Log.e(TAG, "deallocate: failed to deallocate camera, " + ex, new Object[0]);
            return;
        }
    }

    abstract void allocateBuffers();

    abstract void setCaptureParameters(int var1, int var2, int var3, Camera.Parameters var4);

    abstract void setPreviewCallback(Camera.PreviewCallback var1);
}

