/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.ImageFormat;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Size;
import android.view.Surface;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.chromium.base.JNINamespace;
import org.chromium.base.Log;
import org.chromium.media.VideoCapture;
import org.chromium.media.VideoCaptureFormat;

@JNINamespace(value="media")
@TargetApi(value=21)
public class VideoCaptureCamera2
extends VideoCapture {
    private byte[] mCapturedData;
    private boolean mOpeningCamera = false;
    private boolean mConfiguringCamera = false;
    private CameraDevice mCameraDevice = null;
    private CaptureRequest.Builder mPreviewBuilder = null;
    private CameraCaptureSession mCaptureSession = null;
    private ImageReader mImageReader = null;
    private static final double kNanoSecondsToFps = 1.0E-9;
    private static final String TAG = "cr.media";

    private static CameraCharacteristics getCameraCharacteristics(Context appContext, int id2) {
        CameraManager manager = (CameraManager)appContext.getSystemService("camera");
        try {
            return manager.getCameraCharacteristics(Integer.toString(id2));
        }
        catch (CameraAccessException ex) {
            Log.e(TAG, "getNumberOfCameras: getCameraIdList(): " + (Object)((Object)ex), new Object[0]);
            return null;
        }
    }

    private boolean createCaptureObjects() {
        Log.d(TAG, "createCaptureObjects");
        if (this.mCameraDevice == null) {
            return false;
        }
        int maxImages = 2;
        this.mImageReader = ImageReader.newInstance((int)this.mCaptureFormat.getWidth(), (int)this.mCaptureFormat.getHeight(), (int)this.mCaptureFormat.getPixelFormat(), (int)2);
        HandlerThread thread = new HandlerThread("CameraPreview");
        thread.start();
        Handler backgroundHandler = new Handler(thread.getLooper());
        CrImageReaderListener imageReaderListener = new CrImageReaderListener();
        this.mImageReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)imageReaderListener, backgroundHandler);
        try {
            this.mPreviewBuilder = this.mCameraDevice.createCaptureRequest(1);
        }
        catch (CameraAccessException ex) {
            Log.e(TAG, "createCaptureRequest: " + (Object)((Object)ex), new Object[0]);
            return false;
        }
        catch (IllegalArgumentException ex) {
            Log.e(TAG, "createCaptureRequest: " + ex, new Object[0]);
            return false;
        }
        catch (SecurityException ex) {
            Log.e(TAG, "createCaptureRequest: " + ex, new Object[0]);
            return false;
        }
        if (this.mPreviewBuilder == null) {
            Log.e(TAG, "mPreviewBuilder error", new Object[0]);
            return false;
        }
        this.mPreviewBuilder.addTarget(this.mImageReader.getSurface());
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_MODE, (Object)1);
        this.mPreviewBuilder.set(CaptureRequest.NOISE_REDUCTION_MODE, (Object)1);
        this.mPreviewBuilder.set(CaptureRequest.EDGE_MODE, (Object)1);
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)1);
        ArrayList<Surface> surfaceList = new ArrayList<Surface>(1);
        surfaceList.add(this.mImageReader.getSurface());
        CrCaptureSessionListener captureSessionListener = new CrCaptureSessionListener();
        try {
            this.mCameraDevice.createCaptureSession(surfaceList, (CameraCaptureSession.StateCallback)captureSessionListener, null);
        }
        catch (CameraAccessException ex) {
            Log.e(TAG, "createCaptureSession: " + (Object)((Object)ex), new Object[0]);
            return false;
        }
        catch (IllegalArgumentException ex) {
            Log.e(TAG, "createCaptureSession: " + ex, new Object[0]);
            return false;
        }
        catch (SecurityException ex) {
            Log.e(TAG, "createCaptureSession: " + ex, new Object[0]);
            return false;
        }
        return true;
    }

    private boolean createCaptureRequest() {
        Log.d(TAG, "createCaptureRequest");
        try {
            this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), null, null);
        }
        catch (CameraAccessException ex) {
            Log.e(TAG, "setRepeatingRequest: " + (Object)((Object)ex), new Object[0]);
            return false;
        }
        catch (IllegalArgumentException ex) {
            Log.e(TAG, "setRepeatingRequest: " + ex, new Object[0]);
            return false;
        }
        catch (SecurityException ex) {
            Log.e(TAG, "setRepeatingRequest: " + ex, new Object[0]);
            return false;
        }
        return true;
    }

    private static void readImageIntoBuffer(Image image, byte[] data) {
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        Image.Plane[] planes = image.getPlanes();
        int offset = 0;
        for (int plane = 0; plane < planes.length; ++plane) {
            int planeHeight;
            ByteBuffer buffer = planes[plane].getBuffer();
            int rowStride = planes[plane].getRowStride();
            int pixelStride = planes[plane].getPixelStride();
            int planeWidth = plane == 0 ? imageWidth : imageWidth / 2;
            int n = planeHeight = plane == 0 ? imageHeight : imageHeight / 2;
            if (pixelStride == 1 && rowStride == planeWidth) {
                buffer.get(data, offset, planeWidth * planeHeight);
                offset += planeWidth * planeHeight;
                continue;
            }
            byte[] rowData = new byte[rowStride];
            for (int row = 0; row < planeHeight - 1; ++row) {
                buffer.get(rowData, 0, rowStride);
                for (int col = 0; col < planeWidth; ++col) {
                    data[offset++] = rowData[col * pixelStride];
                }
            }
            buffer.get(rowData, 0, Math.min(rowStride, buffer.remaining()));
            for (int col = 0; col < planeWidth; ++col) {
                data[offset++] = rowData[col * pixelStride];
            }
        }
    }

    static boolean isLegacyDevice(Context appContext, int id2) {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(appContext, id2);
        return cameraCharacteristics != null && (Integer)cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL) == 2;
    }

    static int getNumberOfCameras(Context appContext) {
        CameraManager manager = (CameraManager)appContext.getSystemService("camera");
        try {
            return manager.getCameraIdList().length;
        }
        catch (CameraAccessException ex) {
            Log.e(TAG, "getNumberOfCameras: getCameraIdList(): " + (Object)((Object)ex), new Object[0]);
            return 0;
        }
    }

    static int getCaptureApiType(int id2, Context appContext) {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(appContext, id2);
        if (cameraCharacteristics == null) {
            return 5;
        }
        int supportedHWLevel = (Integer)cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
        switch (supportedHWLevel) {
            case 2: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 0: {
                return 3;
            }
        }
        return 1;
    }

    static String getName(int id2, Context appContext) {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(appContext, id2);
        if (cameraCharacteristics == null) {
            return null;
        }
        int facing = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
        return "camera2 " + id2 + ", facing " + (facing == 0 ? "front" : "back");
    }

    static VideoCaptureFormat[] getDeviceSupportedFormats(Context appContext, int id2) {
        int[] formats;
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(appContext, id2);
        if (cameraCharacteristics == null) {
            return null;
        }
        int[] capabilities = (int[])cameraCharacteristics.get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES);
        boolean minFrameDurationAvailable = false;
        for (int cap : capabilities) {
            if (cap != 1) continue;
            minFrameDurationAvailable = true;
            break;
        }
        ArrayList<VideoCaptureFormat> formatList = new ArrayList<VideoCaptureFormat>();
        StreamConfigurationMap streamMap = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        for (int format : formats = streamMap.getOutputFormats()) {
            Size[] sizes = streamMap.getOutputSizes(format);
            if (sizes == null) continue;
            for (Size size : sizes) {
                long minFrameDuration;
                double minFrameRate = 0.0;
                minFrameRate = minFrameDurationAvailable ? ((minFrameDuration = streamMap.getOutputMinFrameDuration(format, size)) == 0L ? 0.0 : 9.999999999999999E8 * (double)minFrameDuration) : 0.0;
                formatList.add(new VideoCaptureFormat(size.getWidth(), size.getHeight(), (int)minFrameRate, 0));
            }
        }
        return formatList.toArray(new VideoCaptureFormat[formatList.size()]);
    }

    VideoCaptureCamera2(Context context, int id2, long nativeVideoCaptureDeviceAndroid) {
        super(context, id2, nativeVideoCaptureDeviceAndroid);
    }

    @Override
    public boolean allocate(int width, int height, int frameRate) {
        Log.d(TAG, "allocate: requested (%d x %d) @%dfps", width, height, frameRate);
        if (this.mOpeningCamera || this.mConfiguringCamera) {
            Log.e(TAG, "allocate() invoked while Camera is busy opening/configuring.", new Object[0]);
            return false;
        }
        this.mCaptureFormat = new VideoCaptureFormat(width, height, frameRate, 35);
        int expectedFrameSize = this.mCaptureFormat.mWidth * this.mCaptureFormat.mHeight * ImageFormat.getBitsPerPixel((int)this.mCaptureFormat.mPixelFormat) / 8;
        this.mCapturedData = new byte[expectedFrameSize];
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        this.mCameraNativeOrientation = (Integer)cameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        this.mInvertDeviceOrientationReadings = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) == 1;
        return true;
    }

    @Override
    public boolean startCapture() {
        Log.d(TAG, "startCapture");
        this.mOpeningCamera = true;
        this.mConfiguringCamera = false;
        CameraManager manager = (CameraManager)this.mContext.getSystemService("camera");
        Handler mainHandler = new Handler(this.mContext.getMainLooper());
        CrStateListener stateListener = new CrStateListener();
        try {
            manager.openCamera(Integer.toString(this.mId), (CameraDevice.StateCallback)stateListener, mainHandler);
        }
        catch (CameraAccessException ex) {
            Log.e(TAG, "allocate: manager.openCamera: " + (Object)((Object)ex), new Object[0]);
            return false;
        }
        catch (IllegalArgumentException ex) {
            Log.e(TAG, "allocate: manager.openCamera: " + ex, new Object[0]);
            return false;
        }
        catch (SecurityException ex) {
            Log.e(TAG, "allocate: manager.openCamera: " + ex, new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean stopCapture() {
        Log.d(TAG, "stopCapture");
        if (this.mCaptureSession == null) {
            return false;
        }
        try {
            this.mCaptureSession.abortCaptures();
        }
        catch (CameraAccessException ex) {
            Log.e(TAG, "abortCaptures: " + (Object)((Object)ex), new Object[0]);
            return false;
        }
        catch (IllegalStateException ex) {
            Log.e(TAG, "abortCaptures: " + ex, new Object[0]);
            return false;
        }
        if (this.mCameraDevice == null) {
            return false;
        }
        this.mCameraDevice.close();
        return true;
    }

    @Override
    public void deallocate() {
        Log.d(TAG, "deallocate");
    }

    private class CrImageReaderListener
    implements ImageReader.OnImageAvailableListener {
        private CrImageReaderListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onImageAvailable(ImageReader reader) {
            try (Image image = null;){
                image = reader.acquireLatestImage();
                if (image == null) {
                    return;
                }
                if (image.getFormat() != 35 || image.getPlanes().length != 3) {
                    Log.e(VideoCaptureCamera2.TAG, "Unexpected image format: %d or #planes: %d", image.getFormat(), image.getPlanes().length);
                    return;
                }
                VideoCaptureCamera2.readImageIntoBuffer(image, VideoCaptureCamera2.this.mCapturedData);
                VideoCaptureCamera2.this.nativeOnFrameAvailable(VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid, VideoCaptureCamera2.this.mCapturedData, VideoCaptureCamera2.this.mCapturedData.length, VideoCaptureCamera2.this.getCameraRotation());
            }
        }
    }

    private class CrCaptureSessionListener
    extends CameraCaptureSession.StateCallback {
        private CrCaptureSessionListener() {
        }

        public void onConfigured(CameraCaptureSession cameraCaptureSession) {
            Log.d(VideoCaptureCamera2.TAG, "onConfigured");
            VideoCaptureCamera2.this.mCaptureSession = cameraCaptureSession;
            VideoCaptureCamera2.this.mConfiguringCamera = false;
            VideoCaptureCamera2.this.createCaptureRequest();
        }

        public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
            VideoCaptureCamera2.this.nativeOnError(VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid, "Camera session configuration error");
        }
    }

    private class CrStateListener
    extends CameraDevice.StateCallback {
        private CrStateListener() {
        }

        public void onOpened(CameraDevice cameraDevice) {
            VideoCaptureCamera2.this.mCameraDevice = cameraDevice;
            VideoCaptureCamera2.this.mOpeningCamera = false;
            VideoCaptureCamera2.this.mConfiguringCamera = true;
            if (!VideoCaptureCamera2.this.createCaptureObjects()) {
                VideoCaptureCamera2.this.mConfiguringCamera = false;
                VideoCaptureCamera2.this.nativeOnError(VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid, "Error configuring camera");
            }
        }

        public void onDisconnected(CameraDevice cameraDevice) {
            cameraDevice.close();
            VideoCaptureCamera2.this.mCameraDevice = null;
            VideoCaptureCamera2.this.mOpeningCamera = false;
        }

        public void onError(CameraDevice cameraDevice, int error) {
            cameraDevice.close();
            VideoCaptureCamera2.this.mCameraDevice = null;
            VideoCaptureCamera2.this.mOpeningCamera = false;
            VideoCaptureCamera2.this.nativeOnError(VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid, "Camera device error " + Integer.toString(error));
        }
    }
}

