/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import android.content.Context;
import android.os.Build;
import org.chromium.base.BuildInfo;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.Log;
import org.chromium.media.VideoCapture;
import org.chromium.media.VideoCaptureAndroid;
import org.chromium.media.VideoCaptureCamera2;
import org.chromium.media.VideoCaptureFormat;
import org.chromium.media.VideoCaptureTango;

@JNINamespace(value="media")
class VideoCaptureFactory {
    VideoCaptureFactory() {
    }

    private static boolean isLReleaseOrLater() {
        return Build.VERSION.SDK_INT >= 21;
    }

    @CalledByNative
    static VideoCapture createVideoCapture(Context context, int id2, long nativeVideoCaptureDeviceAndroid) {
        if (VideoCaptureFactory.isLReleaseOrLater() && !VideoCaptureCamera2.isLegacyDevice(context, id2)) {
            return new VideoCaptureCamera2(context, id2, nativeVideoCaptureDeviceAndroid);
        }
        if (!ChromiumCameraInfo.isSpecialCamera(id2)) {
            return new VideoCaptureAndroid(context, id2, nativeVideoCaptureDeviceAndroid);
        }
        return new VideoCaptureTango(context, ChromiumCameraInfo.toSpecialCameraId(id2), nativeVideoCaptureDeviceAndroid);
    }

    @CalledByNative
    static int getNumberOfCameras(Context appContext) {
        return ChromiumCameraInfo.getNumberOfCameras(appContext);
    }

    @CalledByNative
    static int getCaptureApiType(int id2, Context appContext) {
        if (VideoCaptureFactory.isLReleaseOrLater()) {
            return VideoCaptureCamera2.getCaptureApiType(id2, appContext);
        }
        if (ChromiumCameraInfo.isSpecialCamera(id2)) {
            return VideoCaptureTango.getCaptureApiType(ChromiumCameraInfo.toSpecialCameraId(id2));
        }
        return VideoCaptureAndroid.getCaptureApiType(id2);
    }

    @CalledByNative
    static String getDeviceName(int id2, Context appContext) {
        if (VideoCaptureFactory.isLReleaseOrLater() && !VideoCaptureCamera2.isLegacyDevice(appContext, id2)) {
            return VideoCaptureCamera2.getName(id2, appContext);
        }
        return ChromiumCameraInfo.isSpecialCamera(id2) ? VideoCaptureTango.getName(ChromiumCameraInfo.toSpecialCameraId(id2)) : VideoCaptureAndroid.getName(id2);
    }

    @CalledByNative
    static VideoCaptureFormat[] getDeviceSupportedFormats(Context appContext, int id2) {
        if (VideoCaptureFactory.isLReleaseOrLater() && !VideoCaptureCamera2.isLegacyDevice(appContext, id2)) {
            return VideoCaptureCamera2.getDeviceSupportedFormats(appContext, id2);
        }
        return ChromiumCameraInfo.isSpecialCamera(id2) ? VideoCaptureTango.getDeviceSupportedFormats(ChromiumCameraInfo.toSpecialCameraId(id2)) : VideoCaptureAndroid.getDeviceSupportedFormats(id2);
    }

    @CalledByNative
    static int getCaptureFormatWidth(VideoCaptureFormat format) {
        return format.getWidth();
    }

    @CalledByNative
    static int getCaptureFormatHeight(VideoCaptureFormat format) {
        return format.getHeight();
    }

    @CalledByNative
    static int getCaptureFormatFramerate(VideoCaptureFormat format) {
        return format.getFramerate();
    }

    @CalledByNative
    static int getCaptureFormatPixelFormat(VideoCaptureFormat format) {
        return format.getPixelFormat();
    }

    static class ChromiumCameraInfo {
        private static final String[][] SPECIAL_DEVICE_LIST = new String[][]{{"Peanut", "peanut"}};
        private static int sNumberOfSystemCameras = -1;
        private static final String TAG = "cr.media";

        ChromiumCameraInfo() {
        }

        private static boolean isSpecialDevice() {
            for (String[] device : SPECIAL_DEVICE_LIST) {
                if (!device[0].contentEquals(Build.MODEL) || !device[1].contentEquals(Build.DEVICE)) continue;
                return true;
            }
            return false;
        }

        private static boolean isSpecialCamera(int id2) {
            return id2 >= sNumberOfSystemCameras;
        }

        private static int toSpecialCameraId(int id2) {
            assert (ChromiumCameraInfo.isSpecialCamera(id2));
            return id2 - sNumberOfSystemCameras;
        }

        private static int getNumberOfCameras(Context appContext) {
            if (sNumberOfSystemCameras == -1) {
                if (!BuildInfo.isMncOrLater() && appContext.getPackageManager().checkPermission("android.permission.CAMERA", appContext.getPackageName()) != 0) {
                    sNumberOfSystemCameras = 0;
                    Log.w(TAG, "Missing android.permission.CAMERA permission, no system camera available.", new Object[0]);
                } else if (VideoCaptureFactory.isLReleaseOrLater()) {
                    sNumberOfSystemCameras = VideoCaptureCamera2.getNumberOfCameras(appContext);
                } else {
                    sNumberOfSystemCameras = VideoCaptureAndroid.getNumberOfCameras();
                    if (ChromiumCameraInfo.isSpecialDevice()) {
                        Log.d(TAG, "Special device: %s", Build.MODEL);
                        sNumberOfSystemCameras += VideoCaptureTango.numberOfCameras();
                    }
                }
            }
            return sNumberOfSystemCameras;
        }
    }
}

