/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import android.content.Context;
import android.hardware.Camera;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import org.chromium.base.Log;
import org.chromium.media.VideoCaptureCamera;
import org.chromium.media.VideoCaptureFormat;

public class VideoCaptureTango
extends VideoCaptureCamera {
    private ByteBuffer mFrameBuffer = null;
    private final int mTangoCameraId;
    private static final int DEPTH_CAMERA_ID = 0;
    private static final int FISHEYE_CAMERA_ID = 1;
    private static final int FOURMP_CAMERA_ID = 2;
    private static final CamParams[] CAM_PARAMS = new CamParams[]{new CamParams(0, "depth", 320, 240), new CamParams(1, "fisheye", 640, 480), new CamParams(2, "4MP", 1280, 720)};
    private static final int SF_WIDTH = 1280;
    private static final int SF_HEIGHT = 1168;
    private static final int SF_FULL_HEIGHT = 1752;
    private static final int SF_LINES_HEADER = 16;
    private static final int SF_LINES_FISHEYE = 240;
    private static final int SF_LINES_RESERVED = 80;
    private static final int SF_LINES_DEPTH = 60;
    private static final int SF_LINES_DEPTH_PADDED = 112;
    private static final int SF_LINES_BIGIMAGE = 720;
    private static final int SF_OFFSET_4MP_CHROMA = 112;
    private static final byte CHROMA_ZERO_LEVEL = 127;
    private static final String TAG = "cr.media";

    static int numberOfCameras() {
        return CAM_PARAMS.length;
    }

    static int getCaptureApiType(int index) {
        if (index >= CAM_PARAMS.length) {
            return 0;
        }
        return 4;
    }

    static String getName(int index) {
        if (index >= CAM_PARAMS.length) {
            return "";
        }
        return VideoCaptureTango.CAM_PARAMS[index].mName;
    }

    static VideoCaptureFormat[] getDeviceSupportedFormats(int id2) {
        ArrayList<VideoCaptureFormat> formatList = new ArrayList<VideoCaptureFormat>();
        if (id2 == 0) {
            formatList.add(new VideoCaptureFormat(320, 180, 5, 842094169));
        } else if (id2 == 1) {
            formatList.add(new VideoCaptureFormat(640, 480, 30, 842094169));
        } else if (id2 == 2) {
            formatList.add(new VideoCaptureFormat(1280, 720, 20, 842094169));
        }
        return formatList.toArray(new VideoCaptureFormat[formatList.size()]);
    }

    VideoCaptureTango(Context context, int id2, long nativeVideoCaptureDeviceAndroid) {
        super(context, 0, nativeVideoCaptureDeviceAndroid);
        this.mTangoCameraId = id2;
    }

    @Override
    protected void setCaptureParameters(int width, int height, int frameRate, Camera.Parameters cameraParameters) {
        this.mCaptureFormat = new VideoCaptureFormat(VideoCaptureTango.CAM_PARAMS[this.mTangoCameraId].mWidth, VideoCaptureTango.CAM_PARAMS[this.mTangoCameraId].mHeight, frameRate, 842094169);
        cameraParameters.set("sf-mode", "all");
    }

    @Override
    protected void allocateBuffers() {
        this.mFrameBuffer = ByteBuffer.allocateDirect(this.mCaptureFormat.mWidth * this.mCaptureFormat.mHeight * 3 / 2);
        Arrays.fill(this.mFrameBuffer.array(), (byte)127);
    }

    @Override
    protected void setPreviewCallback(Camera.PreviewCallback cb) {
        this.mCamera.setPreviewCallback(cb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPreviewFrame(byte[] data, Camera camera) {
        this.mPreviewBufferLock.lock();
        try {
            if (!this.mIsRunning) {
                return;
            }
            if (data.length == 2242560) {
                if (this.mTangoCameraId == 0) {
                    int startY;
                    int j;
                    int sizeY = 76800;
                    for (j = startY = 430080; j < startY + 2 * sizeY; j += 2) {
                        byte depthsample = (byte)(data[j + 1] << 4 | (data[j] & 0xF0) >> 4);
                        this.mFrameBuffer.put(depthsample);
                    }
                    for (j = 0; j < this.mCaptureFormat.mWidth * this.mCaptureFormat.mHeight - sizeY; ++j) {
                        this.mFrameBuffer.put((byte)0);
                    }
                } else if (this.mTangoCameraId == 1) {
                    int sizeY = 307200;
                    int startY = 20480;
                    ByteBuffer.wrap(data, startY, sizeY).get(this.mFrameBuffer.array(), 0, sizeY);
                } else if (this.mTangoCameraId == 2) {
                    int startY = 573440;
                    int sizeY = 921600;
                    int startU = 0x190000;
                    int sizeU = 230400;
                    int startV = 2012160;
                    int sizeV = 230400;
                    ByteBuffer.wrap(data, startY, sizeY).get(this.mFrameBuffer.array(), 0, sizeY);
                    ByteBuffer.wrap(data, startU, sizeU).get(this.mFrameBuffer.array(), sizeY, sizeU);
                    ByteBuffer.wrap(data, startV, sizeV).get(this.mFrameBuffer.array(), sizeY + sizeU, sizeV);
                } else {
                    Log.e(TAG, "Unknown camera, #id: %d", this.mTangoCameraId);
                    return;
                }
                this.mFrameBuffer.rewind();
                this.nativeOnFrameAvailable(this.mNativeVideoCaptureDeviceAndroid, this.mFrameBuffer.array(), this.mFrameBuffer.capacity(), this.getCameraRotation());
            }
        }
        finally {
            this.mPreviewBufferLock.unlock();
        }
    }

    private static class CamParams {
        final int mId;
        final String mName;
        final int mWidth;
        final int mHeight;

        CamParams(int id2, String name, int width, int height) {
            this.mId = id2;
            this.mName = name;
            this.mWidth = width;
            this.mHeight = height;
        }
    }
}

