/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojo.bindings;

import java.util.concurrent.Executor;
import org.chromium.mojo.bindings.ConnectionErrorHandler;
import org.chromium.mojo.bindings.ExecutorFactory;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.MessageReceiver;
import org.chromium.mojo.bindings.MessageReceiverWithResponder;
import org.chromium.mojo.bindings.Router;
import org.chromium.mojo.system.Core;
import org.chromium.mojo.system.MessagePipeHandle;

class AutoCloseableRouter
implements Router {
    private final Router mRouter;
    private final Executor mExecutor;
    private boolean mClosed;

    public AutoCloseableRouter(Core core, Router router) {
        this.mRouter = router;
        this.mExecutor = ExecutorFactory.getExecutorForCurrentThread(core);
    }

    @Override
    public void setIncomingMessageReceiver(MessageReceiverWithResponder incomingMessageReceiver) {
        this.mRouter.setIncomingMessageReceiver(incomingMessageReceiver);
    }

    @Override
    public MessagePipeHandle passHandle() {
        return (MessagePipeHandle)this.mRouter.passHandle();
    }

    @Override
    public boolean accept(Message message) {
        return this.mRouter.accept(message);
    }

    @Override
    public boolean acceptWithResponder(Message message, MessageReceiver responder) {
        return this.mRouter.acceptWithResponder(message, responder);
    }

    @Override
    public void start() {
        this.mRouter.start();
    }

    @Override
    public void setErrorHandler(ConnectionErrorHandler errorHandler) {
        this.mRouter.setErrorHandler(errorHandler);
    }

    @Override
    public void close() {
        this.mRouter.close();
        this.mClosed = true;
    }

    protected void finalize() throws Throwable {
        if (!this.mClosed) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    AutoCloseableRouter.this.close();
                }
            });
            throw new IllegalStateException("Warning: Router objects should be explicitly closed when no longer required otherwise you may leak handles.");
        }
        super.finalize();
    }
}

