/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojo.bindings;

import java.nio.ByteOrder;
import java.nio.charset.Charset;
import org.chromium.mojo.bindings.BindingsHelper;
import org.chromium.mojo.bindings.DataHeader;
import org.chromium.mojo.bindings.DeserializationException;
import org.chromium.mojo.bindings.Interface;
import org.chromium.mojo.bindings.InterfaceRequest;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.system.DataPipe;
import org.chromium.mojo.system.Handle;
import org.chromium.mojo.system.InvalidHandle;
import org.chromium.mojo.system.MessagePipeHandle;
import org.chromium.mojo.system.SharedBufferHandle;
import org.chromium.mojo.system.UntypedHandle;

public class Decoder {
    private final Message mMessage;
    private final int mBaseOffset;
    private final Validator mValidator;

    public Decoder(Message message) {
        this(message, new Validator(message.getData().limit(), message.getHandles().size()), 0);
    }

    private Decoder(Message message, Validator validator, int baseOffset) {
        this.mMessage = message;
        this.mMessage.getData().order(ByteOrder.LITTLE_ENDIAN);
        this.mBaseOffset = baseOffset;
        this.mValidator = validator;
    }

    public DataHeader readDataHeader() {
        this.mValidator.claimMemory(this.mBaseOffset, this.mBaseOffset + 8);
        DataHeader result = this.readDataHeaderAtOffset(0, false);
        this.mValidator.claimMemory(this.mBaseOffset + 8, this.mBaseOffset + result.size);
        return result;
    }

    public DataHeader readDataHeaderForUnion(int offset) {
        DataHeader result = this.readDataHeaderAtOffset(offset, true);
        if (result.size == 0) {
            if (result.elementsOrVersion != 0) {
                throw new DeserializationException("Unexpected version tag for a null union. Expecting 0, found: " + result.elementsOrVersion);
            }
        } else if (result.size != 16) {
            throw new DeserializationException("Unexpected size of an union. The size must be 0 for a null union, or 16 for a non-null union.");
        }
        return result;
    }

    public Decoder decoderForSerializedUnion() {
        this.mValidator.claimMemory(0L, 16L);
        return this;
    }

    private DataHeader readDataHeaderAtOffset(int offset, boolean isUnion) {
        int size = this.readInt(offset + 0);
        int elementsOrVersion = this.readInt(offset + 4);
        if (size < 0) {
            throw new DeserializationException("Negative size. Unsigned integers are not valid for java.");
        }
        if (!(elementsOrVersion >= 0 || isUnion && elementsOrVersion == -1)) {
            throw new DeserializationException("Negative elements or version. Unsigned integers are not valid for java.");
        }
        return new DataHeader(size, elementsOrVersion);
    }

    public DataHeader readAndValidateDataHeader(DataHeader[] versionArray) {
        DataHeader header = this.readDataHeader();
        int maxVersionIndex = versionArray.length - 1;
        if (header.elementsOrVersion <= versionArray[maxVersionIndex].elementsOrVersion) {
            DataHeader referenceHeader = null;
            for (int index = maxVersionIndex; index >= 0; --index) {
                DataHeader dataHeader = versionArray[index];
                if (header.elementsOrVersion < dataHeader.elementsOrVersion) continue;
                referenceHeader = dataHeader;
                break;
            }
            if (referenceHeader == null || referenceHeader.size != header.size) {
                throw new DeserializationException("Header doesn't correspond to any known version.");
            }
        } else if (header.size < versionArray[maxVersionIndex].size) {
            throw new DeserializationException("Message newer than the last known version cannot be shorter than required by the last known version.");
        }
        return header;
    }

    public DataHeader readDataHeaderForPointerArray(int expectedLength) {
        return this.readDataHeaderForArray(8L, expectedLength);
    }

    public DataHeader readDataHeaderForUnionArray(int expectedLength) {
        return this.readDataHeaderForArray(16L, expectedLength);
    }

    public void readDataHeaderForMap() {
        DataHeader si = this.readDataHeader();
        if (si.size != BindingsHelper.MAP_STRUCT_HEADER.size) {
            throw new DeserializationException("Incorrect header for map. The size is incorrect.");
        }
        if (si.elementsOrVersion != BindingsHelper.MAP_STRUCT_HEADER.elementsOrVersion) {
            throw new DeserializationException("Incorrect header for map. The version is incorrect.");
        }
    }

    public byte readByte(int offset) {
        this.validateBufferSize(offset, 1);
        return this.mMessage.getData().get(this.mBaseOffset + offset);
    }

    public boolean readBoolean(int offset, int bit) {
        this.validateBufferSize(offset, 1);
        return (this.readByte(offset) & 1 << bit) != 0;
    }

    public short readShort(int offset) {
        this.validateBufferSize(offset, 2);
        return this.mMessage.getData().getShort(this.mBaseOffset + offset);
    }

    public int readInt(int offset) {
        this.validateBufferSize(offset, 4);
        return this.mMessage.getData().getInt(this.mBaseOffset + offset);
    }

    public float readFloat(int offset) {
        this.validateBufferSize(offset, 4);
        return this.mMessage.getData().getFloat(this.mBaseOffset + offset);
    }

    public long readLong(int offset) {
        this.validateBufferSize(offset, 8);
        return this.mMessage.getData().getLong(this.mBaseOffset + offset);
    }

    public double readDouble(int offset) {
        this.validateBufferSize(offset, 8);
        return this.mMessage.getData().getDouble(this.mBaseOffset + offset);
    }

    public Decoder readPointer(int offset, boolean nullable) {
        int basePosition = this.mBaseOffset + offset;
        long pointerOffset = this.readLong(offset);
        if (pointerOffset == 0L) {
            if (!nullable) {
                throw new DeserializationException("Trying to decode null pointer for a non-nullable type.");
            }
            return null;
        }
        int newPosition = (int)((long)basePosition + pointerOffset);
        return this.getDecoderAtPosition(newPosition);
    }

    public boolean[] readBooleans(int offset, int arrayNullability, int expectedLength) {
        Decoder d = this.readPointer(offset, BindingsHelper.isArrayNullable(arrayNullability));
        if (d == null) {
            return null;
        }
        DataHeader si = d.readDataHeaderForBooleanArray(expectedLength);
        byte[] bytes = new byte[(si.elementsOrVersion + 7) / 8];
        d.mMessage.getData().position(d.mBaseOffset + 8);
        d.mMessage.getData().get(bytes);
        boolean[] result = new boolean[si.elementsOrVersion];
        for (int i = 0; i < bytes.length; ++i) {
            for (int j = 0; j < 8; ++j) {
                int booleanIndex = i * 8 + j;
                if (booleanIndex >= result.length) continue;
                result[booleanIndex] = (bytes[i] & 1 << j) != 0;
            }
        }
        return result;
    }

    public byte[] readBytes(int offset, int arrayNullability, int expectedLength) {
        Decoder d = this.readPointer(offset, BindingsHelper.isArrayNullable(arrayNullability));
        if (d == null) {
            return null;
        }
        DataHeader si = d.readDataHeaderForArray(1L, expectedLength);
        byte[] result = new byte[si.elementsOrVersion];
        d.mMessage.getData().position(d.mBaseOffset + 8);
        d.mMessage.getData().get(result);
        return result;
    }

    public short[] readShorts(int offset, int arrayNullability, int expectedLength) {
        Decoder d = this.readPointer(offset, BindingsHelper.isArrayNullable(arrayNullability));
        if (d == null) {
            return null;
        }
        DataHeader si = d.readDataHeaderForArray(2L, expectedLength);
        short[] result = new short[si.elementsOrVersion];
        d.mMessage.getData().position(d.mBaseOffset + 8);
        d.mMessage.getData().asShortBuffer().get(result);
        return result;
    }

    public int[] readInts(int offset, int arrayNullability, int expectedLength) {
        Decoder d = this.readPointer(offset, BindingsHelper.isArrayNullable(arrayNullability));
        if (d == null) {
            return null;
        }
        DataHeader si = d.readDataHeaderForArray(4L, expectedLength);
        int[] result = new int[si.elementsOrVersion];
        d.mMessage.getData().position(d.mBaseOffset + 8);
        d.mMessage.getData().asIntBuffer().get(result);
        return result;
    }

    public float[] readFloats(int offset, int arrayNullability, int expectedLength) {
        Decoder d = this.readPointer(offset, BindingsHelper.isArrayNullable(arrayNullability));
        if (d == null) {
            return null;
        }
        DataHeader si = d.readDataHeaderForArray(4L, expectedLength);
        float[] result = new float[si.elementsOrVersion];
        d.mMessage.getData().position(d.mBaseOffset + 8);
        d.mMessage.getData().asFloatBuffer().get(result);
        return result;
    }

    public long[] readLongs(int offset, int arrayNullability, int expectedLength) {
        Decoder d = this.readPointer(offset, BindingsHelper.isArrayNullable(arrayNullability));
        if (d == null) {
            return null;
        }
        DataHeader si = d.readDataHeaderForArray(8L, expectedLength);
        long[] result = new long[si.elementsOrVersion];
        d.mMessage.getData().position(d.mBaseOffset + 8);
        d.mMessage.getData().asLongBuffer().get(result);
        return result;
    }

    public double[] readDoubles(int offset, int arrayNullability, int expectedLength) {
        Decoder d = this.readPointer(offset, BindingsHelper.isArrayNullable(arrayNullability));
        if (d == null) {
            return null;
        }
        DataHeader si = d.readDataHeaderForArray(8L, expectedLength);
        double[] result = new double[si.elementsOrVersion];
        d.mMessage.getData().position(d.mBaseOffset + 8);
        d.mMessage.getData().asDoubleBuffer().get(result);
        return result;
    }

    public Handle readHandle(int offset, boolean nullable) {
        int index = this.readInt(offset);
        if (index == -1) {
            if (!nullable) {
                throw new DeserializationException("Trying to decode an invalid handle for a non-nullable type.");
            }
            return InvalidHandle.INSTANCE;
        }
        this.mValidator.claimHandle(index);
        return this.mMessage.getHandles().get(index);
    }

    public UntypedHandle readUntypedHandle(int offset, boolean nullable) {
        return this.readHandle(offset, nullable).toUntypedHandle();
    }

    public DataPipe.ConsumerHandle readConsumerHandle(int offset, boolean nullable) {
        return this.readUntypedHandle(offset, nullable).toDataPipeConsumerHandle();
    }

    public DataPipe.ProducerHandle readProducerHandle(int offset, boolean nullable) {
        return this.readUntypedHandle(offset, nullable).toDataPipeProducerHandle();
    }

    public MessagePipeHandle readMessagePipeHandle(int offset, boolean nullable) {
        return this.readUntypedHandle(offset, nullable).toMessagePipeHandle();
    }

    public SharedBufferHandle readSharedBufferHandle(int offset, boolean nullable) {
        return this.readUntypedHandle(offset, nullable).toSharedBufferHandle();
    }

    public <P extends Interface.Proxy> P readServiceInterface(int offset, boolean nullable, Interface.Manager<?, P> manager) {
        MessagePipeHandle handle = this.readMessagePipeHandle(offset, nullable);
        if (!handle.isValid()) {
            return null;
        }
        int version = this.readInt(offset + 4);
        return manager.attachProxy(handle, version);
    }

    public <I extends Interface> InterfaceRequest<I> readInterfaceRequest(int offset, boolean nullable) {
        MessagePipeHandle handle = this.readMessagePipeHandle(offset, nullable);
        if (handle == null) {
            return null;
        }
        return new InterfaceRequest(handle);
    }

    public String readString(int offset, boolean nullable) {
        int arrayNullability = nullable ? 1 : 0;
        byte[] bytes = this.readBytes(offset, arrayNullability, -1);
        if (bytes == null) {
            return null;
        }
        return new String(bytes, Charset.forName("utf8"));
    }

    public Handle[] readHandles(int offset, int arrayNullability, int expectedLength) {
        Decoder d = this.readPointer(offset, BindingsHelper.isArrayNullable(arrayNullability));
        if (d == null) {
            return null;
        }
        DataHeader si = d.readDataHeaderForArray(4L, expectedLength);
        Handle[] result = new Handle[si.elementsOrVersion];
        for (int i = 0; i < result.length; ++i) {
            result[i] = d.readHandle(8 + 4 * i, BindingsHelper.isElementNullable(arrayNullability));
        }
        return result;
    }

    public UntypedHandle[] readUntypedHandles(int offset, int arrayNullability, int expectedLength) {
        Decoder d = this.readPointer(offset, BindingsHelper.isArrayNullable(arrayNullability));
        if (d == null) {
            return null;
        }
        DataHeader si = d.readDataHeaderForArray(4L, expectedLength);
        UntypedHandle[] result = new UntypedHandle[si.elementsOrVersion];
        for (int i = 0; i < result.length; ++i) {
            result[i] = d.readUntypedHandle(8 + 4 * i, BindingsHelper.isElementNullable(arrayNullability));
        }
        return result;
    }

    public DataPipe.ConsumerHandle[] readConsumerHandles(int offset, int arrayNullability, int expectedLength) {
        Decoder d = this.readPointer(offset, BindingsHelper.isArrayNullable(arrayNullability));
        if (d == null) {
            return null;
        }
        DataHeader si = d.readDataHeaderForArray(4L, expectedLength);
        DataPipe.ConsumerHandle[] result = new DataPipe.ConsumerHandle[si.elementsOrVersion];
        for (int i = 0; i < result.length; ++i) {
            result[i] = d.readConsumerHandle(8 + 4 * i, BindingsHelper.isElementNullable(arrayNullability));
        }
        return result;
    }

    public DataPipe.ProducerHandle[] readProducerHandles(int offset, int arrayNullability, int expectedLength) {
        Decoder d = this.readPointer(offset, BindingsHelper.isArrayNullable(arrayNullability));
        if (d == null) {
            return null;
        }
        DataHeader si = d.readDataHeaderForArray(4L, expectedLength);
        DataPipe.ProducerHandle[] result = new DataPipe.ProducerHandle[si.elementsOrVersion];
        for (int i = 0; i < result.length; ++i) {
            result[i] = d.readProducerHandle(8 + 4 * i, BindingsHelper.isElementNullable(arrayNullability));
        }
        return result;
    }

    public MessagePipeHandle[] readMessagePipeHandles(int offset, int arrayNullability, int expectedLength) {
        Decoder d = this.readPointer(offset, BindingsHelper.isArrayNullable(arrayNullability));
        if (d == null) {
            return null;
        }
        DataHeader si = d.readDataHeaderForArray(4L, expectedLength);
        MessagePipeHandle[] result = new MessagePipeHandle[si.elementsOrVersion];
        for (int i = 0; i < result.length; ++i) {
            result[i] = d.readMessagePipeHandle(8 + 4 * i, BindingsHelper.isElementNullable(arrayNullability));
        }
        return result;
    }

    public SharedBufferHandle[] readSharedBufferHandles(int offset, int arrayNullability, int expectedLength) {
        Decoder d = this.readPointer(offset, BindingsHelper.isArrayNullable(arrayNullability));
        if (d == null) {
            return null;
        }
        DataHeader si = d.readDataHeaderForArray(4L, expectedLength);
        SharedBufferHandle[] result = new SharedBufferHandle[si.elementsOrVersion];
        for (int i = 0; i < result.length; ++i) {
            result[i] = d.readSharedBufferHandle(8 + 4 * i, BindingsHelper.isElementNullable(arrayNullability));
        }
        return result;
    }

    public <S extends Interface, P extends Interface.Proxy> S[] readServiceInterfaces(int offset, int arrayNullability, int expectedLength, Interface.Manager<S, P> manager) {
        Decoder d = this.readPointer(offset, BindingsHelper.isArrayNullable(arrayNullability));
        if (d == null) {
            return null;
        }
        DataHeader si = d.readDataHeaderForArray(8L, expectedLength);
        Interface[] result = manager.buildArray(si.elementsOrVersion);
        for (int i = 0; i < result.length; ++i) {
            P value = d.readServiceInterface(8 + 8 * i, BindingsHelper.isElementNullable(arrayNullability), manager);
            result[i] = value;
        }
        return result;
    }

    public <I extends Interface> InterfaceRequest<I>[] readInterfaceRequests(int offset, int arrayNullability, int expectedLength) {
        Decoder d = this.readPointer(offset, BindingsHelper.isArrayNullable(arrayNullability));
        if (d == null) {
            return null;
        }
        DataHeader si = d.readDataHeaderForArray(4L, expectedLength);
        InterfaceRequest[] result = new InterfaceRequest[si.elementsOrVersion];
        for (int i = 0; i < result.length; ++i) {
            result[i] = d.readInterfaceRequest(8 + 4 * i, BindingsHelper.isElementNullable(arrayNullability));
        }
        return result;
    }

    private Decoder getDecoderAtPosition(int offset) {
        return new Decoder(this.mMessage, this.mValidator, offset);
    }

    private DataHeader readDataHeaderForBooleanArray(int expectedLength) {
        DataHeader dataHeader = this.readDataHeader();
        if (dataHeader.size < 8 + (dataHeader.elementsOrVersion + 7) / 8) {
            throw new DeserializationException("Array header is incorrect.");
        }
        if (expectedLength != -1 && dataHeader.elementsOrVersion != expectedLength) {
            throw new DeserializationException("Incorrect array length. Expected: " + expectedLength + ", but got: " + dataHeader.elementsOrVersion + ".");
        }
        return dataHeader;
    }

    private DataHeader readDataHeaderForArray(long elementSize, int expectedLength) {
        DataHeader dataHeader = this.readDataHeader();
        if ((long)dataHeader.size < 8L + elementSize * (long)dataHeader.elementsOrVersion) {
            throw new DeserializationException("Array header is incorrect.");
        }
        if (expectedLength != -1 && dataHeader.elementsOrVersion != expectedLength) {
            throw new DeserializationException("Incorrect array length. Expected: " + expectedLength + ", but got: " + dataHeader.elementsOrVersion + ".");
        }
        return dataHeader;
    }

    private void validateBufferSize(int offset, int size) {
        if (this.mMessage.getData().limit() < offset + size) {
            throw new DeserializationException("Buffer is smaller than expected.");
        }
    }

    static final class Validator {
        private int mMinNextClaimedHandle = 0;
        private long mMinNextMemory = 0L;
        private final long mMaxMemory;
        private final long mNumberOfHandles;

        Validator(long maxMemory, int numberOfHandles) {
            this.mMaxMemory = maxMemory;
            this.mNumberOfHandles = numberOfHandles;
        }

        public void claimHandle(int handle) {
            if (handle < this.mMinNextClaimedHandle) {
                throw new DeserializationException("Trying to access handle out of order.");
            }
            if ((long)handle >= this.mNumberOfHandles) {
                throw new DeserializationException("Trying to access non present handle.");
            }
            this.mMinNextClaimedHandle = handle + 1;
        }

        public void claimMemory(long start, long end) {
            if (start % 8L != 0L) {
                throw new DeserializationException("Incorrect starting alignment: " + start + ".");
            }
            if (start < this.mMinNextMemory) {
                throw new DeserializationException("Trying to access memory out of order.");
            }
            if (end < start) {
                throw new DeserializationException("Incorrect memory range.");
            }
            if (end > this.mMaxMemory) {
                throw new DeserializationException("Trying to access out of range memory.");
            }
            this.mMinNextMemory = BindingsHelper.align(end);
        }
    }
}

