/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojo.bindings;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.chromium.mojo.bindings.BindingsHelper;
import org.chromium.mojo.bindings.DataHeader;
import org.chromium.mojo.bindings.Interface;
import org.chromium.mojo.bindings.InterfaceRequest;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.SerializationException;
import org.chromium.mojo.bindings.Struct;
import org.chromium.mojo.bindings.Union;
import org.chromium.mojo.system.Core;
import org.chromium.mojo.system.Handle;
import org.chromium.mojo.system.MessagePipeHandle;
import org.chromium.mojo.system.Pair;

public class Encoder {
    private static final int INITIAL_BUFFER_SIZE = 1024;
    private int mBaseOffset;
    private final EncoderState mEncoderState;

    public Message getMessage() {
        this.mEncoderState.byteBuffer.position(0);
        this.mEncoderState.byteBuffer.limit(this.mEncoderState.dataEnd);
        return new Message(this.mEncoderState.byteBuffer, this.mEncoderState.handles);
    }

    public Encoder(Core core, int sizeHint) {
        this(new EncoderState(core, sizeHint));
    }

    private Encoder(EncoderState bufferInformation) {
        this.mEncoderState = bufferInformation;
        this.mBaseOffset = bufferInformation.dataEnd;
    }

    public Encoder getEncoderAtDataOffset(DataHeader dataHeader) {
        Encoder result = new Encoder(this.mEncoderState);
        result.encode(dataHeader);
        return result;
    }

    public void encode(DataHeader s) {
        this.mEncoderState.claimMemory(BindingsHelper.align(s.size));
        this.encode(s.size, 0);
        this.encode(s.elementsOrVersion, 4);
    }

    public void encode(byte v, int offset) {
        this.mEncoderState.byteBuffer.put(this.mBaseOffset + offset, v);
    }

    public void encode(boolean v, int offset, int bit) {
        if (v) {
            byte encodedValue = this.mEncoderState.byteBuffer.get(this.mBaseOffset + offset);
            encodedValue = (byte)(encodedValue | 1 << bit);
            this.mEncoderState.byteBuffer.put(this.mBaseOffset + offset, encodedValue);
        }
    }

    public void encode(short v, int offset) {
        this.mEncoderState.byteBuffer.putShort(this.mBaseOffset + offset, v);
    }

    public void encode(int v, int offset) {
        this.mEncoderState.byteBuffer.putInt(this.mBaseOffset + offset, v);
    }

    public void encode(float v, int offset) {
        this.mEncoderState.byteBuffer.putFloat(this.mBaseOffset + offset, v);
    }

    public void encode(long v, int offset) {
        this.mEncoderState.byteBuffer.putLong(this.mBaseOffset + offset, v);
    }

    public void encode(double v, int offset) {
        this.mEncoderState.byteBuffer.putDouble(this.mBaseOffset + offset, v);
    }

    public void encode(Struct v, int offset, boolean nullable) {
        if (v == null) {
            this.encodeNullPointer(offset, nullable);
            return;
        }
        this.encodePointerToNextUnclaimedData(offset);
        v.encode(this);
    }

    public void encode(Union v, int offset, boolean nullable) {
        if (v == null && !nullable) {
            throw new SerializationException("Trying to encode a null pointer for a non-nullable type.");
        }
        if (v == null) {
            this.encode(0L, offset);
            this.encode(0L, offset + 8);
            return;
        }
        v.encode(this, offset);
    }

    public void encode(String v, int offset, boolean nullable) {
        if (v == null) {
            this.encodeNullPointer(offset, nullable);
            return;
        }
        int arrayNullability = nullable ? 1 : 0;
        this.encode(v.getBytes(Charset.forName("utf8")), offset, arrayNullability, -1);
    }

    public void encode(Handle v, int offset, boolean nullable) {
        if (v == null || !v.isValid()) {
            this.encodeInvalidHandle(offset, nullable);
        } else {
            this.encode(this.mEncoderState.handles.size(), offset);
            this.mEncoderState.handles.add(v);
        }
    }

    public <T extends Interface> void encode(T v, int offset, boolean nullable, Interface.Manager<T, ?> manager) {
        if (v == null) {
            this.encodeInvalidHandle(offset, nullable);
            this.encode(0, offset + 4);
            return;
        }
        if (this.mEncoderState.core == null) {
            throw new UnsupportedOperationException("The encoder has been created without a Core. It can't encode an interface.");
        }
        if (v instanceof Interface.Proxy) {
            Interface.Proxy.Handler handler = ((Interface.Proxy)v).getProxyHandler();
            this.encode(handler.passHandle(), offset, nullable);
            this.encode(handler.getVersion(), offset + 4);
            return;
        }
        Pair<MessagePipeHandle, MessagePipeHandle> handles = this.mEncoderState.core.createMessagePipe(null);
        manager.bind(v, (MessagePipeHandle)handles.first);
        this.encode((Handle)handles.second, offset, nullable);
        this.encode(manager.getVersion(), offset + 4);
    }

    public <I extends Interface> void encode(InterfaceRequest<I> v, int offset, boolean nullable) {
        if (v == null) {
            this.encodeInvalidHandle(offset, nullable);
            return;
        }
        if (this.mEncoderState.core == null) {
            throw new UnsupportedOperationException("The encoder has been created without a Core. It can't encode an interface.");
        }
        this.encode(v.passHandle(), offset, nullable);
    }

    public Encoder encodePointerArray(int length, int offset, int expectedLength) {
        return this.encoderForArray(8, length, offset, expectedLength);
    }

    public Encoder encodeUnionArray(int length, int offset, int expectedLength) {
        return this.encoderForArray(16, length, offset, expectedLength);
    }

    public void encode(boolean[] v, int offset, int arrayNullability, int expectedLength) {
        if (v == null) {
            this.encodeNullPointer(offset, BindingsHelper.isArrayNullable(arrayNullability));
            return;
        }
        if (expectedLength != -1 && expectedLength != v.length) {
            throw new SerializationException("Trying to encode a fixed array of incorrect length.");
        }
        byte[] bytes = new byte[(v.length + 7) / 8];
        for (int i = 0; i < bytes.length; ++i) {
            for (int j = 0; j < 8; ++j) {
                int booleanIndex = 8 * i + j;
                if (booleanIndex >= v.length || !v[booleanIndex]) continue;
                int n = i;
                bytes[n] = (byte)(bytes[n] | 1 << j);
            }
        }
        this.encodeByteArray(bytes, v.length, offset);
    }

    public void encode(byte[] v, int offset, int arrayNullability, int expectedLength) {
        if (v == null) {
            this.encodeNullPointer(offset, BindingsHelper.isArrayNullable(arrayNullability));
            return;
        }
        if (expectedLength != -1 && expectedLength != v.length) {
            throw new SerializationException("Trying to encode a fixed array of incorrect length.");
        }
        this.encodeByteArray(v, v.length, offset);
    }

    public void encode(short[] v, int offset, int arrayNullability, int expectedLength) {
        if (v == null) {
            this.encodeNullPointer(offset, BindingsHelper.isArrayNullable(arrayNullability));
            return;
        }
        this.encoderForArray(2, v.length, offset, expectedLength).append(v);
    }

    public void encode(int[] v, int offset, int arrayNullability, int expectedLength) {
        if (v == null) {
            this.encodeNullPointer(offset, BindingsHelper.isArrayNullable(arrayNullability));
            return;
        }
        this.encoderForArray(4, v.length, offset, expectedLength).append(v);
    }

    public void encode(float[] v, int offset, int arrayNullability, int expectedLength) {
        if (v == null) {
            this.encodeNullPointer(offset, BindingsHelper.isArrayNullable(arrayNullability));
            return;
        }
        this.encoderForArray(4, v.length, offset, expectedLength).append(v);
    }

    public void encode(long[] v, int offset, int arrayNullability, int expectedLength) {
        if (v == null) {
            this.encodeNullPointer(offset, BindingsHelper.isArrayNullable(arrayNullability));
            return;
        }
        this.encoderForArray(8, v.length, offset, expectedLength).append(v);
    }

    public void encode(double[] v, int offset, int arrayNullability, int expectedLength) {
        if (v == null) {
            this.encodeNullPointer(offset, BindingsHelper.isArrayNullable(arrayNullability));
            return;
        }
        this.encoderForArray(8, v.length, offset, expectedLength).append(v);
    }

    public void encode(Handle[] v, int offset, int arrayNullability, int expectedLength) {
        if (v == null) {
            this.encodeNullPointer(offset, BindingsHelper.isArrayNullable(arrayNullability));
            return;
        }
        Encoder e = this.encoderForArray(4, v.length, offset, expectedLength);
        for (int i = 0; i < v.length; ++i) {
            e.encode(v[i], 8 + 4 * i, BindingsHelper.isElementNullable(arrayNullability));
        }
    }

    public <T extends Interface> void encode(T[] v, int offset, int arrayNullability, int expectedLength, Interface.Manager<T, ?> manager) {
        if (v == null) {
            this.encodeNullPointer(offset, BindingsHelper.isArrayNullable(arrayNullability));
            return;
        }
        Encoder e = this.encoderForArray(8, v.length, offset, expectedLength);
        for (int i = 0; i < v.length; ++i) {
            e.encode(v[i], 8 + 8 * i, BindingsHelper.isElementNullable(arrayNullability), manager);
        }
    }

    public Encoder encoderForMap(int offset) {
        this.encodePointerToNextUnclaimedData(offset);
        return this.getEncoderAtDataOffset(BindingsHelper.MAP_STRUCT_HEADER);
    }

    public Encoder encoderForUnionPointer(int offset) {
        this.encodePointerToNextUnclaimedData(offset);
        Encoder result = new Encoder(this.mEncoderState);
        result.mEncoderState.claimMemory(16);
        return result;
    }

    public <I extends Interface> void encode(InterfaceRequest<I>[] v, int offset, int arrayNullability, int expectedLength) {
        if (v == null) {
            this.encodeNullPointer(offset, BindingsHelper.isArrayNullable(arrayNullability));
            return;
        }
        Encoder e = this.encoderForArray(4, v.length, offset, expectedLength);
        for (int i = 0; i < v.length; ++i) {
            e.encode(v[i], 8 + 4 * i, BindingsHelper.isElementNullable(arrayNullability));
        }
    }

    public void encodeNullPointer(int offset, boolean nullable) {
        if (!nullable) {
            throw new SerializationException("Trying to encode a null pointer for a non-nullable type.");
        }
        this.mEncoderState.byteBuffer.putLong(this.mBaseOffset + offset, 0L);
    }

    public void encodeInvalidHandle(int offset, boolean nullable) {
        if (!nullable) {
            throw new SerializationException("Trying to encode an invalid handle for a non-nullable type.");
        }
        this.mEncoderState.byteBuffer.putInt(this.mBaseOffset + offset, -1);
    }

    void claimMemory(int size) {
        this.mEncoderState.claimMemory(BindingsHelper.align(size));
    }

    private void encodePointerToNextUnclaimedData(int offset) {
        this.encode((long)this.mEncoderState.dataEnd - (long)(this.mBaseOffset + offset), offset);
    }

    private Encoder encoderForArray(int elementSizeInByte, int length, int offset, int expectedLength) {
        if (expectedLength != -1 && expectedLength != length) {
            throw new SerializationException("Trying to encode a fixed array of incorrect length.");
        }
        return this.encoderForArrayByTotalSize(length * elementSizeInByte, length, offset);
    }

    private Encoder encoderForArrayByTotalSize(int byteSize, int length, int offset) {
        this.encodePointerToNextUnclaimedData(offset);
        return this.getEncoderAtDataOffset(new DataHeader(8 + byteSize, length));
    }

    private void encodeByteArray(byte[] bytes, int length, int offset) {
        this.encoderForArrayByTotalSize(bytes.length, length, offset).append(bytes);
    }

    private void append(byte[] v) {
        this.mEncoderState.byteBuffer.position(this.mBaseOffset + 8);
        this.mEncoderState.byteBuffer.put(v);
    }

    private void append(short[] v) {
        this.mEncoderState.byteBuffer.position(this.mBaseOffset + 8);
        this.mEncoderState.byteBuffer.asShortBuffer().put(v);
    }

    private void append(int[] v) {
        this.mEncoderState.byteBuffer.position(this.mBaseOffset + 8);
        this.mEncoderState.byteBuffer.asIntBuffer().put(v);
    }

    private void append(float[] v) {
        this.mEncoderState.byteBuffer.position(this.mBaseOffset + 8);
        this.mEncoderState.byteBuffer.asFloatBuffer().put(v);
    }

    private void append(double[] v) {
        this.mEncoderState.byteBuffer.position(this.mBaseOffset + 8);
        this.mEncoderState.byteBuffer.asDoubleBuffer().put(v);
    }

    private void append(long[] v) {
        this.mEncoderState.byteBuffer.position(this.mBaseOffset + 8);
        this.mEncoderState.byteBuffer.asLongBuffer().put(v);
    }

    private static class EncoderState {
        public final Core core;
        public ByteBuffer byteBuffer;
        public final List<Handle> handles = new ArrayList<Handle>();
        public int dataEnd;

        private EncoderState(Core core, int bufferSize) {
            assert (bufferSize % 8 == 0);
            this.core = core;
            this.byteBuffer = ByteBuffer.allocateDirect(bufferSize > 0 ? bufferSize : 1024);
            this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.dataEnd = 0;
        }

        public void claimMemory(int size) {
            this.dataEnd += size;
            this.growIfNeeded();
        }

        private void growIfNeeded() {
            int targetSize;
            if (this.byteBuffer.capacity() >= this.dataEnd) {
                return;
            }
            for (targetSize = this.byteBuffer.capacity() * 2; targetSize < this.dataEnd; targetSize *= 2) {
            }
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(targetSize);
            newBuffer.order(ByteOrder.nativeOrder());
            this.byteBuffer.position(0);
            this.byteBuffer.limit(this.byteBuffer.capacity());
            newBuffer.put(this.byteBuffer);
            this.byteBuffer = newBuffer;
        }
    }
}

