/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojo.bindings;

import org.chromium.mojo.bindings.Callbacks;
import org.chromium.mojo.bindings.Interface;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.MessageHeader;
import org.chromium.mojo.bindings.MessageReceiver;
import org.chromium.mojo.bindings.MessageReceiverWithResponder;
import org.chromium.mojo.bindings.QueryVersionResult;
import org.chromium.mojo.bindings.RunMessageParams;
import org.chromium.mojo.bindings.RunOrClosePipeMessageParams;
import org.chromium.mojo.bindings.RunResponseMessageParams;
import org.chromium.mojo.bindings.ServiceMessage;
import org.chromium.mojo.bindings.SideEffectFreeCloseable;
import org.chromium.mojo.system.Core;

public class InterfaceControlMessagesHelper {
    public static void sendRunMessage(Core core, MessageReceiverWithResponder receiver, RunMessageParams params, Callbacks.Callback1<RunResponseMessageParams> callback) {
        ServiceMessage message = params.serializeWithHeader(core, new MessageHeader(-1, 1, 0L));
        receiver.acceptWithResponder(message, new RunResponseForwardToCallback(callback));
    }

    public static void sendRunOrClosePipeMessage(Core core, MessageReceiverWithResponder receiver, RunOrClosePipeMessageParams params) {
        ServiceMessage message = params.serializeWithHeader(core, new MessageHeader(-2));
        receiver.accept(message);
    }

    public static <I extends Interface, P extends Interface.Proxy> boolean handleRun(Core core, Interface.Manager<I, P> manager, ServiceMessage message, MessageReceiver responder) {
        RunResponseMessageParams response = new RunResponseMessageParams();
        response.reserved0 = 16;
        response.reserved1 = 0;
        response.queryVersionResult = new QueryVersionResult();
        response.queryVersionResult.version = manager.getVersion();
        return responder.accept(response.serializeWithHeader(core, new MessageHeader(-1, 2, message.getHeader().getRequestId())));
    }

    public static <I extends Interface, P extends Interface.Proxy> boolean handleRunOrClosePipe(Interface.Manager<I, P> manager, ServiceMessage message) {
        Message payload = message.getPayload();
        RunOrClosePipeMessageParams query = RunOrClosePipeMessageParams.deserialize(payload);
        return query.requireVersion.version <= manager.getVersion();
    }

    private static class RunResponseForwardToCallback
    extends SideEffectFreeCloseable
    implements MessageReceiver {
        private final Callbacks.Callback1<RunResponseMessageParams> mCallback;

        RunResponseForwardToCallback(Callbacks.Callback1<RunResponseMessageParams> callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(Message message) {
            RunResponseMessageParams response = RunResponseMessageParams.deserialize(message.asServiceMessage().getPayload());
            this.mCallback.call(response);
            return true;
        }
    }
}

