/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojo.bindings;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.chromium.mojo.bindings.BindingsHelper;
import org.chromium.mojo.bindings.ConnectionErrorHandler;
import org.chromium.mojo.bindings.Connector;
import org.chromium.mojo.bindings.ExecutorFactory;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.MessageHeader;
import org.chromium.mojo.bindings.MessageReceiver;
import org.chromium.mojo.bindings.MessageReceiverWithResponder;
import org.chromium.mojo.bindings.Router;
import org.chromium.mojo.bindings.ServiceMessage;
import org.chromium.mojo.system.AsyncWaiter;
import org.chromium.mojo.system.Core;
import org.chromium.mojo.system.MessagePipeHandle;

public class RouterImpl
implements Router {
    private final Connector mConnector;
    private MessageReceiverWithResponder mIncomingMessageReceiver;
    private long mNextRequestId = 1L;
    private Map<Long, MessageReceiver> mResponders = new HashMap<Long, MessageReceiver>();
    private final Executor mExecutor;

    public RouterImpl(MessagePipeHandle messagePipeHandle) {
        this(messagePipeHandle, BindingsHelper.getDefaultAsyncWaiterForHandle(messagePipeHandle));
    }

    public RouterImpl(MessagePipeHandle messagePipeHandle, AsyncWaiter asyncWaiter) {
        this.mConnector = new Connector(messagePipeHandle, asyncWaiter);
        this.mConnector.setIncomingMessageReceiver(new HandleIncomingMessageThunk());
        Core core = messagePipeHandle.getCore();
        this.mExecutor = core != null ? ExecutorFactory.getExecutorForCurrentThread(core) : null;
    }

    @Override
    public void start() {
        this.mConnector.start();
    }

    @Override
    public void setIncomingMessageReceiver(MessageReceiverWithResponder incomingMessageReceiver) {
        this.mIncomingMessageReceiver = incomingMessageReceiver;
    }

    @Override
    public boolean accept(Message message) {
        return this.mConnector.accept(message);
    }

    @Override
    public boolean acceptWithResponder(Message message, MessageReceiver responder) {
        long requestId;
        ServiceMessage messageWithHeader = message.asServiceMessage();
        assert (messageWithHeader.getHeader().hasFlag(1));
        if ((requestId = this.mNextRequestId++) == 0L) {
            requestId = this.mNextRequestId++;
        }
        if (this.mResponders.containsKey(requestId)) {
            throw new IllegalStateException("Unable to find a new request identifier.");
        }
        messageWithHeader.setRequestId(requestId);
        if (!this.mConnector.accept(messageWithHeader)) {
            return false;
        }
        this.mResponders.put(requestId, responder);
        return true;
    }

    @Override
    public MessagePipeHandle passHandle() {
        return this.mConnector.passHandle();
    }

    @Override
    public void close() {
        this.mConnector.close();
    }

    @Override
    public void setErrorHandler(ConnectionErrorHandler errorHandler) {
        this.mConnector.setErrorHandler(errorHandler);
    }

    private boolean handleIncomingMessage(Message message) {
        MessageHeader header = message.asServiceMessage().getHeader();
        if (header.hasFlag(1)) {
            if (this.mIncomingMessageReceiver != null) {
                return this.mIncomingMessageReceiver.acceptWithResponder(message, new ResponderThunk());
            }
            this.close();
            return false;
        }
        if (header.hasFlag(2)) {
            long requestId = header.getRequestId();
            MessageReceiver responder = this.mResponders.get(requestId);
            if (responder == null) {
                return false;
            }
            this.mResponders.remove(requestId);
            return responder.accept(message);
        }
        if (this.mIncomingMessageReceiver != null) {
            return this.mIncomingMessageReceiver.accept(message);
        }
        return false;
    }

    private void handleConnectorClose() {
        if (this.mIncomingMessageReceiver != null) {
            this.mIncomingMessageReceiver.close();
        }
    }

    private void closeOnHandleThread() {
        if (this.mExecutor != null) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    RouterImpl.this.close();
                }
            });
        }
    }

    class ResponderThunk
    implements MessageReceiver {
        private boolean mAcceptWasInvoked = false;

        ResponderThunk() {
        }

        @Override
        public boolean accept(Message message) {
            this.mAcceptWasInvoked = true;
            return RouterImpl.this.accept(message);
        }

        @Override
        public void close() {
            RouterImpl.this.close();
        }

        protected void finalize() throws Throwable {
            if (!this.mAcceptWasInvoked) {
                RouterImpl.this.closeOnHandleThread();
            }
            super.finalize();
        }
    }

    private class HandleIncomingMessageThunk
    implements MessageReceiver {
        private HandleIncomingMessageThunk() {
        }

        @Override
        public boolean accept(Message message) {
            return RouterImpl.this.handleIncomingMessage(message);
        }

        @Override
        public void close() {
            RouterImpl.this.handleConnectorClose();
        }
    }
}

