/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojo.system;

public abstract class Flags<F extends Flags<F>> {
    private int mFlags;
    private boolean mImmutable = false;

    protected Flags(int flags) {
        this.mFlags = flags;
    }

    public int getFlags() {
        return this.mFlags;
    }

    protected F setFlag(int flag, boolean value) {
        if (this.mImmutable) {
            throw new UnsupportedOperationException("Flags is immutable.");
        }
        this.mFlags = value ? (this.mFlags |= flag) : (this.mFlags &= ~flag);
        Flags f = this;
        return (F)f;
    }

    protected F immutable() {
        this.mImmutable = true;
        Flags f = this;
        return (F)f;
    }

    public int hashCode() {
        return this.mFlags;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Flags other = (Flags)obj;
        return this.mFlags == other.mFlags;
    }
}

