/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojo.system.impl;

import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.mojo.system.RunLoop;
import org.chromium.mojo.system.impl.CoreImpl;

@JNINamespace(value="mojo::android")
class BaseRunLoop
implements RunLoop {
    private long mRunLoopID;
    private final CoreImpl mCore;

    BaseRunLoop(CoreImpl core) {
        this.mCore = core;
        this.mRunLoopID = this.nativeCreateBaseRunLoop();
    }

    @Override
    public void run() {
        assert (this.mRunLoopID != 0L) : "The run loop cannot run once closed";
        this.nativeRun(this.mRunLoopID);
    }

    @Override
    public void runUntilIdle() {
        assert (this.mRunLoopID != 0L) : "The run loop cannot run once closed";
        this.nativeRunUntilIdle(this.mRunLoopID);
    }

    @Override
    public void quit() {
        assert (this.mRunLoopID != 0L) : "The run loop cannot be quitted run once closed";
        this.nativeQuit(this.mRunLoopID);
    }

    @Override
    public void postDelayedTask(Runnable runnable, long delay) {
        assert (this.mRunLoopID != 0L) : "The run loop cannot run tasks once closed";
        this.nativePostDelayedTask(this.mRunLoopID, runnable, delay);
    }

    @Override
    public void close() {
        if (this.mRunLoopID == 0L) {
            return;
        }
        assert (this.mCore.getCurrentRunLoop() == this) : "Only the current run loop can be closed";
        this.mCore.clearCurrentRunLoop();
        this.nativeDeleteMessageLoop(this.mRunLoopID);
        this.mRunLoopID = 0L;
    }

    @CalledByNative
    private static void runRunnable(Runnable runnable) {
        runnable.run();
    }

    private native long nativeCreateBaseRunLoop();

    private native void nativeRun(long var1);

    private native void nativeRunUntilIdle(long var1);

    private native void nativeQuit(long var1);

    private native void nativePostDelayedTask(long var1, Runnable var3, long var4);

    private native void nativeDeleteMessageLoop(long var1);
}

