/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojo.system.impl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.mojo.system.AsyncWaiter;
import org.chromium.mojo.system.Core;
import org.chromium.mojo.system.DataPipe;
import org.chromium.mojo.system.Handle;
import org.chromium.mojo.system.MessagePipeHandle;
import org.chromium.mojo.system.MojoException;
import org.chromium.mojo.system.Pair;
import org.chromium.mojo.system.ResultAnd;
import org.chromium.mojo.system.RunLoop;
import org.chromium.mojo.system.SharedBufferHandle;
import org.chromium.mojo.system.UntypedHandle;
import org.chromium.mojo.system.impl.BaseRunLoop;
import org.chromium.mojo.system.impl.DataPipeConsumerHandleImpl;
import org.chromium.mojo.system.impl.DataPipeProducerHandleImpl;
import org.chromium.mojo.system.impl.HandleBase;
import org.chromium.mojo.system.impl.MessagePipeHandleImpl;
import org.chromium.mojo.system.impl.SharedBufferHandleImpl;
import org.chromium.mojo.system.impl.UntypedHandleImpl;

@JNINamespace(value="mojo::android")
public class CoreImpl
implements Core,
AsyncWaiter {
    private static final int MOJO_READ_DATA_FLAG_DISCARD = 2;
    private static final int HANDLE_SIZE = 4;
    private static final int FLAG_SIZE = 4;
    static final int INVALID_HANDLE = 0;
    private final ThreadLocal<BaseRunLoop> mCurrentRunLoop = new ThreadLocal();
    private final int mByteBufferOffset = this.nativeGetNativeBufferOffset(ByteBuffer.allocateDirect(8), 8);

    public static Core getInstance() {
        return LazyHolder.INSTANCE;
    }

    private CoreImpl() {
    }

    @Override
    public long getTimeTicksNow() {
        return this.nativeGetTimeTicksNow();
    }

    @Override
    public Core.WaitManyResult waitMany(List<Pair<Handle, Core.HandleSignals>> handles, long deadline) {
        ByteBuffer buffer = this.allocateDirectBuffer(handles.size() * 16 + 4);
        int index = 0;
        for (Pair<Handle, Core.HandleSignals> handle : handles) {
            buffer.putInt(4 * index, this.getMojoHandle((Handle)handle.first));
            buffer.putInt(4 * handles.size() + 4 * index, ((Core.HandleSignals)handle.second).getFlags());
            ++index;
        }
        int code = this.nativeWaitMany(buffer, deadline);
        Core.WaitManyResult result = new Core.WaitManyResult();
        result.setMojoResult(CoreImpl.filterMojoResultForWait(code));
        result.setHandleIndex(buffer.getInt(handles.size() * 16));
        if (result.getMojoResult() != 3 && result.getMojoResult() != 8) {
            Core.HandleSignalsState[] states = new Core.HandleSignalsState[handles.size()];
            for (int i = 0; i < handles.size(); ++i) {
                states[i] = new Core.HandleSignalsState(new Core.HandleSignals(buffer.getInt(8 * (handles.size() + i))), new Core.HandleSignals(buffer.getInt(8 * (handles.size() + i) + 4)));
            }
            result.setSignalStates(Arrays.asList(states));
        }
        return result;
    }

    @Override
    public Core.WaitResult wait(Handle handle, Core.HandleSignals signals, long deadline) {
        ByteBuffer buffer = this.allocateDirectBuffer(8);
        Core.WaitResult result = new Core.WaitResult();
        result.setMojoResult(CoreImpl.filterMojoResultForWait(this.nativeWait(buffer, this.getMojoHandle(handle), signals.getFlags(), deadline)));
        Core.HandleSignalsState signalsState = new Core.HandleSignalsState(new Core.HandleSignals(buffer.getInt(0)), new Core.HandleSignals(buffer.getInt(4)));
        result.setHandleSignalsState(signalsState);
        return result;
    }

    @Override
    public Pair<MessagePipeHandle, MessagePipeHandle> createMessagePipe(MessagePipeHandle.CreateOptions options) {
        ResultAnd<IntegerPair> result;
        ByteBuffer optionsBuffer = null;
        if (options != null) {
            optionsBuffer = this.allocateDirectBuffer(8);
            optionsBuffer.putInt(0, 8);
            optionsBuffer.putInt(4, options.getFlags().getFlags());
        }
        if ((result = this.nativeCreateMessagePipe(optionsBuffer)).getMojoResult() != 0) {
            throw new MojoException(result.getMojoResult());
        }
        return Pair.create(new MessagePipeHandleImpl(this, (Integer)result.getValue().first), new MessagePipeHandleImpl(this, (Integer)result.getValue().second));
    }

    @Override
    public Pair<DataPipe.ProducerHandle, DataPipe.ConsumerHandle> createDataPipe(DataPipe.CreateOptions options) {
        ResultAnd<IntegerPair> result;
        ByteBuffer optionsBuffer = null;
        if (options != null) {
            optionsBuffer = this.allocateDirectBuffer(16);
            optionsBuffer.putInt(0, 16);
            optionsBuffer.putInt(4, options.getFlags().getFlags());
            optionsBuffer.putInt(8, options.getElementNumBytes());
            optionsBuffer.putInt(12, options.getCapacityNumBytes());
        }
        if ((result = this.nativeCreateDataPipe(optionsBuffer)).getMojoResult() != 0) {
            throw new MojoException(result.getMojoResult());
        }
        return Pair.create(new DataPipeProducerHandleImpl(this, (Integer)result.getValue().first), new DataPipeConsumerHandleImpl(this, (Integer)result.getValue().second));
    }

    @Override
    public SharedBufferHandle createSharedBuffer(SharedBufferHandle.CreateOptions options, long numBytes) {
        ResultAnd<Integer> result;
        ByteBuffer optionsBuffer = null;
        if (options != null) {
            optionsBuffer = this.allocateDirectBuffer(8);
            optionsBuffer.putInt(0, 8);
            optionsBuffer.putInt(4, options.getFlags().getFlags());
        }
        if ((result = this.nativeCreateSharedBuffer(optionsBuffer, numBytes)).getMojoResult() != 0) {
            throw new MojoException(result.getMojoResult());
        }
        return new SharedBufferHandleImpl(this, result.getValue());
    }

    @Override
    public UntypedHandle acquireNativeHandle(int handle) {
        return new UntypedHandleImpl(this, handle);
    }

    @Override
    public AsyncWaiter getDefaultAsyncWaiter() {
        return this;
    }

    @Override
    public RunLoop createDefaultRunLoop() {
        if (this.mCurrentRunLoop.get() != null) {
            throw new MojoException(9);
        }
        BaseRunLoop runLoop = new BaseRunLoop(this);
        this.mCurrentRunLoop.set(runLoop);
        return runLoop;
    }

    @Override
    public RunLoop getCurrentRunLoop() {
        return this.mCurrentRunLoop.get();
    }

    void clearCurrentRunLoop() {
        this.mCurrentRunLoop.remove();
    }

    @Override
    public AsyncWaiter.Cancellable asyncWait(Handle handle, Core.HandleSignals signals, long deadline, AsyncWaiter.Callback callback) {
        return this.nativeAsyncWait(this.getMojoHandle(handle), signals.getFlags(), deadline, callback);
    }

    int closeWithResult(int mojoHandle) {
        return this.nativeClose(mojoHandle);
    }

    void close(int mojoHandle) {
        int mojoResult = this.nativeClose(mojoHandle);
        if (mojoResult != 0) {
            throw new MojoException(mojoResult);
        }
    }

    void writeMessage(MessagePipeHandleImpl pipeHandle, ByteBuffer bytes, List<? extends Handle> handles, MessagePipeHandle.WriteFlags flags) {
        int mojoResult;
        ByteBuffer handlesBuffer = null;
        if (handles != null && !handles.isEmpty()) {
            handlesBuffer = this.allocateDirectBuffer(handles.size() * 4);
            for (Handle handle : handles) {
                handlesBuffer.putInt(this.getMojoHandle(handle));
            }
            handlesBuffer.position(0);
        }
        if ((mojoResult = this.nativeWriteMessage(pipeHandle.getMojoHandle(), bytes, bytes == null ? 0 : bytes.limit(), handlesBuffer, flags.getFlags())) != 0) {
            throw new MojoException(mojoResult);
        }
        if (handles != null) {
            for (Handle handle : handles) {
                if (!handle.isValid()) continue;
                ((HandleBase)handle).invalidateHandle();
            }
        }
    }

    ResultAnd<MessagePipeHandle.ReadMessageResult> readMessage(MessagePipeHandleImpl handle, ByteBuffer bytes, int maxNumberOfHandles, MessagePipeHandle.ReadFlags flags) {
        ResultAnd<MessagePipeHandle.ReadMessageResult> result;
        ByteBuffer handlesBuffer = null;
        if (maxNumberOfHandles > 0) {
            handlesBuffer = this.allocateDirectBuffer(maxNumberOfHandles * 4);
        }
        if ((result = this.nativeReadMessage(handle.getMojoHandle(), bytes, handlesBuffer, flags.getFlags())).getMojoResult() != 0 && result.getMojoResult() != 8 && result.getMojoResult() != 17) {
            throw new MojoException(result.getMojoResult());
        }
        if (result.getMojoResult() == 0) {
            MessagePipeHandle.ReadMessageResult readResult = result.getValue();
            if (bytes != null) {
                bytes.position(0);
                bytes.limit(readResult.getMessageSize());
            }
            ArrayList<UntypedHandle> handles = new ArrayList<UntypedHandle>(readResult.getHandlesCount());
            for (int i = 0; i < readResult.getHandlesCount(); ++i) {
                int mojoHandle = handlesBuffer.getInt(4 * i);
                handles.add(new UntypedHandleImpl(this, mojoHandle));
            }
            readResult.setHandles(handles);
        }
        return result;
    }

    int discardData(DataPipeConsumerHandleImpl handle, int numBytes, DataPipe.ReadFlags flags) {
        ResultAnd<Integer> result = this.nativeReadData(handle.getMojoHandle(), null, numBytes, flags.getFlags() | 2);
        if (result.getMojoResult() != 0) {
            throw new MojoException(result.getMojoResult());
        }
        return result.getValue();
    }

    ResultAnd<Integer> readData(DataPipeConsumerHandleImpl handle, ByteBuffer elements, DataPipe.ReadFlags flags) {
        ResultAnd<Integer> result = this.nativeReadData(handle.getMojoHandle(), elements, elements == null ? 0 : elements.capacity(), flags.getFlags());
        if (result.getMojoResult() != 0 && result.getMojoResult() != 17) {
            throw new MojoException(result.getMojoResult());
        }
        if (result.getMojoResult() == 0 && elements != null) {
            elements.limit(result.getValue());
        }
        return result;
    }

    ByteBuffer beginReadData(DataPipeConsumerHandleImpl handle, int numBytes, DataPipe.ReadFlags flags) {
        ResultAnd<ByteBuffer> result = this.nativeBeginReadData(handle.getMojoHandle(), numBytes, flags.getFlags());
        if (result.getMojoResult() != 0) {
            throw new MojoException(result.getMojoResult());
        }
        return result.getValue().asReadOnlyBuffer();
    }

    void endReadData(DataPipeConsumerHandleImpl handle, int numBytesRead) {
        int result = this.nativeEndReadData(handle.getMojoHandle(), numBytesRead);
        if (result != 0) {
            throw new MojoException(result);
        }
    }

    ResultAnd<Integer> writeData(DataPipeProducerHandleImpl handle, ByteBuffer elements, DataPipe.WriteFlags flags) {
        return this.nativeWriteData(handle.getMojoHandle(), elements, elements.limit(), flags.getFlags());
    }

    ByteBuffer beginWriteData(DataPipeProducerHandleImpl handle, int numBytes, DataPipe.WriteFlags flags) {
        ResultAnd<ByteBuffer> result = this.nativeBeginWriteData(handle.getMojoHandle(), numBytes, flags.getFlags());
        if (result.getMojoResult() != 0) {
            throw new MojoException(result.getMojoResult());
        }
        return result.getValue();
    }

    void endWriteData(DataPipeProducerHandleImpl handle, int numBytesWritten) {
        int result = this.nativeEndWriteData(handle.getMojoHandle(), numBytesWritten);
        if (result != 0) {
            throw new MojoException(result);
        }
    }

    SharedBufferHandle duplicate(SharedBufferHandleImpl handle, SharedBufferHandle.DuplicateOptions options) {
        ResultAnd<Integer> result;
        ByteBuffer optionsBuffer = null;
        if (options != null) {
            optionsBuffer = this.allocateDirectBuffer(8);
            optionsBuffer.putInt(0, 8);
            optionsBuffer.putInt(4, options.getFlags().getFlags());
        }
        if ((result = this.nativeDuplicate(handle.getMojoHandle(), optionsBuffer)).getMojoResult() != 0) {
            throw new MojoException(result.getMojoResult());
        }
        return new SharedBufferHandleImpl(this, result.getValue());
    }

    ByteBuffer map(SharedBufferHandleImpl handle, long offset, long numBytes, SharedBufferHandle.MapFlags flags) {
        ResultAnd<ByteBuffer> result = this.nativeMap(handle.getMojoHandle(), offset, numBytes, flags.getFlags());
        if (result.getMojoResult() != 0) {
            throw new MojoException(result.getMojoResult());
        }
        return result.getValue();
    }

    void unmap(ByteBuffer buffer) {
        int result = this.nativeUnmap(buffer);
        if (result != 0) {
            throw new MojoException(result);
        }
    }

    private int getMojoHandle(Handle handle) {
        if (handle.isValid()) {
            return ((HandleBase)handle).getMojoHandle();
        }
        return 0;
    }

    private static boolean isUnrecoverableError(int code) {
        switch (code) {
            case 0: 
            case 1: 
            case 4: 
            case 9: {
                return false;
            }
        }
        return true;
    }

    private static int filterMojoResultForWait(int code) {
        if (CoreImpl.isUnrecoverableError(code)) {
            throw new MojoException(code);
        }
        return code;
    }

    private ByteBuffer allocateDirectBuffer(int capacity) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(capacity + this.mByteBufferOffset);
        if (this.mByteBufferOffset != 0) {
            buffer.position(this.mByteBufferOffset);
            buffer = buffer.slice();
        }
        return buffer.order(ByteOrder.nativeOrder());
    }

    @CalledByNative
    private AsyncWaiterCancellableImpl newAsyncWaiterCancellableImpl(long id2, long dataPtr) {
        return new AsyncWaiterCancellableImpl(id2, dataPtr);
    }

    @CalledByNative
    private void onAsyncWaitResult(int mojoResult, AsyncWaiter.Callback callback, AsyncWaiterCancellableImpl cancellable) {
        if (!cancellable.isActive()) {
            return;
        }
        cancellable.deactivate();
        if (CoreImpl.isUnrecoverableError(mojoResult)) {
            callback.onError(new MojoException(mojoResult));
            return;
        }
        callback.onResult(mojoResult);
    }

    @CalledByNative
    private static ResultAnd<ByteBuffer> newResultAndBuffer(int mojoResult, ByteBuffer buffer) {
        return new ResultAnd<ByteBuffer>(mojoResult, buffer);
    }

    @CalledByNative
    private static ResultAnd<MessagePipeHandle.ReadMessageResult> newReadMessageResult(int mojoResult, int messageSize, int handlesCount) {
        MessagePipeHandle.ReadMessageResult result = new MessagePipeHandle.ReadMessageResult();
        result.setMessageSize(messageSize);
        result.setHandlesCount(handlesCount);
        return new ResultAnd<MessagePipeHandle.ReadMessageResult>(mojoResult, result);
    }

    @CalledByNative
    private static ResultAnd<Integer> newResultAndInteger(int mojoResult, int numBytesRead) {
        return new ResultAnd<Integer>(mojoResult, numBytesRead);
    }

    @CalledByNative
    private static ResultAnd<IntegerPair> newNativeCreationResult(int mojoResult, int mojoHandle1, int mojoHandle2) {
        return new ResultAnd<IntegerPair>(mojoResult, new IntegerPair(mojoHandle1, mojoHandle2));
    }

    private native long nativeGetTimeTicksNow();

    private native int nativeWaitMany(ByteBuffer var1, long var2);

    private native ResultAnd<IntegerPair> nativeCreateMessagePipe(ByteBuffer var1);

    private native ResultAnd<IntegerPair> nativeCreateDataPipe(ByteBuffer var1);

    private native ResultAnd<Integer> nativeCreateSharedBuffer(ByteBuffer var1, long var2);

    private native int nativeClose(int var1);

    private native int nativeWait(ByteBuffer var1, int var2, int var3, long var4);

    private native int nativeWriteMessage(int var1, ByteBuffer var2, int var3, ByteBuffer var4, int var5);

    private native ResultAnd<MessagePipeHandle.ReadMessageResult> nativeReadMessage(int var1, ByteBuffer var2, ByteBuffer var3, int var4);

    private native ResultAnd<Integer> nativeReadData(int var1, ByteBuffer var2, int var3, int var4);

    private native ResultAnd<ByteBuffer> nativeBeginReadData(int var1, int var2, int var3);

    private native int nativeEndReadData(int var1, int var2);

    private native ResultAnd<Integer> nativeWriteData(int var1, ByteBuffer var2, int var3, int var4);

    private native ResultAnd<ByteBuffer> nativeBeginWriteData(int var1, int var2, int var3);

    private native int nativeEndWriteData(int var1, int var2);

    private native ResultAnd<Integer> nativeDuplicate(int var1, ByteBuffer var2);

    private native ResultAnd<ByteBuffer> nativeMap(int var1, long var2, long var4, int var6);

    private native int nativeUnmap(ByteBuffer var1);

    private native AsyncWaiterCancellableImpl nativeAsyncWait(int var1, int var2, long var3, AsyncWaiter.Callback var5);

    private native void nativeCancelAsyncWait(long var1, long var3);

    private native int nativeGetNativeBufferOffset(ByteBuffer var1, int var2);

    private static final class IntegerPair
    extends Pair<Integer, Integer> {
        public IntegerPair(Integer first, Integer second) {
            super(first, second);
        }
    }

    private class AsyncWaiterCancellableImpl
    implements AsyncWaiter.Cancellable {
        private final long mId;
        private final long mDataPtr;
        private boolean mActive = true;

        private AsyncWaiterCancellableImpl(long id2, long dataPtr) {
            this.mId = id2;
            this.mDataPtr = dataPtr;
        }

        @Override
        public void cancel() {
            if (this.mActive) {
                this.mActive = false;
                CoreImpl.this.nativeCancelAsyncWait(this.mId, this.mDataPtr);
            }
        }

        private boolean isActive() {
            return this.mActive;
        }

        private void deactivate() {
            this.mActive = false;
        }
    }

    private static class LazyHolder {
        private static final Core INSTANCE = new CoreImpl();

        private LazyHolder() {
        }
    }
}

