/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojo.system.impl;

import android.util.Log;
import org.chromium.mojo.system.Core;
import org.chromium.mojo.system.Handle;
import org.chromium.mojo.system.UntypedHandle;
import org.chromium.mojo.system.impl.CoreImpl;
import org.chromium.mojo.system.impl.UntypedHandleImpl;

abstract class HandleBase
implements Handle {
    private static final String TAG = "HandleImpl";
    private int mMojoHandle;
    protected CoreImpl mCore;

    HandleBase(CoreImpl core, int mojoHandle) {
        this.mCore = core;
        this.mMojoHandle = mojoHandle;
    }

    protected HandleBase(HandleBase other) {
        this.mCore = other.mCore;
        HandleBase otherAsHandleImpl = other;
        int mojoHandle = otherAsHandleImpl.mMojoHandle;
        otherAsHandleImpl.mMojoHandle = 0;
        this.mMojoHandle = mojoHandle;
    }

    @Override
    public void close() {
        if (this.mMojoHandle != 0) {
            int handle = this.mMojoHandle;
            this.mMojoHandle = 0;
            this.mCore.close(handle);
        }
    }

    @Override
    public Core.WaitResult wait(Core.HandleSignals signals, long deadline) {
        return this.mCore.wait(this, signals, deadline);
    }

    @Override
    public boolean isValid() {
        return this.mMojoHandle != 0;
    }

    @Override
    public UntypedHandle toUntypedHandle() {
        return new UntypedHandleImpl(this);
    }

    @Override
    public Core getCore() {
        return this.mCore;
    }

    @Override
    public int releaseNativeHandle() {
        int result = this.mMojoHandle;
        this.mMojoHandle = 0;
        return result;
    }

    int getMojoHandle() {
        return this.mMojoHandle;
    }

    void invalidateHandle() {
        this.mMojoHandle = 0;
    }

    protected final void finalize() throws Throwable {
        if (this.isValid()) {
            Log.w((String)TAG, (String)"Handle was not closed.");
            this.mCore.closeWithResult(this.mMojoHandle);
        }
        super.finalize();
    }
}

