/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojom.device;

import org.chromium.mojo.bindings.BindingsHelper;
import org.chromium.mojo.bindings.DataHeader;
import org.chromium.mojo.bindings.Decoder;
import org.chromium.mojo.bindings.DeserializationException;
import org.chromium.mojo.bindings.Encoder;
import org.chromium.mojo.bindings.Interface;
import org.chromium.mojo.bindings.InterfaceControlMessagesHelper;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.MessageHeader;
import org.chromium.mojo.bindings.MessageReceiver;
import org.chromium.mojo.bindings.MessageReceiverWithResponder;
import org.chromium.mojo.bindings.ServiceMessage;
import org.chromium.mojo.bindings.SideEffectFreeCloseable;
import org.chromium.mojo.bindings.Struct;
import org.chromium.mojo.system.Core;
import org.chromium.mojom.device.BatteryMonitor;
import org.chromium.mojom.device.BatteryStatus;

class BatteryMonitor_Internal {
    public static final Interface.Manager<BatteryMonitor, BatteryMonitor.Proxy> MANAGER = new Interface.Manager<BatteryMonitor, BatteryMonitor.Proxy>(){

        @Override
        public String getName() {
            return "device::BatteryMonitor";
        }

        @Override
        public int getVersion() {
            return 0;
        }

        @Override
        public Proxy buildProxy(Core core, MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        public Stub buildStub(Core core, BatteryMonitor impl) {
            return new Stub(core, impl);
        }

        public BatteryMonitor[] buildArray(int size) {
            return new BatteryMonitor[size];
        }
    };
    private static final int QUERY_NEXT_STATUS_ORDINAL = 0;

    BatteryMonitor_Internal() {
    }

    static class BatteryMonitorQueryNextStatusResponseParamsProxyToResponder
    implements BatteryMonitor.QueryNextStatusResponse {
        private final Core mCore;
        private final MessageReceiver mMessageReceiver;
        private final long mRequestId;

        BatteryMonitorQueryNextStatusResponseParamsProxyToResponder(Core core, MessageReceiver messageReceiver, long requestId) {
            this.mCore = core;
            this.mMessageReceiver = messageReceiver;
            this.mRequestId = requestId;
        }

        @Override
        public void call(BatteryStatus status) {
            BatteryMonitorQueryNextStatusResponseParams _response = new BatteryMonitorQueryNextStatusResponseParams();
            _response.status = status;
            ServiceMessage _message = _response.serializeWithHeader(this.mCore, new MessageHeader(0, 2, this.mRequestId));
            this.mMessageReceiver.accept(_message);
        }
    }

    static class BatteryMonitorQueryNextStatusResponseParamsForwardToCallback
    extends SideEffectFreeCloseable
    implements MessageReceiver {
        private final BatteryMonitor.QueryNextStatusResponse mCallback;

        BatteryMonitorQueryNextStatusResponseParamsForwardToCallback(BatteryMonitor.QueryNextStatusResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(0, 2)) {
                    return false;
                }
                BatteryMonitorQueryNextStatusResponseParams response = BatteryMonitorQueryNextStatusResponseParams.deserialize(messageWithHeader.getPayload());
                this.mCallback.call(response.status);
                return true;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class BatteryMonitorQueryNextStatusResponseParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public BatteryStatus status;

        private BatteryMonitorQueryNextStatusResponseParams(int version) {
            super(16, version);
        }

        public BatteryMonitorQueryNextStatusResponseParams() {
            this(0);
        }

        public static BatteryMonitorQueryNextStatusResponseParams deserialize(Message message) {
            return BatteryMonitorQueryNextStatusResponseParams.decode(new Decoder(message));
        }

        public static BatteryMonitorQueryNextStatusResponseParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            BatteryMonitorQueryNextStatusResponseParams result = new BatteryMonitorQueryNextStatusResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                Decoder decoder1 = decoder0.readPointer(8, false);
                result.status = BatteryStatus.decode(decoder1);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.status, 8, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            BatteryMonitorQueryNextStatusResponseParams other = (BatteryMonitorQueryNextStatusResponseParams)object;
            return BindingsHelper.equals(this.status, other.status);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.status);
            return result;
        }
    }

    static final class BatteryMonitorQueryNextStatusParams
    extends Struct {
        private static final int STRUCT_SIZE = 8;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(8, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private BatteryMonitorQueryNextStatusParams(int version) {
            super(8, version);
        }

        public BatteryMonitorQueryNextStatusParams() {
            this(0);
        }

        public static BatteryMonitorQueryNextStatusParams deserialize(Message message) {
            return BatteryMonitorQueryNextStatusParams.decode(new Decoder(message));
        }

        public static BatteryMonitorQueryNextStatusParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            BatteryMonitorQueryNextStatusParams result = new BatteryMonitorQueryNextStatusParams(mainDataHeader.elementsOrVersion);
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            return this.getClass() == object.getClass();
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            return result;
        }
    }

    static final class Stub
    extends Interface.Stub<BatteryMonitor> {
        Stub(Core core, BatteryMonitor impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(0)) {
                    return false;
                }
                switch (header.getType()) {
                    case -2: {
                        return InterfaceControlMessagesHelper.handleRunOrClosePipe(MANAGER, messageWithHeader);
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(Message message, MessageReceiver receiver) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(1)) {
                    return false;
                }
                switch (header.getType()) {
                    case -1: {
                        return InterfaceControlMessagesHelper.handleRun(this.getCore(), MANAGER, messageWithHeader, receiver);
                    }
                    case 0: {
                        BatteryMonitorQueryNextStatusParams.deserialize(messageWithHeader.getPayload());
                        ((BatteryMonitor)this.getImpl()).queryNextStatus(new BatteryMonitorQueryNextStatusResponseParamsProxyToResponder(this.getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class Proxy
    extends Interface.AbstractProxy
    implements BatteryMonitor.Proxy {
        Proxy(Core core, MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void queryNextStatus(BatteryMonitor.QueryNextStatusResponse callback) {
            BatteryMonitorQueryNextStatusParams _message = new BatteryMonitorQueryNextStatusParams();
            this.getProxyHandler().getMessageReceiver().acceptWithResponder(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(0, 1, 0L)), new BatteryMonitorQueryNextStatusResponseParamsForwardToCallback(callback));
        }
    }
}

