/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojom.mojo;

import org.chromium.mojo.bindings.BindingsHelper;
import org.chromium.mojo.bindings.DataHeader;
import org.chromium.mojo.bindings.Decoder;
import org.chromium.mojo.bindings.DeserializationException;
import org.chromium.mojo.bindings.Encoder;
import org.chromium.mojo.bindings.Interface;
import org.chromium.mojo.bindings.InterfaceControlMessagesHelper;
import org.chromium.mojo.bindings.InterfaceRequest;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.MessageHeader;
import org.chromium.mojo.bindings.MessageReceiver;
import org.chromium.mojo.bindings.MessageReceiverWithResponder;
import org.chromium.mojo.bindings.ServiceMessage;
import org.chromium.mojo.bindings.SideEffectFreeCloseable;
import org.chromium.mojo.bindings.Struct;
import org.chromium.mojo.system.Core;
import org.chromium.mojom.mojo.Application;
import org.chromium.mojom.mojo.ServiceProvider;
import org.chromium.mojom.mojo.Shell;

class Application_Internal {
    public static final Interface.Manager<Application, Application.Proxy> MANAGER = new Interface.Manager<Application, Application.Proxy>(){

        @Override
        public String getName() {
            return "mojo::Application";
        }

        @Override
        public int getVersion() {
            return 0;
        }

        @Override
        public Proxy buildProxy(Core core, MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        public Stub buildStub(Core core, Application impl) {
            return new Stub(core, impl);
        }

        public Application[] buildArray(int size) {
            return new Application[size];
        }
    };
    private static final int INITIALIZE_ORDINAL = 0;
    private static final int ACCEPT_CONNECTION_ORDINAL = 1;
    private static final int ON_QUIT_REQUESTED_ORDINAL = 2;

    Application_Internal() {
    }

    static class ApplicationOnQuitRequestedResponseParamsProxyToResponder
    implements Application.OnQuitRequestedResponse {
        private final Core mCore;
        private final MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ApplicationOnQuitRequestedResponseParamsProxyToResponder(Core core, MessageReceiver messageReceiver, long requestId) {
            this.mCore = core;
            this.mMessageReceiver = messageReceiver;
            this.mRequestId = requestId;
        }

        @Override
        public void call(Boolean canQuit) {
            ApplicationOnQuitRequestedResponseParams _response = new ApplicationOnQuitRequestedResponseParams();
            _response.canQuit = canQuit;
            ServiceMessage _message = _response.serializeWithHeader(this.mCore, new MessageHeader(2, 2, this.mRequestId));
            this.mMessageReceiver.accept(_message);
        }
    }

    static class ApplicationOnQuitRequestedResponseParamsForwardToCallback
    extends SideEffectFreeCloseable
    implements MessageReceiver {
        private final Application.OnQuitRequestedResponse mCallback;

        ApplicationOnQuitRequestedResponseParamsForwardToCallback(Application.OnQuitRequestedResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(2, 2)) {
                    return false;
                }
                ApplicationOnQuitRequestedResponseParams response = ApplicationOnQuitRequestedResponseParams.deserialize(messageWithHeader.getPayload());
                this.mCallback.call(response.canQuit);
                return true;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class ApplicationOnQuitRequestedResponseParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean canQuit;

        private ApplicationOnQuitRequestedResponseParams(int version) {
            super(16, version);
        }

        public ApplicationOnQuitRequestedResponseParams() {
            this(0);
        }

        public static ApplicationOnQuitRequestedResponseParams deserialize(Message message) {
            return ApplicationOnQuitRequestedResponseParams.decode(new Decoder(message));
        }

        public static ApplicationOnQuitRequestedResponseParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            ApplicationOnQuitRequestedResponseParams result = new ApplicationOnQuitRequestedResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.canQuit = decoder0.readBoolean(8, 0);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.canQuit, 8, 0);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ApplicationOnQuitRequestedResponseParams other = (ApplicationOnQuitRequestedResponseParams)object;
            return this.canQuit == other.canQuit;
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.canQuit);
            return result;
        }
    }

    static final class ApplicationOnQuitRequestedParams
    extends Struct {
        private static final int STRUCT_SIZE = 8;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(8, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private ApplicationOnQuitRequestedParams(int version) {
            super(8, version);
        }

        public ApplicationOnQuitRequestedParams() {
            this(0);
        }

        public static ApplicationOnQuitRequestedParams deserialize(Message message) {
            return ApplicationOnQuitRequestedParams.decode(new Decoder(message));
        }

        public static ApplicationOnQuitRequestedParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            ApplicationOnQuitRequestedParams result = new ApplicationOnQuitRequestedParams(mainDataHeader.elementsOrVersion);
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            return this.getClass() == object.getClass();
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            return result;
        }
    }

    static final class ApplicationAcceptConnectionParams
    extends Struct {
        private static final int STRUCT_SIZE = 40;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(40, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String requestorUrl;
        public InterfaceRequest<ServiceProvider> services;
        public ServiceProvider exposedServices;
        public String resolvedUrl;

        private ApplicationAcceptConnectionParams(int version) {
            super(40, version);
        }

        public ApplicationAcceptConnectionParams() {
            this(0);
        }

        public static ApplicationAcceptConnectionParams deserialize(Message message) {
            return ApplicationAcceptConnectionParams.decode(new Decoder(message));
        }

        public static ApplicationAcceptConnectionParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            ApplicationAcceptConnectionParams result = new ApplicationAcceptConnectionParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.requestorUrl = decoder0.readString(8, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.services = decoder0.readInterfaceRequest(16, true);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.exposedServices = decoder0.readServiceInterface(20, true, ServiceProvider.MANAGER);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.resolvedUrl = decoder0.readString(32, false);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.requestorUrl, 8, false);
            encoder0.encode(this.services, 16, true);
            encoder0.encode(this.exposedServices, 20, true, ServiceProvider.MANAGER);
            encoder0.encode(this.resolvedUrl, 32, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ApplicationAcceptConnectionParams other = (ApplicationAcceptConnectionParams)object;
            if (!BindingsHelper.equals(this.requestorUrl, other.requestorUrl)) {
                return false;
            }
            if (!BindingsHelper.equals(this.services, other.services)) {
                return false;
            }
            if (!BindingsHelper.equals(this.exposedServices, other.exposedServices)) {
                return false;
            }
            return BindingsHelper.equals(this.resolvedUrl, other.resolvedUrl);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.requestorUrl);
            result = 31 * result + BindingsHelper.hashCode(this.services);
            result = 31 * result + BindingsHelper.hashCode(this.exposedServices);
            result = 31 * result + BindingsHelper.hashCode(this.resolvedUrl);
            return result;
        }
    }

    static final class ApplicationInitializeParams
    extends Struct {
        private static final int STRUCT_SIZE = 24;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(24, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public Shell shell;
        public String url;

        private ApplicationInitializeParams(int version) {
            super(24, version);
        }

        public ApplicationInitializeParams() {
            this(0);
        }

        public static ApplicationInitializeParams deserialize(Message message) {
            return ApplicationInitializeParams.decode(new Decoder(message));
        }

        public static ApplicationInitializeParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            ApplicationInitializeParams result = new ApplicationInitializeParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.shell = decoder0.readServiceInterface(8, false, Shell.MANAGER);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.url = decoder0.readString(16, false);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.shell, 8, false, Shell.MANAGER);
            encoder0.encode(this.url, 16, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ApplicationInitializeParams other = (ApplicationInitializeParams)object;
            if (!BindingsHelper.equals(this.shell, other.shell)) {
                return false;
            }
            return BindingsHelper.equals(this.url, other.url);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.shell);
            result = 31 * result + BindingsHelper.hashCode(this.url);
            return result;
        }
    }

    static final class Stub
    extends Interface.Stub<Application> {
        Stub(Core core, Application impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(0)) {
                    return false;
                }
                switch (header.getType()) {
                    case -2: {
                        return InterfaceControlMessagesHelper.handleRunOrClosePipe(MANAGER, messageWithHeader);
                    }
                    case 0: {
                        ApplicationInitializeParams data = ApplicationInitializeParams.deserialize(messageWithHeader.getPayload());
                        ((Application)this.getImpl()).initialize(data.shell, data.url);
                        return true;
                    }
                    case 1: {
                        ApplicationAcceptConnectionParams data = ApplicationAcceptConnectionParams.deserialize(messageWithHeader.getPayload());
                        ((Application)this.getImpl()).acceptConnection(data.requestorUrl, data.services, data.exposedServices, data.resolvedUrl);
                        return true;
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(Message message, MessageReceiver receiver) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(1)) {
                    return false;
                }
                switch (header.getType()) {
                    case -1: {
                        return InterfaceControlMessagesHelper.handleRun(this.getCore(), MANAGER, messageWithHeader, receiver);
                    }
                    case 2: {
                        ApplicationOnQuitRequestedParams.deserialize(messageWithHeader.getPayload());
                        ((Application)this.getImpl()).onQuitRequested(new ApplicationOnQuitRequestedResponseParamsProxyToResponder(this.getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class Proxy
    extends Interface.AbstractProxy
    implements Application.Proxy {
        Proxy(Core core, MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void initialize(Shell shell, String url) {
            ApplicationInitializeParams _message = new ApplicationInitializeParams();
            _message.shell = shell;
            _message.url = url;
            this.getProxyHandler().getMessageReceiver().accept(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(0)));
        }

        @Override
        public void acceptConnection(String requestorUrl, InterfaceRequest<ServiceProvider> services, ServiceProvider exposedServices, String resolvedUrl) {
            ApplicationAcceptConnectionParams _message = new ApplicationAcceptConnectionParams();
            _message.requestorUrl = requestorUrl;
            _message.services = services;
            _message.exposedServices = exposedServices;
            _message.resolvedUrl = resolvedUrl;
            this.getProxyHandler().getMessageReceiver().accept(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(1)));
        }

        @Override
        public void onQuitRequested(Application.OnQuitRequestedResponse callback) {
            ApplicationOnQuitRequestedParams _message = new ApplicationOnQuitRequestedParams();
            this.getProxyHandler().getMessageReceiver().acceptWithResponder(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(2, 1, 0L)), new ApplicationOnQuitRequestedResponseParamsForwardToCallback(callback));
        }
    }
}

