/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojom.mojo;

import org.chromium.mojo.bindings.BindingsHelper;
import org.chromium.mojo.bindings.DataHeader;
import org.chromium.mojo.bindings.Decoder;
import org.chromium.mojo.bindings.DeserializationException;
import org.chromium.mojo.bindings.Encoder;
import org.chromium.mojo.bindings.Interface;
import org.chromium.mojo.bindings.InterfaceControlMessagesHelper;
import org.chromium.mojo.bindings.InterfaceRequest;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.MessageHeader;
import org.chromium.mojo.bindings.MessageReceiver;
import org.chromium.mojo.bindings.MessageReceiverWithResponder;
import org.chromium.mojo.bindings.ServiceMessage;
import org.chromium.mojo.bindings.Struct;
import org.chromium.mojo.system.Core;
import org.chromium.mojom.mojo.Application;
import org.chromium.mojom.mojo.ContentHandler;
import org.chromium.mojom.mojo.UrlResponse;

class ContentHandler_Internal {
    public static final Interface.Manager<ContentHandler, ContentHandler.Proxy> MANAGER = new Interface.Manager<ContentHandler, ContentHandler.Proxy>(){

        @Override
        public String getName() {
            return "mojo::ContentHandler";
        }

        @Override
        public int getVersion() {
            return 0;
        }

        @Override
        public Proxy buildProxy(Core core, MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        public Stub buildStub(Core core, ContentHandler impl) {
            return new Stub(core, impl);
        }

        public ContentHandler[] buildArray(int size) {
            return new ContentHandler[size];
        }
    };
    private static final int START_APPLICATION_ORDINAL = 0;

    ContentHandler_Internal() {
    }

    static final class ContentHandlerStartApplicationParams
    extends Struct {
        private static final int STRUCT_SIZE = 24;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(24, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public InterfaceRequest<Application> application;
        public UrlResponse response;

        private ContentHandlerStartApplicationParams(int version) {
            super(24, version);
        }

        public ContentHandlerStartApplicationParams() {
            this(0);
        }

        public static ContentHandlerStartApplicationParams deserialize(Message message) {
            return ContentHandlerStartApplicationParams.decode(new Decoder(message));
        }

        public static ContentHandlerStartApplicationParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            ContentHandlerStartApplicationParams result = new ContentHandlerStartApplicationParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.application = decoder0.readInterfaceRequest(8, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                Decoder decoder1 = decoder0.readPointer(16, false);
                result.response = UrlResponse.decode(decoder1);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.application, 8, false);
            encoder0.encode(this.response, 16, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ContentHandlerStartApplicationParams other = (ContentHandlerStartApplicationParams)object;
            if (!BindingsHelper.equals(this.application, other.application)) {
                return false;
            }
            return BindingsHelper.equals(this.response, other.response);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.application);
            result = 31 * result + BindingsHelper.hashCode(this.response);
            return result;
        }
    }

    static final class Stub
    extends Interface.Stub<ContentHandler> {
        Stub(Core core, ContentHandler impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(0)) {
                    return false;
                }
                switch (header.getType()) {
                    case -2: {
                        return InterfaceControlMessagesHelper.handleRunOrClosePipe(MANAGER, messageWithHeader);
                    }
                    case 0: {
                        ContentHandlerStartApplicationParams data = ContentHandlerStartApplicationParams.deserialize(messageWithHeader.getPayload());
                        ((ContentHandler)this.getImpl()).startApplication(data.application, data.response);
                        return true;
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(Message message, MessageReceiver receiver) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(1)) {
                    return false;
                }
                switch (header.getType()) {
                    case -1: {
                        return InterfaceControlMessagesHelper.handleRun(this.getCore(), MANAGER, messageWithHeader, receiver);
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class Proxy
    extends Interface.AbstractProxy
    implements ContentHandler.Proxy {
        Proxy(Core core, MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void startApplication(InterfaceRequest<Application> application, UrlResponse response) {
            ContentHandlerStartApplicationParams _message = new ContentHandlerStartApplicationParams();
            _message.application = application;
            _message.response = response;
            this.getProxyHandler().getMessageReceiver().accept(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(0)));
        }
    }
}

