/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojom.mojo;

import org.chromium.mojo.bindings.BindingsHelper;
import org.chromium.mojo.bindings.DataHeader;
import org.chromium.mojo.bindings.Decoder;
import org.chromium.mojo.bindings.DeserializationException;
import org.chromium.mojo.bindings.Encoder;
import org.chromium.mojo.bindings.Interface;
import org.chromium.mojo.bindings.InterfaceControlMessagesHelper;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.MessageHeader;
import org.chromium.mojo.bindings.MessageReceiver;
import org.chromium.mojo.bindings.MessageReceiverWithResponder;
import org.chromium.mojo.bindings.ServiceMessage;
import org.chromium.mojo.bindings.SideEffectFreeCloseable;
import org.chromium.mojo.bindings.Struct;
import org.chromium.mojo.system.Core;
import org.chromium.mojom.mojo.CookieStore;

class CookieStore_Internal {
    public static final Interface.Manager<CookieStore, CookieStore.Proxy> MANAGER = new Interface.Manager<CookieStore, CookieStore.Proxy>(){

        @Override
        public String getName() {
            return "mojo::CookieStore";
        }

        @Override
        public int getVersion() {
            return 0;
        }

        @Override
        public Proxy buildProxy(Core core, MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        public Stub buildStub(Core core, CookieStore impl) {
            return new Stub(core, impl);
        }

        public CookieStore[] buildArray(int size) {
            return new CookieStore[size];
        }
    };
    private static final int GET_ORDINAL = 0;
    private static final int SET_ORDINAL = 1;

    CookieStore_Internal() {
    }

    static class CookieStoreSetResponseParamsProxyToResponder
    implements CookieStore.SetResponse {
        private final Core mCore;
        private final MessageReceiver mMessageReceiver;
        private final long mRequestId;

        CookieStoreSetResponseParamsProxyToResponder(Core core, MessageReceiver messageReceiver, long requestId) {
            this.mCore = core;
            this.mMessageReceiver = messageReceiver;
            this.mRequestId = requestId;
        }

        @Override
        public void call(Boolean success) {
            CookieStoreSetResponseParams _response = new CookieStoreSetResponseParams();
            _response.success = success;
            ServiceMessage _message = _response.serializeWithHeader(this.mCore, new MessageHeader(1, 2, this.mRequestId));
            this.mMessageReceiver.accept(_message);
        }
    }

    static class CookieStoreSetResponseParamsForwardToCallback
    extends SideEffectFreeCloseable
    implements MessageReceiver {
        private final CookieStore.SetResponse mCallback;

        CookieStoreSetResponseParamsForwardToCallback(CookieStore.SetResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(1, 2)) {
                    return false;
                }
                CookieStoreSetResponseParams response = CookieStoreSetResponseParams.deserialize(messageWithHeader.getPayload());
                this.mCallback.call(response.success);
                return true;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class CookieStoreSetResponseParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean success;

        private CookieStoreSetResponseParams(int version) {
            super(16, version);
        }

        public CookieStoreSetResponseParams() {
            this(0);
        }

        public static CookieStoreSetResponseParams deserialize(Message message) {
            return CookieStoreSetResponseParams.decode(new Decoder(message));
        }

        public static CookieStoreSetResponseParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            CookieStoreSetResponseParams result = new CookieStoreSetResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.success = decoder0.readBoolean(8, 0);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.success, 8, 0);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            CookieStoreSetResponseParams other = (CookieStoreSetResponseParams)object;
            return this.success == other.success;
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.success);
            return result;
        }
    }

    static final class CookieStoreSetParams
    extends Struct {
        private static final int STRUCT_SIZE = 24;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(24, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String url;
        public String cookie;

        private CookieStoreSetParams(int version) {
            super(24, version);
        }

        public CookieStoreSetParams() {
            this(0);
        }

        public static CookieStoreSetParams deserialize(Message message) {
            return CookieStoreSetParams.decode(new Decoder(message));
        }

        public static CookieStoreSetParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            CookieStoreSetParams result = new CookieStoreSetParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.url = decoder0.readString(8, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.cookie = decoder0.readString(16, false);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.url, 8, false);
            encoder0.encode(this.cookie, 16, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            CookieStoreSetParams other = (CookieStoreSetParams)object;
            if (!BindingsHelper.equals(this.url, other.url)) {
                return false;
            }
            return BindingsHelper.equals(this.cookie, other.cookie);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.url);
            result = 31 * result + BindingsHelper.hashCode(this.cookie);
            return result;
        }
    }

    static class CookieStoreGetResponseParamsProxyToResponder
    implements CookieStore.GetResponse {
        private final Core mCore;
        private final MessageReceiver mMessageReceiver;
        private final long mRequestId;

        CookieStoreGetResponseParamsProxyToResponder(Core core, MessageReceiver messageReceiver, long requestId) {
            this.mCore = core;
            this.mMessageReceiver = messageReceiver;
            this.mRequestId = requestId;
        }

        @Override
        public void call(String cookies) {
            CookieStoreGetResponseParams _response = new CookieStoreGetResponseParams();
            _response.cookies = cookies;
            ServiceMessage _message = _response.serializeWithHeader(this.mCore, new MessageHeader(0, 2, this.mRequestId));
            this.mMessageReceiver.accept(_message);
        }
    }

    static class CookieStoreGetResponseParamsForwardToCallback
    extends SideEffectFreeCloseable
    implements MessageReceiver {
        private final CookieStore.GetResponse mCallback;

        CookieStoreGetResponseParamsForwardToCallback(CookieStore.GetResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(0, 2)) {
                    return false;
                }
                CookieStoreGetResponseParams response = CookieStoreGetResponseParams.deserialize(messageWithHeader.getPayload());
                this.mCallback.call(response.cookies);
                return true;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class CookieStoreGetResponseParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String cookies;

        private CookieStoreGetResponseParams(int version) {
            super(16, version);
        }

        public CookieStoreGetResponseParams() {
            this(0);
        }

        public static CookieStoreGetResponseParams deserialize(Message message) {
            return CookieStoreGetResponseParams.decode(new Decoder(message));
        }

        public static CookieStoreGetResponseParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            CookieStoreGetResponseParams result = new CookieStoreGetResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.cookies = decoder0.readString(8, false);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.cookies, 8, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            CookieStoreGetResponseParams other = (CookieStoreGetResponseParams)object;
            return BindingsHelper.equals(this.cookies, other.cookies);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.cookies);
            return result;
        }
    }

    static final class CookieStoreGetParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String url;

        private CookieStoreGetParams(int version) {
            super(16, version);
        }

        public CookieStoreGetParams() {
            this(0);
        }

        public static CookieStoreGetParams deserialize(Message message) {
            return CookieStoreGetParams.decode(new Decoder(message));
        }

        public static CookieStoreGetParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            CookieStoreGetParams result = new CookieStoreGetParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.url = decoder0.readString(8, false);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.url, 8, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            CookieStoreGetParams other = (CookieStoreGetParams)object;
            return BindingsHelper.equals(this.url, other.url);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.url);
            return result;
        }
    }

    static final class Stub
    extends Interface.Stub<CookieStore> {
        Stub(Core core, CookieStore impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(0)) {
                    return false;
                }
                switch (header.getType()) {
                    case -2: {
                        return InterfaceControlMessagesHelper.handleRunOrClosePipe(MANAGER, messageWithHeader);
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(Message message, MessageReceiver receiver) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(1)) {
                    return false;
                }
                switch (header.getType()) {
                    case -1: {
                        return InterfaceControlMessagesHelper.handleRun(this.getCore(), MANAGER, messageWithHeader, receiver);
                    }
                    case 0: {
                        CookieStoreGetParams data = CookieStoreGetParams.deserialize(messageWithHeader.getPayload());
                        ((CookieStore)this.getImpl()).get(data.url, new CookieStoreGetResponseParamsProxyToResponder(this.getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case 1: {
                        CookieStoreSetParams data = CookieStoreSetParams.deserialize(messageWithHeader.getPayload());
                        ((CookieStore)this.getImpl()).set(data.url, data.cookie, new CookieStoreSetResponseParamsProxyToResponder(this.getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class Proxy
    extends Interface.AbstractProxy
    implements CookieStore.Proxy {
        Proxy(Core core, MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void get(String url, CookieStore.GetResponse callback) {
            CookieStoreGetParams _message = new CookieStoreGetParams();
            _message.url = url;
            this.getProxyHandler().getMessageReceiver().acceptWithResponder(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(0, 1, 0L)), new CookieStoreGetResponseParamsForwardToCallback(callback));
        }

        @Override
        public void set(String url, String cookie, CookieStore.SetResponse callback) {
            CookieStoreSetParams _message = new CookieStoreSetParams();
            _message.url = url;
            _message.cookie = cookie;
            this.getProxyHandler().getMessageReceiver().acceptWithResponder(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(1, 1, 0L)), new CookieStoreSetResponseParamsForwardToCallback(callback));
        }
    }
}

