/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojom.mojo;

import org.chromium.mojo.bindings.BindingsHelper;
import org.chromium.mojo.bindings.DataHeader;
import org.chromium.mojo.bindings.Decoder;
import org.chromium.mojo.bindings.DeserializationException;
import org.chromium.mojo.bindings.Encoder;
import org.chromium.mojo.bindings.Interface;
import org.chromium.mojo.bindings.InterfaceControlMessagesHelper;
import org.chromium.mojo.bindings.InterfaceRequest;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.MessageHeader;
import org.chromium.mojo.bindings.MessageReceiver;
import org.chromium.mojo.bindings.MessageReceiverWithResponder;
import org.chromium.mojo.bindings.ServiceMessage;
import org.chromium.mojo.bindings.SideEffectFreeCloseable;
import org.chromium.mojo.bindings.Struct;
import org.chromium.mojo.system.Core;
import org.chromium.mojo.system.DataPipe;
import org.chromium.mojo.system.InvalidHandle;
import org.chromium.mojom.mojo.HttpConnectionDelegate;
import org.chromium.mojom.mojo.HttpRequest;
import org.chromium.mojom.mojo.HttpResponse;
import org.chromium.mojom.mojo.WebSocket;
import org.chromium.mojom.mojo.WebSocketClient;

class HttpConnectionDelegate_Internal {
    public static final Interface.Manager<HttpConnectionDelegate, HttpConnectionDelegate.Proxy> MANAGER = new Interface.Manager<HttpConnectionDelegate, HttpConnectionDelegate.Proxy>(){

        @Override
        public String getName() {
            return "mojo::HttpConnectionDelegate";
        }

        @Override
        public int getVersion() {
            return 0;
        }

        @Override
        public Proxy buildProxy(Core core, MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        public Stub buildStub(Core core, HttpConnectionDelegate impl) {
            return new Stub(core, impl);
        }

        public HttpConnectionDelegate[] buildArray(int size) {
            return new HttpConnectionDelegate[size];
        }
    };
    private static final int ON_RECEIVED_REQUEST_ORDINAL = 0;
    private static final int ON_RECEIVED_WEB_SOCKET_REQUEST_ORDINAL = 1;

    HttpConnectionDelegate_Internal() {
    }

    static class HttpConnectionDelegateOnReceivedWebSocketRequestResponseParamsProxyToResponder
    implements HttpConnectionDelegate.OnReceivedWebSocketRequestResponse {
        private final Core mCore;
        private final MessageReceiver mMessageReceiver;
        private final long mRequestId;

        HttpConnectionDelegateOnReceivedWebSocketRequestResponseParamsProxyToResponder(Core core, MessageReceiver messageReceiver, long requestId) {
            this.mCore = core;
            this.mMessageReceiver = messageReceiver;
            this.mRequestId = requestId;
        }

        @Override
        public void call(InterfaceRequest<WebSocket> webSocket, DataPipe.ConsumerHandle sendStream, WebSocketClient client) {
            HttpConnectionDelegateOnReceivedWebSocketRequestResponseParams _response = new HttpConnectionDelegateOnReceivedWebSocketRequestResponseParams();
            _response.webSocket = webSocket;
            _response.sendStream = sendStream;
            _response.client = client;
            ServiceMessage _message = _response.serializeWithHeader(this.mCore, new MessageHeader(1, 2, this.mRequestId));
            this.mMessageReceiver.accept(_message);
        }
    }

    static class HttpConnectionDelegateOnReceivedWebSocketRequestResponseParamsForwardToCallback
    extends SideEffectFreeCloseable
    implements MessageReceiver {
        private final HttpConnectionDelegate.OnReceivedWebSocketRequestResponse mCallback;

        HttpConnectionDelegateOnReceivedWebSocketRequestResponseParamsForwardToCallback(HttpConnectionDelegate.OnReceivedWebSocketRequestResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(1, 2)) {
                    return false;
                }
                HttpConnectionDelegateOnReceivedWebSocketRequestResponseParams response = HttpConnectionDelegateOnReceivedWebSocketRequestResponseParams.deserialize(messageWithHeader.getPayload());
                this.mCallback.call(response.webSocket, response.sendStream, response.client);
                return true;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class HttpConnectionDelegateOnReceivedWebSocketRequestResponseParams
    extends Struct {
        private static final int STRUCT_SIZE = 24;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(24, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public InterfaceRequest<WebSocket> webSocket;
        public DataPipe.ConsumerHandle sendStream = InvalidHandle.INSTANCE;
        public WebSocketClient client;

        private HttpConnectionDelegateOnReceivedWebSocketRequestResponseParams(int version) {
            super(24, version);
        }

        public HttpConnectionDelegateOnReceivedWebSocketRequestResponseParams() {
            this(0);
        }

        public static HttpConnectionDelegateOnReceivedWebSocketRequestResponseParams deserialize(Message message) {
            return HttpConnectionDelegateOnReceivedWebSocketRequestResponseParams.decode(new Decoder(message));
        }

        public static HttpConnectionDelegateOnReceivedWebSocketRequestResponseParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            HttpConnectionDelegateOnReceivedWebSocketRequestResponseParams result = new HttpConnectionDelegateOnReceivedWebSocketRequestResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.webSocket = decoder0.readInterfaceRequest(8, true);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.sendStream = decoder0.readConsumerHandle(12, true);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.client = decoder0.readServiceInterface(16, true, WebSocketClient.MANAGER);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.webSocket, 8, true);
            encoder0.encode(this.sendStream, 12, true);
            encoder0.encode(this.client, 16, true, WebSocketClient.MANAGER);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            HttpConnectionDelegateOnReceivedWebSocketRequestResponseParams other = (HttpConnectionDelegateOnReceivedWebSocketRequestResponseParams)object;
            if (!BindingsHelper.equals(this.webSocket, other.webSocket)) {
                return false;
            }
            if (!BindingsHelper.equals(this.sendStream, other.sendStream)) {
                return false;
            }
            return BindingsHelper.equals(this.client, other.client);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.webSocket);
            result = 31 * result + BindingsHelper.hashCode(this.sendStream);
            result = 31 * result + BindingsHelper.hashCode(this.client);
            return result;
        }
    }

    static final class HttpConnectionDelegateOnReceivedWebSocketRequestParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public HttpRequest request;

        private HttpConnectionDelegateOnReceivedWebSocketRequestParams(int version) {
            super(16, version);
        }

        public HttpConnectionDelegateOnReceivedWebSocketRequestParams() {
            this(0);
        }

        public static HttpConnectionDelegateOnReceivedWebSocketRequestParams deserialize(Message message) {
            return HttpConnectionDelegateOnReceivedWebSocketRequestParams.decode(new Decoder(message));
        }

        public static HttpConnectionDelegateOnReceivedWebSocketRequestParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            HttpConnectionDelegateOnReceivedWebSocketRequestParams result = new HttpConnectionDelegateOnReceivedWebSocketRequestParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                Decoder decoder1 = decoder0.readPointer(8, false);
                result.request = HttpRequest.decode(decoder1);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.request, 8, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            HttpConnectionDelegateOnReceivedWebSocketRequestParams other = (HttpConnectionDelegateOnReceivedWebSocketRequestParams)object;
            return BindingsHelper.equals(this.request, other.request);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.request);
            return result;
        }
    }

    static class HttpConnectionDelegateOnReceivedRequestResponseParamsProxyToResponder
    implements HttpConnectionDelegate.OnReceivedRequestResponse {
        private final Core mCore;
        private final MessageReceiver mMessageReceiver;
        private final long mRequestId;

        HttpConnectionDelegateOnReceivedRequestResponseParamsProxyToResponder(Core core, MessageReceiver messageReceiver, long requestId) {
            this.mCore = core;
            this.mMessageReceiver = messageReceiver;
            this.mRequestId = requestId;
        }

        @Override
        public void call(HttpResponse response) {
            HttpConnectionDelegateOnReceivedRequestResponseParams _response = new HttpConnectionDelegateOnReceivedRequestResponseParams();
            _response.response = response;
            ServiceMessage _message = _response.serializeWithHeader(this.mCore, new MessageHeader(0, 2, this.mRequestId));
            this.mMessageReceiver.accept(_message);
        }
    }

    static class HttpConnectionDelegateOnReceivedRequestResponseParamsForwardToCallback
    extends SideEffectFreeCloseable
    implements MessageReceiver {
        private final HttpConnectionDelegate.OnReceivedRequestResponse mCallback;

        HttpConnectionDelegateOnReceivedRequestResponseParamsForwardToCallback(HttpConnectionDelegate.OnReceivedRequestResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(0, 2)) {
                    return false;
                }
                HttpConnectionDelegateOnReceivedRequestResponseParams response = HttpConnectionDelegateOnReceivedRequestResponseParams.deserialize(messageWithHeader.getPayload());
                this.mCallback.call(response.response);
                return true;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class HttpConnectionDelegateOnReceivedRequestResponseParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public HttpResponse response;

        private HttpConnectionDelegateOnReceivedRequestResponseParams(int version) {
            super(16, version);
        }

        public HttpConnectionDelegateOnReceivedRequestResponseParams() {
            this(0);
        }

        public static HttpConnectionDelegateOnReceivedRequestResponseParams deserialize(Message message) {
            return HttpConnectionDelegateOnReceivedRequestResponseParams.decode(new Decoder(message));
        }

        public static HttpConnectionDelegateOnReceivedRequestResponseParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            HttpConnectionDelegateOnReceivedRequestResponseParams result = new HttpConnectionDelegateOnReceivedRequestResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                Decoder decoder1 = decoder0.readPointer(8, false);
                result.response = HttpResponse.decode(decoder1);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.response, 8, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            HttpConnectionDelegateOnReceivedRequestResponseParams other = (HttpConnectionDelegateOnReceivedRequestResponseParams)object;
            return BindingsHelper.equals(this.response, other.response);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.response);
            return result;
        }
    }

    static final class HttpConnectionDelegateOnReceivedRequestParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public HttpRequest request;

        private HttpConnectionDelegateOnReceivedRequestParams(int version) {
            super(16, version);
        }

        public HttpConnectionDelegateOnReceivedRequestParams() {
            this(0);
        }

        public static HttpConnectionDelegateOnReceivedRequestParams deserialize(Message message) {
            return HttpConnectionDelegateOnReceivedRequestParams.decode(new Decoder(message));
        }

        public static HttpConnectionDelegateOnReceivedRequestParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            HttpConnectionDelegateOnReceivedRequestParams result = new HttpConnectionDelegateOnReceivedRequestParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                Decoder decoder1 = decoder0.readPointer(8, false);
                result.request = HttpRequest.decode(decoder1);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.request, 8, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            HttpConnectionDelegateOnReceivedRequestParams other = (HttpConnectionDelegateOnReceivedRequestParams)object;
            return BindingsHelper.equals(this.request, other.request);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.request);
            return result;
        }
    }

    static final class Stub
    extends Interface.Stub<HttpConnectionDelegate> {
        Stub(Core core, HttpConnectionDelegate impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(0)) {
                    return false;
                }
                switch (header.getType()) {
                    case -2: {
                        return InterfaceControlMessagesHelper.handleRunOrClosePipe(MANAGER, messageWithHeader);
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(Message message, MessageReceiver receiver) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(1)) {
                    return false;
                }
                switch (header.getType()) {
                    case -1: {
                        return InterfaceControlMessagesHelper.handleRun(this.getCore(), MANAGER, messageWithHeader, receiver);
                    }
                    case 0: {
                        HttpConnectionDelegateOnReceivedRequestParams data = HttpConnectionDelegateOnReceivedRequestParams.deserialize(messageWithHeader.getPayload());
                        ((HttpConnectionDelegate)this.getImpl()).onReceivedRequest(data.request, new HttpConnectionDelegateOnReceivedRequestResponseParamsProxyToResponder(this.getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case 1: {
                        HttpConnectionDelegateOnReceivedWebSocketRequestParams data = HttpConnectionDelegateOnReceivedWebSocketRequestParams.deserialize(messageWithHeader.getPayload());
                        ((HttpConnectionDelegate)this.getImpl()).onReceivedWebSocketRequest(data.request, new HttpConnectionDelegateOnReceivedWebSocketRequestResponseParamsProxyToResponder(this.getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class Proxy
    extends Interface.AbstractProxy
    implements HttpConnectionDelegate.Proxy {
        Proxy(Core core, MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void onReceivedRequest(HttpRequest request, HttpConnectionDelegate.OnReceivedRequestResponse callback) {
            HttpConnectionDelegateOnReceivedRequestParams _message = new HttpConnectionDelegateOnReceivedRequestParams();
            _message.request = request;
            this.getProxyHandler().getMessageReceiver().acceptWithResponder(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(0, 1, 0L)), new HttpConnectionDelegateOnReceivedRequestResponseParamsForwardToCallback(callback));
        }

        @Override
        public void onReceivedWebSocketRequest(HttpRequest request, HttpConnectionDelegate.OnReceivedWebSocketRequestResponse callback) {
            HttpConnectionDelegateOnReceivedWebSocketRequestParams _message = new HttpConnectionDelegateOnReceivedWebSocketRequestParams();
            _message.request = request;
            this.getProxyHandler().getMessageReceiver().acceptWithResponder(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(1, 1, 0L)), new HttpConnectionDelegateOnReceivedWebSocketRequestResponseParamsForwardToCallback(callback));
        }
    }
}

