/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojom.mojo;

import org.chromium.mojo.bindings.BindingsHelper;
import org.chromium.mojo.bindings.DataHeader;
import org.chromium.mojo.bindings.Decoder;
import org.chromium.mojo.bindings.DeserializationException;
import org.chromium.mojo.bindings.Encoder;
import org.chromium.mojo.bindings.Interface;
import org.chromium.mojo.bindings.InterfaceControlMessagesHelper;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.MessageHeader;
import org.chromium.mojo.bindings.MessageReceiver;
import org.chromium.mojo.bindings.MessageReceiverWithResponder;
import org.chromium.mojo.bindings.ServiceMessage;
import org.chromium.mojo.bindings.SideEffectFreeCloseable;
import org.chromium.mojo.bindings.Struct;
import org.chromium.mojo.system.Core;
import org.chromium.mojom.mojo.HttpConnection;
import org.chromium.mojom.mojo.NetworkError;

class HttpConnection_Internal {
    public static final Interface.Manager<HttpConnection, HttpConnection.Proxy> MANAGER = new Interface.Manager<HttpConnection, HttpConnection.Proxy>(){

        @Override
        public String getName() {
            return "mojo::HttpConnection";
        }

        @Override
        public int getVersion() {
            return 0;
        }

        @Override
        public Proxy buildProxy(Core core, MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        public Stub buildStub(Core core, HttpConnection impl) {
            return new Stub(core, impl);
        }

        public HttpConnection[] buildArray(int size) {
            return new HttpConnection[size];
        }
    };
    private static final int SET_SEND_BUFFER_SIZE_ORDINAL = 0;
    private static final int SET_RECEIVE_BUFFER_SIZE_ORDINAL = 1;

    HttpConnection_Internal() {
    }

    static class HttpConnectionSetReceiveBufferSizeResponseParamsProxyToResponder
    implements HttpConnection.SetReceiveBufferSizeResponse {
        private final Core mCore;
        private final MessageReceiver mMessageReceiver;
        private final long mRequestId;

        HttpConnectionSetReceiveBufferSizeResponseParamsProxyToResponder(Core core, MessageReceiver messageReceiver, long requestId) {
            this.mCore = core;
            this.mMessageReceiver = messageReceiver;
            this.mRequestId = requestId;
        }

        @Override
        public void call(NetworkError result) {
            HttpConnectionSetReceiveBufferSizeResponseParams _response = new HttpConnectionSetReceiveBufferSizeResponseParams();
            _response.result = result;
            ServiceMessage _message = _response.serializeWithHeader(this.mCore, new MessageHeader(1, 2, this.mRequestId));
            this.mMessageReceiver.accept(_message);
        }
    }

    static class HttpConnectionSetReceiveBufferSizeResponseParamsForwardToCallback
    extends SideEffectFreeCloseable
    implements MessageReceiver {
        private final HttpConnection.SetReceiveBufferSizeResponse mCallback;

        HttpConnectionSetReceiveBufferSizeResponseParamsForwardToCallback(HttpConnection.SetReceiveBufferSizeResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(1, 2)) {
                    return false;
                }
                HttpConnectionSetReceiveBufferSizeResponseParams response = HttpConnectionSetReceiveBufferSizeResponseParams.deserialize(messageWithHeader.getPayload());
                this.mCallback.call(response.result);
                return true;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class HttpConnectionSetReceiveBufferSizeResponseParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public NetworkError result;

        private HttpConnectionSetReceiveBufferSizeResponseParams(int version) {
            super(16, version);
        }

        public HttpConnectionSetReceiveBufferSizeResponseParams() {
            this(0);
        }

        public static HttpConnectionSetReceiveBufferSizeResponseParams deserialize(Message message) {
            return HttpConnectionSetReceiveBufferSizeResponseParams.decode(new Decoder(message));
        }

        public static HttpConnectionSetReceiveBufferSizeResponseParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            HttpConnectionSetReceiveBufferSizeResponseParams result = new HttpConnectionSetReceiveBufferSizeResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                Decoder decoder1 = decoder0.readPointer(8, false);
                result.result = NetworkError.decode(decoder1);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.result, 8, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            HttpConnectionSetReceiveBufferSizeResponseParams other = (HttpConnectionSetReceiveBufferSizeResponseParams)object;
            return BindingsHelper.equals(this.result, other.result);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(result);
            return result;
        }
    }

    static final class HttpConnectionSetReceiveBufferSizeParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int size;

        private HttpConnectionSetReceiveBufferSizeParams(int version) {
            super(16, version);
        }

        public HttpConnectionSetReceiveBufferSizeParams() {
            this(0);
        }

        public static HttpConnectionSetReceiveBufferSizeParams deserialize(Message message) {
            return HttpConnectionSetReceiveBufferSizeParams.decode(new Decoder(message));
        }

        public static HttpConnectionSetReceiveBufferSizeParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            HttpConnectionSetReceiveBufferSizeParams result = new HttpConnectionSetReceiveBufferSizeParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.size = decoder0.readInt(8);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.size, 8);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            HttpConnectionSetReceiveBufferSizeParams other = (HttpConnectionSetReceiveBufferSizeParams)object;
            return this.size == other.size;
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.size);
            return result;
        }
    }

    static class HttpConnectionSetSendBufferSizeResponseParamsProxyToResponder
    implements HttpConnection.SetSendBufferSizeResponse {
        private final Core mCore;
        private final MessageReceiver mMessageReceiver;
        private final long mRequestId;

        HttpConnectionSetSendBufferSizeResponseParamsProxyToResponder(Core core, MessageReceiver messageReceiver, long requestId) {
            this.mCore = core;
            this.mMessageReceiver = messageReceiver;
            this.mRequestId = requestId;
        }

        @Override
        public void call(NetworkError result) {
            HttpConnectionSetSendBufferSizeResponseParams _response = new HttpConnectionSetSendBufferSizeResponseParams();
            _response.result = result;
            ServiceMessage _message = _response.serializeWithHeader(this.mCore, new MessageHeader(0, 2, this.mRequestId));
            this.mMessageReceiver.accept(_message);
        }
    }

    static class HttpConnectionSetSendBufferSizeResponseParamsForwardToCallback
    extends SideEffectFreeCloseable
    implements MessageReceiver {
        private final HttpConnection.SetSendBufferSizeResponse mCallback;

        HttpConnectionSetSendBufferSizeResponseParamsForwardToCallback(HttpConnection.SetSendBufferSizeResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(0, 2)) {
                    return false;
                }
                HttpConnectionSetSendBufferSizeResponseParams response = HttpConnectionSetSendBufferSizeResponseParams.deserialize(messageWithHeader.getPayload());
                this.mCallback.call(response.result);
                return true;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class HttpConnectionSetSendBufferSizeResponseParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public NetworkError result;

        private HttpConnectionSetSendBufferSizeResponseParams(int version) {
            super(16, version);
        }

        public HttpConnectionSetSendBufferSizeResponseParams() {
            this(0);
        }

        public static HttpConnectionSetSendBufferSizeResponseParams deserialize(Message message) {
            return HttpConnectionSetSendBufferSizeResponseParams.decode(new Decoder(message));
        }

        public static HttpConnectionSetSendBufferSizeResponseParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            HttpConnectionSetSendBufferSizeResponseParams result = new HttpConnectionSetSendBufferSizeResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                Decoder decoder1 = decoder0.readPointer(8, false);
                result.result = NetworkError.decode(decoder1);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.result, 8, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            HttpConnectionSetSendBufferSizeResponseParams other = (HttpConnectionSetSendBufferSizeResponseParams)object;
            return BindingsHelper.equals(this.result, other.result);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(result);
            return result;
        }
    }

    static final class HttpConnectionSetSendBufferSizeParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int size;

        private HttpConnectionSetSendBufferSizeParams(int version) {
            super(16, version);
        }

        public HttpConnectionSetSendBufferSizeParams() {
            this(0);
        }

        public static HttpConnectionSetSendBufferSizeParams deserialize(Message message) {
            return HttpConnectionSetSendBufferSizeParams.decode(new Decoder(message));
        }

        public static HttpConnectionSetSendBufferSizeParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            HttpConnectionSetSendBufferSizeParams result = new HttpConnectionSetSendBufferSizeParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.size = decoder0.readInt(8);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.size, 8);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            HttpConnectionSetSendBufferSizeParams other = (HttpConnectionSetSendBufferSizeParams)object;
            return this.size == other.size;
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.size);
            return result;
        }
    }

    static final class Stub
    extends Interface.Stub<HttpConnection> {
        Stub(Core core, HttpConnection impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(0)) {
                    return false;
                }
                switch (header.getType()) {
                    case -2: {
                        return InterfaceControlMessagesHelper.handleRunOrClosePipe(MANAGER, messageWithHeader);
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(Message message, MessageReceiver receiver) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(1)) {
                    return false;
                }
                switch (header.getType()) {
                    case -1: {
                        return InterfaceControlMessagesHelper.handleRun(this.getCore(), MANAGER, messageWithHeader, receiver);
                    }
                    case 0: {
                        HttpConnectionSetSendBufferSizeParams data = HttpConnectionSetSendBufferSizeParams.deserialize(messageWithHeader.getPayload());
                        ((HttpConnection)this.getImpl()).setSendBufferSize(data.size, new HttpConnectionSetSendBufferSizeResponseParamsProxyToResponder(this.getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case 1: {
                        HttpConnectionSetReceiveBufferSizeParams data = HttpConnectionSetReceiveBufferSizeParams.deserialize(messageWithHeader.getPayload());
                        ((HttpConnection)this.getImpl()).setReceiveBufferSize(data.size, new HttpConnectionSetReceiveBufferSizeResponseParamsProxyToResponder(this.getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class Proxy
    extends Interface.AbstractProxy
    implements HttpConnection.Proxy {
        Proxy(Core core, MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void setSendBufferSize(int size, HttpConnection.SetSendBufferSizeResponse callback) {
            HttpConnectionSetSendBufferSizeParams _message = new HttpConnectionSetSendBufferSizeParams();
            _message.size = size;
            this.getProxyHandler().getMessageReceiver().acceptWithResponder(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(0, 1, 0L)), new HttpConnectionSetSendBufferSizeResponseParamsForwardToCallback(callback));
        }

        @Override
        public void setReceiveBufferSize(int size, HttpConnection.SetReceiveBufferSizeResponse callback) {
            HttpConnectionSetReceiveBufferSizeParams _message = new HttpConnectionSetReceiveBufferSizeParams();
            _message.size = size;
            this.getProxyHandler().getMessageReceiver().acceptWithResponder(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(1, 1, 0L)), new HttpConnectionSetReceiveBufferSizeResponseParamsForwardToCallback(callback));
        }
    }
}

