/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojom.mojo;

import java.util.Arrays;
import org.chromium.mojo.bindings.BindingsHelper;
import org.chromium.mojo.bindings.DataHeader;
import org.chromium.mojo.bindings.Decoder;
import org.chromium.mojo.bindings.Encoder;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.Struct;
import org.chromium.mojo.system.DataPipe;
import org.chromium.mojo.system.InvalidHandle;
import org.chromium.mojom.mojo.HttpHeader;

public final class HttpRequest
extends Struct {
    private static final int STRUCT_SIZE = 40;
    private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(40, 0)};
    private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public String method = "GET";
    public String url;
    public HttpHeader[] headers;
    public DataPipe.ConsumerHandle body = InvalidHandle.INSTANCE;

    private HttpRequest(int version) {
        super(40, version);
    }

    public HttpRequest() {
        this(0);
    }

    public static HttpRequest deserialize(Message message) {
        return HttpRequest.decode(new Decoder(message));
    }

    public static HttpRequest decode(Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        HttpRequest result = new HttpRequest(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.method = decoder0.readString(8, false);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.url = decoder0.readString(16, false);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            Decoder decoder1 = decoder0.readPointer(24, true);
            if (decoder1 == null) {
                result.headers = null;
            } else {
                DataHeader si1 = decoder1.readDataHeaderForPointerArray(-1);
                result.headers = new HttpHeader[si1.elementsOrVersion];
                for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                    Decoder decoder2 = decoder1.readPointer(8 + 8 * i1, false);
                    result.headers[i1] = HttpHeader.decode(decoder2);
                }
            }
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.body = decoder0.readConsumerHandle(32, true);
        }
        return result;
    }

    @Override
    protected final void encode(Encoder encoder) {
        Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(this.method, 8, false);
        encoder0.encode(this.url, 16, false);
        if (this.headers == null) {
            encoder0.encodeNullPointer(24, true);
        } else {
            Encoder encoder1 = encoder0.encodePointerArray(this.headers.length, 24, -1);
            for (int i0 = 0; i0 < this.headers.length; ++i0) {
                encoder1.encode(this.headers[i0], 8 + 8 * i0, false);
            }
        }
        encoder0.encode(this.body, 32, true);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HttpRequest other = (HttpRequest)object;
        if (!BindingsHelper.equals(this.method, other.method)) {
            return false;
        }
        if (!BindingsHelper.equals(this.url, other.url)) {
            return false;
        }
        if (!Arrays.deepEquals(this.headers, other.headers)) {
            return false;
        }
        return BindingsHelper.equals(this.body, other.body);
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.getClass().hashCode();
        result = 31 * result + BindingsHelper.hashCode(this.method);
        result = 31 * result + BindingsHelper.hashCode(this.url);
        result = 31 * result + Arrays.deepHashCode(this.headers);
        result = 31 * result + BindingsHelper.hashCode(this.body);
        return result;
    }
}

