/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojom.mojo;

import java.util.Arrays;
import org.chromium.mojo.bindings.BindingsHelper;
import org.chromium.mojo.bindings.DataHeader;
import org.chromium.mojo.bindings.Decoder;
import org.chromium.mojo.bindings.Encoder;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.Struct;
import org.chromium.mojo.system.DataPipe;
import org.chromium.mojo.system.InvalidHandle;
import org.chromium.mojom.mojo.HttpHeader;

public final class HttpResponse
extends Struct {
    private static final int STRUCT_SIZE = 24;
    private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(24, 0)};
    private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public int statusCode = 200;
    public HttpHeader[] headers;
    public DataPipe.ConsumerHandle body = InvalidHandle.INSTANCE;

    private HttpResponse(int version) {
        super(24, version);
    }

    public HttpResponse() {
        this(0);
    }

    public static HttpResponse deserialize(Message message) {
        return HttpResponse.decode(new Decoder(message));
    }

    public static HttpResponse decode(Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        HttpResponse result = new HttpResponse(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.statusCode = decoder0.readInt(8);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.body = decoder0.readConsumerHandle(12, true);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            Decoder decoder1 = decoder0.readPointer(16, true);
            if (decoder1 == null) {
                result.headers = null;
            } else {
                DataHeader si1 = decoder1.readDataHeaderForPointerArray(-1);
                result.headers = new HttpHeader[si1.elementsOrVersion];
                for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                    Decoder decoder2 = decoder1.readPointer(8 + 8 * i1, false);
                    result.headers[i1] = HttpHeader.decode(decoder2);
                }
            }
        }
        return result;
    }

    @Override
    protected final void encode(Encoder encoder) {
        Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(this.statusCode, 8);
        encoder0.encode(this.body, 12, true);
        if (this.headers == null) {
            encoder0.encodeNullPointer(16, true);
        } else {
            Encoder encoder1 = encoder0.encodePointerArray(this.headers.length, 16, -1);
            for (int i0 = 0; i0 < this.headers.length; ++i0) {
                encoder1.encode(this.headers[i0], 8 + 8 * i0, false);
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HttpResponse other = (HttpResponse)object;
        if (this.statusCode != other.statusCode) {
            return false;
        }
        if (!Arrays.deepEquals(this.headers, other.headers)) {
            return false;
        }
        return BindingsHelper.equals(this.body, other.body);
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.getClass().hashCode();
        result = 31 * result + BindingsHelper.hashCode(this.statusCode);
        result = 31 * result + Arrays.deepHashCode(this.headers);
        result = 31 * result + BindingsHelper.hashCode(this.body);
        return result;
    }
}

