/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojom.mojo;

import org.chromium.mojo.bindings.BindingsHelper;
import org.chromium.mojo.bindings.DataHeader;
import org.chromium.mojo.bindings.Decoder;
import org.chromium.mojo.bindings.DeserializationException;
import org.chromium.mojo.bindings.Encoder;
import org.chromium.mojo.bindings.Interface;
import org.chromium.mojo.bindings.InterfaceControlMessagesHelper;
import org.chromium.mojo.bindings.InterfaceRequest;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.MessageHeader;
import org.chromium.mojo.bindings.MessageReceiver;
import org.chromium.mojo.bindings.MessageReceiverWithResponder;
import org.chromium.mojo.bindings.ServiceMessage;
import org.chromium.mojo.bindings.Struct;
import org.chromium.mojo.system.Core;
import org.chromium.mojom.mojo.HttpConnection;
import org.chromium.mojom.mojo.HttpConnectionDelegate;
import org.chromium.mojom.mojo.HttpServerDelegate;

class HttpServerDelegate_Internal {
    public static final Interface.Manager<HttpServerDelegate, HttpServerDelegate.Proxy> MANAGER = new Interface.Manager<HttpServerDelegate, HttpServerDelegate.Proxy>(){

        @Override
        public String getName() {
            return "mojo::HttpServerDelegate";
        }

        @Override
        public int getVersion() {
            return 0;
        }

        @Override
        public Proxy buildProxy(Core core, MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        public Stub buildStub(Core core, HttpServerDelegate impl) {
            return new Stub(core, impl);
        }

        public HttpServerDelegate[] buildArray(int size) {
            return new HttpServerDelegate[size];
        }
    };
    private static final int ON_CONNECTED_ORDINAL = 0;

    HttpServerDelegate_Internal() {
    }

    static final class HttpServerDelegateOnConnectedParams
    extends Struct {
        private static final int STRUCT_SIZE = 24;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(24, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public HttpConnection connection;
        public InterfaceRequest<HttpConnectionDelegate> delegate;

        private HttpServerDelegateOnConnectedParams(int version) {
            super(24, version);
        }

        public HttpServerDelegateOnConnectedParams() {
            this(0);
        }

        public static HttpServerDelegateOnConnectedParams deserialize(Message message) {
            return HttpServerDelegateOnConnectedParams.decode(new Decoder(message));
        }

        public static HttpServerDelegateOnConnectedParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            HttpServerDelegateOnConnectedParams result = new HttpServerDelegateOnConnectedParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.connection = decoder0.readServiceInterface(8, false, HttpConnection.MANAGER);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.delegate = decoder0.readInterfaceRequest(16, false);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.connection, 8, false, HttpConnection.MANAGER);
            encoder0.encode(this.delegate, 16, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            HttpServerDelegateOnConnectedParams other = (HttpServerDelegateOnConnectedParams)object;
            if (!BindingsHelper.equals(this.connection, other.connection)) {
                return false;
            }
            return BindingsHelper.equals(this.delegate, other.delegate);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.connection);
            result = 31 * result + BindingsHelper.hashCode(this.delegate);
            return result;
        }
    }

    static final class Stub
    extends Interface.Stub<HttpServerDelegate> {
        Stub(Core core, HttpServerDelegate impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(0)) {
                    return false;
                }
                switch (header.getType()) {
                    case -2: {
                        return InterfaceControlMessagesHelper.handleRunOrClosePipe(MANAGER, messageWithHeader);
                    }
                    case 0: {
                        HttpServerDelegateOnConnectedParams data = HttpServerDelegateOnConnectedParams.deserialize(messageWithHeader.getPayload());
                        ((HttpServerDelegate)this.getImpl()).onConnected(data.connection, data.delegate);
                        return true;
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(Message message, MessageReceiver receiver) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(1)) {
                    return false;
                }
                switch (header.getType()) {
                    case -1: {
                        return InterfaceControlMessagesHelper.handleRun(this.getCore(), MANAGER, messageWithHeader, receiver);
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class Proxy
    extends Interface.AbstractProxy
    implements HttpServerDelegate.Proxy {
        Proxy(Core core, MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void onConnected(HttpConnection connection, InterfaceRequest<HttpConnectionDelegate> delegate) {
            HttpServerDelegateOnConnectedParams _message = new HttpServerDelegateOnConnectedParams();
            _message.connection = connection;
            _message.delegate = delegate;
            this.getProxyHandler().getMessageReceiver().accept(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(0)));
        }
    }
}

