/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojom.mojo;

import org.chromium.mojo.bindings.BindingsHelper;
import org.chromium.mojo.bindings.DataHeader;
import org.chromium.mojo.bindings.Decoder;
import org.chromium.mojo.bindings.Encoder;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.Struct;
import org.chromium.mojom.mojo.NetAddressIPv4;
import org.chromium.mojom.mojo.NetAddressIPv6;

public final class NetAddress
extends Struct {
    private static final int STRUCT_SIZE = 32;
    private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(32, 0)};
    private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public int family = 0;
    public NetAddressIPv4 ipv4;
    public NetAddressIPv6 ipv6;

    private NetAddress(int version) {
        super(32, version);
    }

    public NetAddress() {
        this(0);
    }

    public static NetAddress deserialize(Message message) {
        return NetAddress.decode(new Decoder(message));
    }

    public static NetAddress decode(Decoder decoder0) {
        Decoder decoder1;
        if (decoder0 == null) {
            return null;
        }
        DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        NetAddress result = new NetAddress(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.family = decoder0.readInt(8);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            decoder1 = decoder0.readPointer(16, true);
            result.ipv4 = NetAddressIPv4.decode(decoder1);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            decoder1 = decoder0.readPointer(24, true);
            result.ipv6 = NetAddressIPv6.decode(decoder1);
        }
        return result;
    }

    @Override
    protected final void encode(Encoder encoder) {
        Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(this.family, 8);
        encoder0.encode(this.ipv4, 16, true);
        encoder0.encode(this.ipv6, 24, true);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NetAddress other = (NetAddress)object;
        if (this.family != other.family) {
            return false;
        }
        if (!BindingsHelper.equals(this.ipv4, other.ipv4)) {
            return false;
        }
        return BindingsHelper.equals(this.ipv6, other.ipv6);
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.getClass().hashCode();
        result = 31 * result + BindingsHelper.hashCode(this.family);
        result = 31 * result + BindingsHelper.hashCode(this.ipv4);
        result = 31 * result + BindingsHelper.hashCode(this.ipv6);
        return result;
    }
}

