/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojom.mojo;

import java.util.Arrays;
import org.chromium.mojo.bindings.BindingsHelper;
import org.chromium.mojo.bindings.DataHeader;
import org.chromium.mojo.bindings.Decoder;
import org.chromium.mojo.bindings.Encoder;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.Struct;

public final class NetAddressIPv6
extends Struct {
    private static final int STRUCT_SIZE = 24;
    private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(24, 0)};
    private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public short port;
    public byte[] addr;

    private NetAddressIPv6(int version) {
        super(24, version);
    }

    public NetAddressIPv6() {
        this(0);
    }

    public static NetAddressIPv6 deserialize(Message message) {
        return NetAddressIPv6.decode(new Decoder(message));
    }

    public static NetAddressIPv6 decode(Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        NetAddressIPv6 result = new NetAddressIPv6(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.port = decoder0.readShort(8);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.addr = decoder0.readBytes(16, 0, 16);
        }
        return result;
    }

    @Override
    protected final void encode(Encoder encoder) {
        Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(this.port, 8);
        encoder0.encode(this.addr, 16, 0, 16);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NetAddressIPv6 other = (NetAddressIPv6)object;
        if (this.port != other.port) {
            return false;
        }
        return Arrays.equals(this.addr, other.addr);
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.getClass().hashCode();
        result = 31 * result + BindingsHelper.hashCode(this.port);
        result = 31 * result + Arrays.hashCode(this.addr);
        return result;
    }
}

