/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojom.mojo;

import org.chromium.mojo.bindings.BindingsHelper;
import org.chromium.mojo.bindings.DataHeader;
import org.chromium.mojo.bindings.Decoder;
import org.chromium.mojo.bindings.DeserializationException;
import org.chromium.mojo.bindings.Encoder;
import org.chromium.mojo.bindings.Interface;
import org.chromium.mojo.bindings.InterfaceControlMessagesHelper;
import org.chromium.mojo.bindings.InterfaceRequest;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.MessageHeader;
import org.chromium.mojo.bindings.MessageReceiver;
import org.chromium.mojo.bindings.MessageReceiverWithResponder;
import org.chromium.mojo.bindings.ServiceMessage;
import org.chromium.mojo.bindings.SideEffectFreeCloseable;
import org.chromium.mojo.bindings.Struct;
import org.chromium.mojo.system.Core;
import org.chromium.mojo.system.DataPipe;
import org.chromium.mojo.system.InvalidHandle;
import org.chromium.mojom.mojo.CookieStore;
import org.chromium.mojom.mojo.HttpServerDelegate;
import org.chromium.mojom.mojo.NetAddress;
import org.chromium.mojom.mojo.NetworkError;
import org.chromium.mojom.mojo.NetworkService;
import org.chromium.mojom.mojo.TcpBoundSocket;
import org.chromium.mojom.mojo.TcpConnectedSocket;
import org.chromium.mojom.mojo.UdpSocket;
import org.chromium.mojom.mojo.WebSocket;

class NetworkService_Internal {
    public static final Interface.Manager<NetworkService, NetworkService.Proxy> MANAGER = new Interface.Manager<NetworkService, NetworkService.Proxy>(){

        @Override
        public String getName() {
            return "mojo::NetworkService";
        }

        @Override
        public int getVersion() {
            return 0;
        }

        @Override
        public Proxy buildProxy(Core core, MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        public Stub buildStub(Core core, NetworkService impl) {
            return new Stub(core, impl);
        }

        public NetworkService[] buildArray(int size) {
            return new NetworkService[size];
        }
    };
    private static final int GET_COOKIE_STORE_ORDINAL = 0;
    private static final int CREATE_WEB_SOCKET_ORDINAL = 1;
    private static final int CREATE_TCP_BOUND_SOCKET_ORDINAL = 2;
    private static final int CREATE_TCP_CONNECTED_SOCKET_ORDINAL = 3;
    private static final int CREATE_UDP_SOCKET_ORDINAL = 4;
    private static final int CREATE_HTTP_SERVER_ORDINAL = 5;

    NetworkService_Internal() {
    }

    static class NetworkServiceCreateHttpServerResponseParamsProxyToResponder
    implements NetworkService.CreateHttpServerResponse {
        private final Core mCore;
        private final MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkServiceCreateHttpServerResponseParamsProxyToResponder(Core core, MessageReceiver messageReceiver, long requestId) {
            this.mCore = core;
            this.mMessageReceiver = messageReceiver;
            this.mRequestId = requestId;
        }

        @Override
        public void call(NetworkError result, NetAddress boundTo) {
            NetworkServiceCreateHttpServerResponseParams _response = new NetworkServiceCreateHttpServerResponseParams();
            _response.result = result;
            _response.boundTo = boundTo;
            ServiceMessage _message = _response.serializeWithHeader(this.mCore, new MessageHeader(5, 2, this.mRequestId));
            this.mMessageReceiver.accept(_message);
        }
    }

    static class NetworkServiceCreateHttpServerResponseParamsForwardToCallback
    extends SideEffectFreeCloseable
    implements MessageReceiver {
        private final NetworkService.CreateHttpServerResponse mCallback;

        NetworkServiceCreateHttpServerResponseParamsForwardToCallback(NetworkService.CreateHttpServerResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(5, 2)) {
                    return false;
                }
                NetworkServiceCreateHttpServerResponseParams response = NetworkServiceCreateHttpServerResponseParams.deserialize(messageWithHeader.getPayload());
                this.mCallback.call(response.result, response.boundTo);
                return true;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class NetworkServiceCreateHttpServerResponseParams
    extends Struct {
        private static final int STRUCT_SIZE = 24;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(24, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public NetworkError result;
        public NetAddress boundTo;

        private NetworkServiceCreateHttpServerResponseParams(int version) {
            super(24, version);
        }

        public NetworkServiceCreateHttpServerResponseParams() {
            this(0);
        }

        public static NetworkServiceCreateHttpServerResponseParams deserialize(Message message) {
            return NetworkServiceCreateHttpServerResponseParams.decode(new Decoder(message));
        }

        public static NetworkServiceCreateHttpServerResponseParams decode(Decoder decoder0) {
            Decoder decoder1;
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            NetworkServiceCreateHttpServerResponseParams result = new NetworkServiceCreateHttpServerResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                decoder1 = decoder0.readPointer(8, false);
                result.result = NetworkError.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                decoder1 = decoder0.readPointer(16, true);
                result.boundTo = NetAddress.decode(decoder1);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.result, 8, false);
            encoder0.encode(this.boundTo, 16, true);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            NetworkServiceCreateHttpServerResponseParams other = (NetworkServiceCreateHttpServerResponseParams)object;
            if (!BindingsHelper.equals(this.result, other.result)) {
                return false;
            }
            return BindingsHelper.equals(this.boundTo, other.boundTo);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(result);
            result = 31 * result + BindingsHelper.hashCode(this.boundTo);
            return result;
        }
    }

    static final class NetworkServiceCreateHttpServerParams
    extends Struct {
        private static final int STRUCT_SIZE = 24;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(24, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public NetAddress localAddress;
        public HttpServerDelegate delegate;

        private NetworkServiceCreateHttpServerParams(int version) {
            super(24, version);
        }

        public NetworkServiceCreateHttpServerParams() {
            this(0);
        }

        public static NetworkServiceCreateHttpServerParams deserialize(Message message) {
            return NetworkServiceCreateHttpServerParams.decode(new Decoder(message));
        }

        public static NetworkServiceCreateHttpServerParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            NetworkServiceCreateHttpServerParams result = new NetworkServiceCreateHttpServerParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                Decoder decoder1 = decoder0.readPointer(8, false);
                result.localAddress = NetAddress.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.delegate = decoder0.readServiceInterface(16, false, HttpServerDelegate.MANAGER);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.localAddress, 8, false);
            encoder0.encode(this.delegate, 16, false, HttpServerDelegate.MANAGER);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            NetworkServiceCreateHttpServerParams other = (NetworkServiceCreateHttpServerParams)object;
            if (!BindingsHelper.equals(this.localAddress, other.localAddress)) {
                return false;
            }
            return BindingsHelper.equals(this.delegate, other.delegate);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.localAddress);
            result = 31 * result + BindingsHelper.hashCode(this.delegate);
            return result;
        }
    }

    static final class NetworkServiceCreateUdpSocketParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public InterfaceRequest<UdpSocket> socket;

        private NetworkServiceCreateUdpSocketParams(int version) {
            super(16, version);
        }

        public NetworkServiceCreateUdpSocketParams() {
            this(0);
        }

        public static NetworkServiceCreateUdpSocketParams deserialize(Message message) {
            return NetworkServiceCreateUdpSocketParams.decode(new Decoder(message));
        }

        public static NetworkServiceCreateUdpSocketParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            NetworkServiceCreateUdpSocketParams result = new NetworkServiceCreateUdpSocketParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.socket = decoder0.readInterfaceRequest(8, false);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.socket, 8, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            NetworkServiceCreateUdpSocketParams other = (NetworkServiceCreateUdpSocketParams)object;
            return BindingsHelper.equals(this.socket, other.socket);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.socket);
            return result;
        }
    }

    static class NetworkServiceCreateTcpConnectedSocketResponseParamsProxyToResponder
    implements NetworkService.CreateTcpConnectedSocketResponse {
        private final Core mCore;
        private final MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkServiceCreateTcpConnectedSocketResponseParamsProxyToResponder(Core core, MessageReceiver messageReceiver, long requestId) {
            this.mCore = core;
            this.mMessageReceiver = messageReceiver;
            this.mRequestId = requestId;
        }

        @Override
        public void call(NetworkError result, NetAddress localAddress) {
            NetworkServiceCreateTcpConnectedSocketResponseParams _response = new NetworkServiceCreateTcpConnectedSocketResponseParams();
            _response.result = result;
            _response.localAddress = localAddress;
            ServiceMessage _message = _response.serializeWithHeader(this.mCore, new MessageHeader(3, 2, this.mRequestId));
            this.mMessageReceiver.accept(_message);
        }
    }

    static class NetworkServiceCreateTcpConnectedSocketResponseParamsForwardToCallback
    extends SideEffectFreeCloseable
    implements MessageReceiver {
        private final NetworkService.CreateTcpConnectedSocketResponse mCallback;

        NetworkServiceCreateTcpConnectedSocketResponseParamsForwardToCallback(NetworkService.CreateTcpConnectedSocketResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(3, 2)) {
                    return false;
                }
                NetworkServiceCreateTcpConnectedSocketResponseParams response = NetworkServiceCreateTcpConnectedSocketResponseParams.deserialize(messageWithHeader.getPayload());
                this.mCallback.call(response.result, response.localAddress);
                return true;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class NetworkServiceCreateTcpConnectedSocketResponseParams
    extends Struct {
        private static final int STRUCT_SIZE = 24;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(24, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public NetworkError result;
        public NetAddress localAddress;

        private NetworkServiceCreateTcpConnectedSocketResponseParams(int version) {
            super(24, version);
        }

        public NetworkServiceCreateTcpConnectedSocketResponseParams() {
            this(0);
        }

        public static NetworkServiceCreateTcpConnectedSocketResponseParams deserialize(Message message) {
            return NetworkServiceCreateTcpConnectedSocketResponseParams.decode(new Decoder(message));
        }

        public static NetworkServiceCreateTcpConnectedSocketResponseParams decode(Decoder decoder0) {
            Decoder decoder1;
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            NetworkServiceCreateTcpConnectedSocketResponseParams result = new NetworkServiceCreateTcpConnectedSocketResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                decoder1 = decoder0.readPointer(8, false);
                result.result = NetworkError.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                decoder1 = decoder0.readPointer(16, true);
                result.localAddress = NetAddress.decode(decoder1);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.result, 8, false);
            encoder0.encode(this.localAddress, 16, true);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            NetworkServiceCreateTcpConnectedSocketResponseParams other = (NetworkServiceCreateTcpConnectedSocketResponseParams)object;
            if (!BindingsHelper.equals(this.result, other.result)) {
                return false;
            }
            return BindingsHelper.equals(this.localAddress, other.localAddress);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(result);
            result = 31 * result + BindingsHelper.hashCode(this.localAddress);
            return result;
        }
    }

    static final class NetworkServiceCreateTcpConnectedSocketParams
    extends Struct {
        private static final int STRUCT_SIZE = 32;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(32, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public NetAddress remoteAddress;
        public DataPipe.ConsumerHandle sendStream = InvalidHandle.INSTANCE;
        public DataPipe.ProducerHandle receiveStream = InvalidHandle.INSTANCE;
        public InterfaceRequest<TcpConnectedSocket> clientSocket;

        private NetworkServiceCreateTcpConnectedSocketParams(int version) {
            super(32, version);
        }

        public NetworkServiceCreateTcpConnectedSocketParams() {
            this(0);
        }

        public static NetworkServiceCreateTcpConnectedSocketParams deserialize(Message message) {
            return NetworkServiceCreateTcpConnectedSocketParams.decode(new Decoder(message));
        }

        public static NetworkServiceCreateTcpConnectedSocketParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            NetworkServiceCreateTcpConnectedSocketParams result = new NetworkServiceCreateTcpConnectedSocketParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                Decoder decoder1 = decoder0.readPointer(8, false);
                result.remoteAddress = NetAddress.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.sendStream = decoder0.readConsumerHandle(16, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.receiveStream = decoder0.readProducerHandle(20, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.clientSocket = decoder0.readInterfaceRequest(24, false);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.remoteAddress, 8, false);
            encoder0.encode(this.sendStream, 16, false);
            encoder0.encode(this.receiveStream, 20, false);
            encoder0.encode(this.clientSocket, 24, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            NetworkServiceCreateTcpConnectedSocketParams other = (NetworkServiceCreateTcpConnectedSocketParams)object;
            if (!BindingsHelper.equals(this.remoteAddress, other.remoteAddress)) {
                return false;
            }
            if (!BindingsHelper.equals(this.sendStream, other.sendStream)) {
                return false;
            }
            if (!BindingsHelper.equals(this.receiveStream, other.receiveStream)) {
                return false;
            }
            return BindingsHelper.equals(this.clientSocket, other.clientSocket);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.remoteAddress);
            result = 31 * result + BindingsHelper.hashCode(this.sendStream);
            result = 31 * result + BindingsHelper.hashCode(this.receiveStream);
            result = 31 * result + BindingsHelper.hashCode(this.clientSocket);
            return result;
        }
    }

    static class NetworkServiceCreateTcpBoundSocketResponseParamsProxyToResponder
    implements NetworkService.CreateTcpBoundSocketResponse {
        private final Core mCore;
        private final MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkServiceCreateTcpBoundSocketResponseParamsProxyToResponder(Core core, MessageReceiver messageReceiver, long requestId) {
            this.mCore = core;
            this.mMessageReceiver = messageReceiver;
            this.mRequestId = requestId;
        }

        @Override
        public void call(NetworkError result, NetAddress boundTo) {
            NetworkServiceCreateTcpBoundSocketResponseParams _response = new NetworkServiceCreateTcpBoundSocketResponseParams();
            _response.result = result;
            _response.boundTo = boundTo;
            ServiceMessage _message = _response.serializeWithHeader(this.mCore, new MessageHeader(2, 2, this.mRequestId));
            this.mMessageReceiver.accept(_message);
        }
    }

    static class NetworkServiceCreateTcpBoundSocketResponseParamsForwardToCallback
    extends SideEffectFreeCloseable
    implements MessageReceiver {
        private final NetworkService.CreateTcpBoundSocketResponse mCallback;

        NetworkServiceCreateTcpBoundSocketResponseParamsForwardToCallback(NetworkService.CreateTcpBoundSocketResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(2, 2)) {
                    return false;
                }
                NetworkServiceCreateTcpBoundSocketResponseParams response = NetworkServiceCreateTcpBoundSocketResponseParams.deserialize(messageWithHeader.getPayload());
                this.mCallback.call(response.result, response.boundTo);
                return true;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class NetworkServiceCreateTcpBoundSocketResponseParams
    extends Struct {
        private static final int STRUCT_SIZE = 24;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(24, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public NetworkError result;
        public NetAddress boundTo;

        private NetworkServiceCreateTcpBoundSocketResponseParams(int version) {
            super(24, version);
        }

        public NetworkServiceCreateTcpBoundSocketResponseParams() {
            this(0);
        }

        public static NetworkServiceCreateTcpBoundSocketResponseParams deserialize(Message message) {
            return NetworkServiceCreateTcpBoundSocketResponseParams.decode(new Decoder(message));
        }

        public static NetworkServiceCreateTcpBoundSocketResponseParams decode(Decoder decoder0) {
            Decoder decoder1;
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            NetworkServiceCreateTcpBoundSocketResponseParams result = new NetworkServiceCreateTcpBoundSocketResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                decoder1 = decoder0.readPointer(8, false);
                result.result = NetworkError.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                decoder1 = decoder0.readPointer(16, true);
                result.boundTo = NetAddress.decode(decoder1);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.result, 8, false);
            encoder0.encode(this.boundTo, 16, true);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            NetworkServiceCreateTcpBoundSocketResponseParams other = (NetworkServiceCreateTcpBoundSocketResponseParams)object;
            if (!BindingsHelper.equals(this.result, other.result)) {
                return false;
            }
            return BindingsHelper.equals(this.boundTo, other.boundTo);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(result);
            result = 31 * result + BindingsHelper.hashCode(this.boundTo);
            return result;
        }
    }

    static final class NetworkServiceCreateTcpBoundSocketParams
    extends Struct {
        private static final int STRUCT_SIZE = 24;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(24, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public NetAddress localAddress;
        public InterfaceRequest<TcpBoundSocket> boundSocket;

        private NetworkServiceCreateTcpBoundSocketParams(int version) {
            super(24, version);
        }

        public NetworkServiceCreateTcpBoundSocketParams() {
            this(0);
        }

        public static NetworkServiceCreateTcpBoundSocketParams deserialize(Message message) {
            return NetworkServiceCreateTcpBoundSocketParams.decode(new Decoder(message));
        }

        public static NetworkServiceCreateTcpBoundSocketParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            NetworkServiceCreateTcpBoundSocketParams result = new NetworkServiceCreateTcpBoundSocketParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                Decoder decoder1 = decoder0.readPointer(8, true);
                result.localAddress = NetAddress.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.boundSocket = decoder0.readInterfaceRequest(16, false);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.localAddress, 8, true);
            encoder0.encode(this.boundSocket, 16, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            NetworkServiceCreateTcpBoundSocketParams other = (NetworkServiceCreateTcpBoundSocketParams)object;
            if (!BindingsHelper.equals(this.localAddress, other.localAddress)) {
                return false;
            }
            return BindingsHelper.equals(this.boundSocket, other.boundSocket);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.localAddress);
            result = 31 * result + BindingsHelper.hashCode(this.boundSocket);
            return result;
        }
    }

    static final class NetworkServiceCreateWebSocketParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public InterfaceRequest<WebSocket> socket;

        private NetworkServiceCreateWebSocketParams(int version) {
            super(16, version);
        }

        public NetworkServiceCreateWebSocketParams() {
            this(0);
        }

        public static NetworkServiceCreateWebSocketParams deserialize(Message message) {
            return NetworkServiceCreateWebSocketParams.decode(new Decoder(message));
        }

        public static NetworkServiceCreateWebSocketParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            NetworkServiceCreateWebSocketParams result = new NetworkServiceCreateWebSocketParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.socket = decoder0.readInterfaceRequest(8, false);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.socket, 8, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            NetworkServiceCreateWebSocketParams other = (NetworkServiceCreateWebSocketParams)object;
            return BindingsHelper.equals(this.socket, other.socket);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.socket);
            return result;
        }
    }

    static final class NetworkServiceGetCookieStoreParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public InterfaceRequest<CookieStore> cookieStore;

        private NetworkServiceGetCookieStoreParams(int version) {
            super(16, version);
        }

        public NetworkServiceGetCookieStoreParams() {
            this(0);
        }

        public static NetworkServiceGetCookieStoreParams deserialize(Message message) {
            return NetworkServiceGetCookieStoreParams.decode(new Decoder(message));
        }

        public static NetworkServiceGetCookieStoreParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            NetworkServiceGetCookieStoreParams result = new NetworkServiceGetCookieStoreParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.cookieStore = decoder0.readInterfaceRequest(8, false);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.cookieStore, 8, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            NetworkServiceGetCookieStoreParams other = (NetworkServiceGetCookieStoreParams)object;
            return BindingsHelper.equals(this.cookieStore, other.cookieStore);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.cookieStore);
            return result;
        }
    }

    static final class Stub
    extends Interface.Stub<NetworkService> {
        Stub(Core core, NetworkService impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(0)) {
                    return false;
                }
                switch (header.getType()) {
                    case -2: {
                        return InterfaceControlMessagesHelper.handleRunOrClosePipe(MANAGER, messageWithHeader);
                    }
                    case 0: {
                        NetworkServiceGetCookieStoreParams data = NetworkServiceGetCookieStoreParams.deserialize(messageWithHeader.getPayload());
                        ((NetworkService)this.getImpl()).getCookieStore(data.cookieStore);
                        return true;
                    }
                    case 1: {
                        NetworkServiceCreateWebSocketParams data = NetworkServiceCreateWebSocketParams.deserialize(messageWithHeader.getPayload());
                        ((NetworkService)this.getImpl()).createWebSocket(data.socket);
                        return true;
                    }
                    case 4: {
                        NetworkServiceCreateUdpSocketParams data = NetworkServiceCreateUdpSocketParams.deserialize(messageWithHeader.getPayload());
                        ((NetworkService)this.getImpl()).createUdpSocket(data.socket);
                        return true;
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(Message message, MessageReceiver receiver) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(1)) {
                    return false;
                }
                switch (header.getType()) {
                    case -1: {
                        return InterfaceControlMessagesHelper.handleRun(this.getCore(), MANAGER, messageWithHeader, receiver);
                    }
                    case 2: {
                        NetworkServiceCreateTcpBoundSocketParams data = NetworkServiceCreateTcpBoundSocketParams.deserialize(messageWithHeader.getPayload());
                        ((NetworkService)this.getImpl()).createTcpBoundSocket(data.localAddress, data.boundSocket, new NetworkServiceCreateTcpBoundSocketResponseParamsProxyToResponder(this.getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case 3: {
                        NetworkServiceCreateTcpConnectedSocketParams data = NetworkServiceCreateTcpConnectedSocketParams.deserialize(messageWithHeader.getPayload());
                        ((NetworkService)this.getImpl()).createTcpConnectedSocket(data.remoteAddress, data.sendStream, data.receiveStream, data.clientSocket, new NetworkServiceCreateTcpConnectedSocketResponseParamsProxyToResponder(this.getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case 5: {
                        NetworkServiceCreateHttpServerParams data = NetworkServiceCreateHttpServerParams.deserialize(messageWithHeader.getPayload());
                        ((NetworkService)this.getImpl()).createHttpServer(data.localAddress, data.delegate, new NetworkServiceCreateHttpServerResponseParamsProxyToResponder(this.getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class Proxy
    extends Interface.AbstractProxy
    implements NetworkService.Proxy {
        Proxy(Core core, MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void getCookieStore(InterfaceRequest<CookieStore> cookieStore) {
            NetworkServiceGetCookieStoreParams _message = new NetworkServiceGetCookieStoreParams();
            _message.cookieStore = cookieStore;
            this.getProxyHandler().getMessageReceiver().accept(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(0)));
        }

        @Override
        public void createWebSocket(InterfaceRequest<WebSocket> socket) {
            NetworkServiceCreateWebSocketParams _message = new NetworkServiceCreateWebSocketParams();
            _message.socket = socket;
            this.getProxyHandler().getMessageReceiver().accept(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(1)));
        }

        @Override
        public void createTcpBoundSocket(NetAddress localAddress, InterfaceRequest<TcpBoundSocket> boundSocket, NetworkService.CreateTcpBoundSocketResponse callback) {
            NetworkServiceCreateTcpBoundSocketParams _message = new NetworkServiceCreateTcpBoundSocketParams();
            _message.localAddress = localAddress;
            _message.boundSocket = boundSocket;
            this.getProxyHandler().getMessageReceiver().acceptWithResponder(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(2, 1, 0L)), new NetworkServiceCreateTcpBoundSocketResponseParamsForwardToCallback(callback));
        }

        @Override
        public void createTcpConnectedSocket(NetAddress remoteAddress, DataPipe.ConsumerHandle sendStream, DataPipe.ProducerHandle receiveStream, InterfaceRequest<TcpConnectedSocket> clientSocket, NetworkService.CreateTcpConnectedSocketResponse callback) {
            NetworkServiceCreateTcpConnectedSocketParams _message = new NetworkServiceCreateTcpConnectedSocketParams();
            _message.remoteAddress = remoteAddress;
            _message.sendStream = sendStream;
            _message.receiveStream = receiveStream;
            _message.clientSocket = clientSocket;
            this.getProxyHandler().getMessageReceiver().acceptWithResponder(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(3, 1, 0L)), new NetworkServiceCreateTcpConnectedSocketResponseParamsForwardToCallback(callback));
        }

        @Override
        public void createUdpSocket(InterfaceRequest<UdpSocket> socket) {
            NetworkServiceCreateUdpSocketParams _message = new NetworkServiceCreateUdpSocketParams();
            _message.socket = socket;
            this.getProxyHandler().getMessageReceiver().accept(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(4)));
        }

        @Override
        public void createHttpServer(NetAddress localAddress, HttpServerDelegate delegate, NetworkService.CreateHttpServerResponse callback) {
            NetworkServiceCreateHttpServerParams _message = new NetworkServiceCreateHttpServerParams();
            _message.localAddress = localAddress;
            _message.delegate = delegate;
            this.getProxyHandler().getMessageReceiver().acceptWithResponder(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(5, 1, 0L)), new NetworkServiceCreateHttpServerResponseParamsForwardToCallback(callback));
        }
    }
}

