/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojom.mojo;

import org.chromium.mojo.bindings.BindingsHelper;
import org.chromium.mojo.bindings.DataHeader;
import org.chromium.mojo.bindings.Decoder;
import org.chromium.mojo.bindings.Encoder;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.Struct;

public final class Rect
extends Struct {
    private static final int STRUCT_SIZE = 24;
    private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(24, 0)};
    private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public int x;
    public int y;
    public int width;
    public int height;

    private Rect(int version) {
        super(24, version);
    }

    public Rect() {
        this(0);
    }

    public static Rect deserialize(Message message) {
        return Rect.decode(new Decoder(message));
    }

    public static Rect decode(Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        Rect result = new Rect(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.x = decoder0.readInt(8);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.y = decoder0.readInt(12);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.width = decoder0.readInt(16);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.height = decoder0.readInt(20);
        }
        return result;
    }

    @Override
    protected final void encode(Encoder encoder) {
        Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(this.x, 8);
        encoder0.encode(this.y, 12);
        encoder0.encode(this.width, 16);
        encoder0.encode(this.height, 20);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Rect other = (Rect)object;
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        if (this.width != other.width) {
            return false;
        }
        return this.height == other.height;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.getClass().hashCode();
        result = 31 * result + BindingsHelper.hashCode(this.x);
        result = 31 * result + BindingsHelper.hashCode(this.y);
        result = 31 * result + BindingsHelper.hashCode(this.width);
        result = 31 * result + BindingsHelper.hashCode(this.height);
        return result;
    }
}

