/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojom.mojo;

import org.chromium.mojo.bindings.BindingsHelper;
import org.chromium.mojo.bindings.DataHeader;
import org.chromium.mojo.bindings.Decoder;
import org.chromium.mojo.bindings.DeserializationException;
import org.chromium.mojo.bindings.Encoder;
import org.chromium.mojo.bindings.Interface;
import org.chromium.mojo.bindings.InterfaceControlMessagesHelper;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.MessageHeader;
import org.chromium.mojo.bindings.MessageReceiver;
import org.chromium.mojo.bindings.MessageReceiverWithResponder;
import org.chromium.mojo.bindings.ServiceMessage;
import org.chromium.mojo.bindings.Struct;
import org.chromium.mojo.system.Core;
import org.chromium.mojo.system.InvalidHandle;
import org.chromium.mojo.system.MessagePipeHandle;
import org.chromium.mojom.mojo.ServiceProvider;

class ServiceProvider_Internal {
    public static final Interface.Manager<ServiceProvider, ServiceProvider.Proxy> MANAGER = new Interface.Manager<ServiceProvider, ServiceProvider.Proxy>(){

        @Override
        public String getName() {
            return "mojo::ServiceProvider";
        }

        @Override
        public int getVersion() {
            return 0;
        }

        @Override
        public Proxy buildProxy(Core core, MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        public Stub buildStub(Core core, ServiceProvider impl) {
            return new Stub(core, impl);
        }

        public ServiceProvider[] buildArray(int size) {
            return new ServiceProvider[size];
        }
    };
    private static final int CONNECT_TO_SERVICE_ORDINAL = 0;

    ServiceProvider_Internal() {
    }

    static final class ServiceProviderConnectToServiceParams
    extends Struct {
        private static final int STRUCT_SIZE = 24;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(24, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String interfaceName;
        public MessagePipeHandle pipe = InvalidHandle.INSTANCE;

        private ServiceProviderConnectToServiceParams(int version) {
            super(24, version);
        }

        public ServiceProviderConnectToServiceParams() {
            this(0);
        }

        public static ServiceProviderConnectToServiceParams deserialize(Message message) {
            return ServiceProviderConnectToServiceParams.decode(new Decoder(message));
        }

        public static ServiceProviderConnectToServiceParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            ServiceProviderConnectToServiceParams result = new ServiceProviderConnectToServiceParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.interfaceName = decoder0.readString(8, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.pipe = decoder0.readMessagePipeHandle(16, false);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.interfaceName, 8, false);
            encoder0.encode(this.pipe, 16, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ServiceProviderConnectToServiceParams other = (ServiceProviderConnectToServiceParams)object;
            if (!BindingsHelper.equals(this.interfaceName, other.interfaceName)) {
                return false;
            }
            return BindingsHelper.equals(this.pipe, other.pipe);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.interfaceName);
            result = 31 * result + BindingsHelper.hashCode(this.pipe);
            return result;
        }
    }

    static final class Stub
    extends Interface.Stub<ServiceProvider> {
        Stub(Core core, ServiceProvider impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(0)) {
                    return false;
                }
                switch (header.getType()) {
                    case -2: {
                        return InterfaceControlMessagesHelper.handleRunOrClosePipe(MANAGER, messageWithHeader);
                    }
                    case 0: {
                        ServiceProviderConnectToServiceParams data = ServiceProviderConnectToServiceParams.deserialize(messageWithHeader.getPayload());
                        ((ServiceProvider)this.getImpl()).connectToService(data.interfaceName, data.pipe);
                        return true;
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(Message message, MessageReceiver receiver) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(1)) {
                    return false;
                }
                switch (header.getType()) {
                    case -1: {
                        return InterfaceControlMessagesHelper.handleRun(this.getCore(), MANAGER, messageWithHeader, receiver);
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class Proxy
    extends Interface.AbstractProxy
    implements ServiceProvider.Proxy {
        Proxy(Core core, MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void connectToService(String interfaceName, MessagePipeHandle pipe) {
            ServiceProviderConnectToServiceParams _message = new ServiceProviderConnectToServiceParams();
            _message.interfaceName = interfaceName;
            _message.pipe = pipe;
            this.getProxyHandler().getMessageReceiver().accept(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(0)));
        }
    }
}

