/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojom.mojo;

import org.chromium.mojo.bindings.BindingsHelper;
import org.chromium.mojo.bindings.DataHeader;
import org.chromium.mojo.bindings.Decoder;
import org.chromium.mojo.bindings.DeserializationException;
import org.chromium.mojo.bindings.Encoder;
import org.chromium.mojo.bindings.Interface;
import org.chromium.mojo.bindings.InterfaceControlMessagesHelper;
import org.chromium.mojo.bindings.InterfaceRequest;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.MessageHeader;
import org.chromium.mojo.bindings.MessageReceiver;
import org.chromium.mojo.bindings.MessageReceiverWithResponder;
import org.chromium.mojo.bindings.ServiceMessage;
import org.chromium.mojo.bindings.Struct;
import org.chromium.mojo.system.Core;
import org.chromium.mojom.mojo.ServiceProvider;
import org.chromium.mojom.mojo.Shell;
import org.chromium.mojom.mojo.UrlRequest;

class Shell_Internal {
    public static final Interface.Manager<Shell, Shell.Proxy> MANAGER = new Interface.Manager<Shell, Shell.Proxy>(){

        @Override
        public String getName() {
            return "mojo::Shell";
        }

        @Override
        public int getVersion() {
            return 0;
        }

        @Override
        public Proxy buildProxy(Core core, MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        public Stub buildStub(Core core, Shell impl) {
            return new Stub(core, impl);
        }

        public Shell[] buildArray(int size) {
            return new Shell[size];
        }
    };
    private static final int CONNECT_TO_APPLICATION_ORDINAL = 0;
    private static final int QUIT_APPLICATION_ORDINAL = 1;

    Shell_Internal() {
    }

    static final class ShellQuitApplicationParams
    extends Struct {
        private static final int STRUCT_SIZE = 8;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(8, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private ShellQuitApplicationParams(int version) {
            super(8, version);
        }

        public ShellQuitApplicationParams() {
            this(0);
        }

        public static ShellQuitApplicationParams deserialize(Message message) {
            return ShellQuitApplicationParams.decode(new Decoder(message));
        }

        public static ShellQuitApplicationParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            ShellQuitApplicationParams result = new ShellQuitApplicationParams(mainDataHeader.elementsOrVersion);
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            return this.getClass() == object.getClass();
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            return result;
        }
    }

    static final class ShellConnectToApplicationParams
    extends Struct {
        private static final int STRUCT_SIZE = 32;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(32, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public UrlRequest applicationUrl;
        public InterfaceRequest<ServiceProvider> services;
        public ServiceProvider exposedServices;

        private ShellConnectToApplicationParams(int version) {
            super(32, version);
        }

        public ShellConnectToApplicationParams() {
            this(0);
        }

        public static ShellConnectToApplicationParams deserialize(Message message) {
            return ShellConnectToApplicationParams.decode(new Decoder(message));
        }

        public static ShellConnectToApplicationParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            ShellConnectToApplicationParams result = new ShellConnectToApplicationParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                Decoder decoder1 = decoder0.readPointer(8, false);
                result.applicationUrl = UrlRequest.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.services = decoder0.readInterfaceRequest(16, true);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.exposedServices = decoder0.readServiceInterface(20, true, ServiceProvider.MANAGER);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.applicationUrl, 8, false);
            encoder0.encode(this.services, 16, true);
            encoder0.encode(this.exposedServices, 20, true, ServiceProvider.MANAGER);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ShellConnectToApplicationParams other = (ShellConnectToApplicationParams)object;
            if (!BindingsHelper.equals(this.applicationUrl, other.applicationUrl)) {
                return false;
            }
            if (!BindingsHelper.equals(this.services, other.services)) {
                return false;
            }
            return BindingsHelper.equals(this.exposedServices, other.exposedServices);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.applicationUrl);
            result = 31 * result + BindingsHelper.hashCode(this.services);
            result = 31 * result + BindingsHelper.hashCode(this.exposedServices);
            return result;
        }
    }

    static final class Stub
    extends Interface.Stub<Shell> {
        Stub(Core core, Shell impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(0)) {
                    return false;
                }
                switch (header.getType()) {
                    case -2: {
                        return InterfaceControlMessagesHelper.handleRunOrClosePipe(MANAGER, messageWithHeader);
                    }
                    case 0: {
                        ShellConnectToApplicationParams data = ShellConnectToApplicationParams.deserialize(messageWithHeader.getPayload());
                        ((Shell)this.getImpl()).connectToApplication(data.applicationUrl, data.services, data.exposedServices);
                        return true;
                    }
                    case 1: {
                        ShellQuitApplicationParams.deserialize(messageWithHeader.getPayload());
                        ((Shell)this.getImpl()).quitApplication();
                        return true;
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(Message message, MessageReceiver receiver) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(1)) {
                    return false;
                }
                switch (header.getType()) {
                    case -1: {
                        return InterfaceControlMessagesHelper.handleRun(this.getCore(), MANAGER, messageWithHeader, receiver);
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class Proxy
    extends Interface.AbstractProxy
    implements Shell.Proxy {
        Proxy(Core core, MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void connectToApplication(UrlRequest applicationUrl, InterfaceRequest<ServiceProvider> services, ServiceProvider exposedServices) {
            ShellConnectToApplicationParams _message = new ShellConnectToApplicationParams();
            _message.applicationUrl = applicationUrl;
            _message.services = services;
            _message.exposedServices = exposedServices;
            this.getProxyHandler().getMessageReceiver().accept(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(0)));
        }

        @Override
        public void quitApplication() {
            ShellQuitApplicationParams _message = new ShellQuitApplicationParams();
            this.getProxyHandler().getMessageReceiver().accept(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(1)));
        }
    }
}

