/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojom.mojo;

import org.chromium.mojo.bindings.BindingsHelper;
import org.chromium.mojo.bindings.DataHeader;
import org.chromium.mojo.bindings.Decoder;
import org.chromium.mojo.bindings.DeserializationException;
import org.chromium.mojo.bindings.Encoder;
import org.chromium.mojo.bindings.Interface;
import org.chromium.mojo.bindings.InterfaceControlMessagesHelper;
import org.chromium.mojo.bindings.InterfaceRequest;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.MessageHeader;
import org.chromium.mojo.bindings.MessageReceiver;
import org.chromium.mojo.bindings.MessageReceiverWithResponder;
import org.chromium.mojo.bindings.ServiceMessage;
import org.chromium.mojo.bindings.SideEffectFreeCloseable;
import org.chromium.mojo.bindings.Struct;
import org.chromium.mojo.system.Core;
import org.chromium.mojo.system.DataPipe;
import org.chromium.mojo.system.InvalidHandle;
import org.chromium.mojom.mojo.NetAddress;
import org.chromium.mojom.mojo.NetworkError;
import org.chromium.mojom.mojo.TcpBoundSocket;
import org.chromium.mojom.mojo.TcpConnectedSocket;
import org.chromium.mojom.mojo.TcpServerSocket;

class TcpBoundSocket_Internal {
    public static final Interface.Manager<TcpBoundSocket, TcpBoundSocket.Proxy> MANAGER = new Interface.Manager<TcpBoundSocket, TcpBoundSocket.Proxy>(){

        @Override
        public String getName() {
            return "mojo::TCPBoundSocket";
        }

        @Override
        public int getVersion() {
            return 0;
        }

        @Override
        public Proxy buildProxy(Core core, MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        public Stub buildStub(Core core, TcpBoundSocket impl) {
            return new Stub(core, impl);
        }

        public TcpBoundSocket[] buildArray(int size) {
            return new TcpBoundSocket[size];
        }
    };
    private static final int START_LISTENING_ORDINAL = 0;
    private static final int CONNECT_ORDINAL = 1;

    TcpBoundSocket_Internal() {
    }

    static class TcpBoundSocketConnectResponseParamsProxyToResponder
    implements TcpBoundSocket.ConnectResponse {
        private final Core mCore;
        private final MessageReceiver mMessageReceiver;
        private final long mRequestId;

        TcpBoundSocketConnectResponseParamsProxyToResponder(Core core, MessageReceiver messageReceiver, long requestId) {
            this.mCore = core;
            this.mMessageReceiver = messageReceiver;
            this.mRequestId = requestId;
        }

        @Override
        public void call(NetworkError result) {
            TcpBoundSocketConnectResponseParams _response = new TcpBoundSocketConnectResponseParams();
            _response.result = result;
            ServiceMessage _message = _response.serializeWithHeader(this.mCore, new MessageHeader(1, 2, this.mRequestId));
            this.mMessageReceiver.accept(_message);
        }
    }

    static class TcpBoundSocketConnectResponseParamsForwardToCallback
    extends SideEffectFreeCloseable
    implements MessageReceiver {
        private final TcpBoundSocket.ConnectResponse mCallback;

        TcpBoundSocketConnectResponseParamsForwardToCallback(TcpBoundSocket.ConnectResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(1, 2)) {
                    return false;
                }
                TcpBoundSocketConnectResponseParams response = TcpBoundSocketConnectResponseParams.deserialize(messageWithHeader.getPayload());
                this.mCallback.call(response.result);
                return true;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class TcpBoundSocketConnectResponseParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public NetworkError result;

        private TcpBoundSocketConnectResponseParams(int version) {
            super(16, version);
        }

        public TcpBoundSocketConnectResponseParams() {
            this(0);
        }

        public static TcpBoundSocketConnectResponseParams deserialize(Message message) {
            return TcpBoundSocketConnectResponseParams.decode(new Decoder(message));
        }

        public static TcpBoundSocketConnectResponseParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            TcpBoundSocketConnectResponseParams result = new TcpBoundSocketConnectResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                Decoder decoder1 = decoder0.readPointer(8, false);
                result.result = NetworkError.decode(decoder1);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.result, 8, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            TcpBoundSocketConnectResponseParams other = (TcpBoundSocketConnectResponseParams)object;
            return BindingsHelper.equals(this.result, other.result);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(result);
            return result;
        }
    }

    static final class TcpBoundSocketConnectParams
    extends Struct {
        private static final int STRUCT_SIZE = 32;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(32, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public NetAddress remoteAddress;
        public DataPipe.ConsumerHandle sendStream = InvalidHandle.INSTANCE;
        public DataPipe.ProducerHandle receiveStream = InvalidHandle.INSTANCE;
        public InterfaceRequest<TcpConnectedSocket> clientSocket;

        private TcpBoundSocketConnectParams(int version) {
            super(32, version);
        }

        public TcpBoundSocketConnectParams() {
            this(0);
        }

        public static TcpBoundSocketConnectParams deserialize(Message message) {
            return TcpBoundSocketConnectParams.decode(new Decoder(message));
        }

        public static TcpBoundSocketConnectParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            TcpBoundSocketConnectParams result = new TcpBoundSocketConnectParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                Decoder decoder1 = decoder0.readPointer(8, false);
                result.remoteAddress = NetAddress.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.sendStream = decoder0.readConsumerHandle(16, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.receiveStream = decoder0.readProducerHandle(20, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.clientSocket = decoder0.readInterfaceRequest(24, false);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.remoteAddress, 8, false);
            encoder0.encode(this.sendStream, 16, false);
            encoder0.encode(this.receiveStream, 20, false);
            encoder0.encode(this.clientSocket, 24, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            TcpBoundSocketConnectParams other = (TcpBoundSocketConnectParams)object;
            if (!BindingsHelper.equals(this.remoteAddress, other.remoteAddress)) {
                return false;
            }
            if (!BindingsHelper.equals(this.sendStream, other.sendStream)) {
                return false;
            }
            if (!BindingsHelper.equals(this.receiveStream, other.receiveStream)) {
                return false;
            }
            return BindingsHelper.equals(this.clientSocket, other.clientSocket);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.remoteAddress);
            result = 31 * result + BindingsHelper.hashCode(this.sendStream);
            result = 31 * result + BindingsHelper.hashCode(this.receiveStream);
            result = 31 * result + BindingsHelper.hashCode(this.clientSocket);
            return result;
        }
    }

    static class TcpBoundSocketStartListeningResponseParamsProxyToResponder
    implements TcpBoundSocket.StartListeningResponse {
        private final Core mCore;
        private final MessageReceiver mMessageReceiver;
        private final long mRequestId;

        TcpBoundSocketStartListeningResponseParamsProxyToResponder(Core core, MessageReceiver messageReceiver, long requestId) {
            this.mCore = core;
            this.mMessageReceiver = messageReceiver;
            this.mRequestId = requestId;
        }

        @Override
        public void call(NetworkError result) {
            TcpBoundSocketStartListeningResponseParams _response = new TcpBoundSocketStartListeningResponseParams();
            _response.result = result;
            ServiceMessage _message = _response.serializeWithHeader(this.mCore, new MessageHeader(0, 2, this.mRequestId));
            this.mMessageReceiver.accept(_message);
        }
    }

    static class TcpBoundSocketStartListeningResponseParamsForwardToCallback
    extends SideEffectFreeCloseable
    implements MessageReceiver {
        private final TcpBoundSocket.StartListeningResponse mCallback;

        TcpBoundSocketStartListeningResponseParamsForwardToCallback(TcpBoundSocket.StartListeningResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(0, 2)) {
                    return false;
                }
                TcpBoundSocketStartListeningResponseParams response = TcpBoundSocketStartListeningResponseParams.deserialize(messageWithHeader.getPayload());
                this.mCallback.call(response.result);
                return true;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class TcpBoundSocketStartListeningResponseParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public NetworkError result;

        private TcpBoundSocketStartListeningResponseParams(int version) {
            super(16, version);
        }

        public TcpBoundSocketStartListeningResponseParams() {
            this(0);
        }

        public static TcpBoundSocketStartListeningResponseParams deserialize(Message message) {
            return TcpBoundSocketStartListeningResponseParams.decode(new Decoder(message));
        }

        public static TcpBoundSocketStartListeningResponseParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            TcpBoundSocketStartListeningResponseParams result = new TcpBoundSocketStartListeningResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                Decoder decoder1 = decoder0.readPointer(8, false);
                result.result = NetworkError.decode(decoder1);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.result, 8, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            TcpBoundSocketStartListeningResponseParams other = (TcpBoundSocketStartListeningResponseParams)object;
            return BindingsHelper.equals(this.result, other.result);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(result);
            return result;
        }
    }

    static final class TcpBoundSocketStartListeningParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public InterfaceRequest<TcpServerSocket> server;

        private TcpBoundSocketStartListeningParams(int version) {
            super(16, version);
        }

        public TcpBoundSocketStartListeningParams() {
            this(0);
        }

        public static TcpBoundSocketStartListeningParams deserialize(Message message) {
            return TcpBoundSocketStartListeningParams.decode(new Decoder(message));
        }

        public static TcpBoundSocketStartListeningParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            TcpBoundSocketStartListeningParams result = new TcpBoundSocketStartListeningParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.server = decoder0.readInterfaceRequest(8, false);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.server, 8, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            TcpBoundSocketStartListeningParams other = (TcpBoundSocketStartListeningParams)object;
            return BindingsHelper.equals(this.server, other.server);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.server);
            return result;
        }
    }

    static final class Stub
    extends Interface.Stub<TcpBoundSocket> {
        Stub(Core core, TcpBoundSocket impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(0)) {
                    return false;
                }
                switch (header.getType()) {
                    case -2: {
                        return InterfaceControlMessagesHelper.handleRunOrClosePipe(MANAGER, messageWithHeader);
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(Message message, MessageReceiver receiver) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(1)) {
                    return false;
                }
                switch (header.getType()) {
                    case -1: {
                        return InterfaceControlMessagesHelper.handleRun(this.getCore(), MANAGER, messageWithHeader, receiver);
                    }
                    case 0: {
                        TcpBoundSocketStartListeningParams data = TcpBoundSocketStartListeningParams.deserialize(messageWithHeader.getPayload());
                        ((TcpBoundSocket)this.getImpl()).startListening(data.server, new TcpBoundSocketStartListeningResponseParamsProxyToResponder(this.getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case 1: {
                        TcpBoundSocketConnectParams data = TcpBoundSocketConnectParams.deserialize(messageWithHeader.getPayload());
                        ((TcpBoundSocket)this.getImpl()).connect(data.remoteAddress, data.sendStream, data.receiveStream, data.clientSocket, new TcpBoundSocketConnectResponseParamsProxyToResponder(this.getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class Proxy
    extends Interface.AbstractProxy
    implements TcpBoundSocket.Proxy {
        Proxy(Core core, MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void startListening(InterfaceRequest<TcpServerSocket> server, TcpBoundSocket.StartListeningResponse callback) {
            TcpBoundSocketStartListeningParams _message = new TcpBoundSocketStartListeningParams();
            _message.server = server;
            this.getProxyHandler().getMessageReceiver().acceptWithResponder(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(0, 1, 0L)), new TcpBoundSocketStartListeningResponseParamsForwardToCallback(callback));
        }

        @Override
        public void connect(NetAddress remoteAddress, DataPipe.ConsumerHandle sendStream, DataPipe.ProducerHandle receiveStream, InterfaceRequest<TcpConnectedSocket> clientSocket, TcpBoundSocket.ConnectResponse callback) {
            TcpBoundSocketConnectParams _message = new TcpBoundSocketConnectParams();
            _message.remoteAddress = remoteAddress;
            _message.sendStream = sendStream;
            _message.receiveStream = receiveStream;
            _message.clientSocket = clientSocket;
            this.getProxyHandler().getMessageReceiver().acceptWithResponder(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(1, 1, 0L)), new TcpBoundSocketConnectResponseParamsForwardToCallback(callback));
        }
    }
}

