/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojom.mojo;

import org.chromium.mojo.bindings.BindingsHelper;
import org.chromium.mojo.bindings.DataHeader;
import org.chromium.mojo.bindings.Decoder;
import org.chromium.mojo.bindings.DeserializationException;
import org.chromium.mojo.bindings.Encoder;
import org.chromium.mojo.bindings.Interface;
import org.chromium.mojo.bindings.InterfaceControlMessagesHelper;
import org.chromium.mojo.bindings.InterfaceRequest;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.MessageHeader;
import org.chromium.mojo.bindings.MessageReceiver;
import org.chromium.mojo.bindings.MessageReceiverWithResponder;
import org.chromium.mojo.bindings.ServiceMessage;
import org.chromium.mojo.bindings.SideEffectFreeCloseable;
import org.chromium.mojo.bindings.Struct;
import org.chromium.mojo.system.Core;
import org.chromium.mojo.system.DataPipe;
import org.chromium.mojo.system.InvalidHandle;
import org.chromium.mojom.mojo.NetAddress;
import org.chromium.mojom.mojo.NetworkError;
import org.chromium.mojom.mojo.TcpConnectedSocket;
import org.chromium.mojom.mojo.TcpServerSocket;

class TcpServerSocket_Internal {
    public static final Interface.Manager<TcpServerSocket, TcpServerSocket.Proxy> MANAGER = new Interface.Manager<TcpServerSocket, TcpServerSocket.Proxy>(){

        @Override
        public String getName() {
            return "mojo::TCPServerSocket";
        }

        @Override
        public int getVersion() {
            return 0;
        }

        @Override
        public Proxy buildProxy(Core core, MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        public Stub buildStub(Core core, TcpServerSocket impl) {
            return new Stub(core, impl);
        }

        public TcpServerSocket[] buildArray(int size) {
            return new TcpServerSocket[size];
        }
    };
    private static final int ACCEPT_ORDINAL = 0;

    TcpServerSocket_Internal() {
    }

    static class TcpServerSocketAcceptResponseParamsProxyToResponder
    implements TcpServerSocket.AcceptResponse {
        private final Core mCore;
        private final MessageReceiver mMessageReceiver;
        private final long mRequestId;

        TcpServerSocketAcceptResponseParamsProxyToResponder(Core core, MessageReceiver messageReceiver, long requestId) {
            this.mCore = core;
            this.mMessageReceiver = messageReceiver;
            this.mRequestId = requestId;
        }

        @Override
        public void call(NetworkError result, NetAddress remoteAddress) {
            TcpServerSocketAcceptResponseParams _response = new TcpServerSocketAcceptResponseParams();
            _response.result = result;
            _response.remoteAddress = remoteAddress;
            ServiceMessage _message = _response.serializeWithHeader(this.mCore, new MessageHeader(0, 2, this.mRequestId));
            this.mMessageReceiver.accept(_message);
        }
    }

    static class TcpServerSocketAcceptResponseParamsForwardToCallback
    extends SideEffectFreeCloseable
    implements MessageReceiver {
        private final TcpServerSocket.AcceptResponse mCallback;

        TcpServerSocketAcceptResponseParamsForwardToCallback(TcpServerSocket.AcceptResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(0, 2)) {
                    return false;
                }
                TcpServerSocketAcceptResponseParams response = TcpServerSocketAcceptResponseParams.deserialize(messageWithHeader.getPayload());
                this.mCallback.call(response.result, response.remoteAddress);
                return true;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class TcpServerSocketAcceptResponseParams
    extends Struct {
        private static final int STRUCT_SIZE = 24;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(24, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public NetworkError result;
        public NetAddress remoteAddress;

        private TcpServerSocketAcceptResponseParams(int version) {
            super(24, version);
        }

        public TcpServerSocketAcceptResponseParams() {
            this(0);
        }

        public static TcpServerSocketAcceptResponseParams deserialize(Message message) {
            return TcpServerSocketAcceptResponseParams.decode(new Decoder(message));
        }

        public static TcpServerSocketAcceptResponseParams decode(Decoder decoder0) {
            Decoder decoder1;
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            TcpServerSocketAcceptResponseParams result = new TcpServerSocketAcceptResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                decoder1 = decoder0.readPointer(8, false);
                result.result = NetworkError.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                decoder1 = decoder0.readPointer(16, true);
                result.remoteAddress = NetAddress.decode(decoder1);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.result, 8, false);
            encoder0.encode(this.remoteAddress, 16, true);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            TcpServerSocketAcceptResponseParams other = (TcpServerSocketAcceptResponseParams)object;
            if (!BindingsHelper.equals(this.result, other.result)) {
                return false;
            }
            return BindingsHelper.equals(this.remoteAddress, other.remoteAddress);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(result);
            result = 31 * result + BindingsHelper.hashCode(this.remoteAddress);
            return result;
        }
    }

    static final class TcpServerSocketAcceptParams
    extends Struct {
        private static final int STRUCT_SIZE = 24;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(24, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public DataPipe.ConsumerHandle sendStream = InvalidHandle.INSTANCE;
        public DataPipe.ProducerHandle receiveStream = InvalidHandle.INSTANCE;
        public InterfaceRequest<TcpConnectedSocket> clientSocket;

        private TcpServerSocketAcceptParams(int version) {
            super(24, version);
        }

        public TcpServerSocketAcceptParams() {
            this(0);
        }

        public static TcpServerSocketAcceptParams deserialize(Message message) {
            return TcpServerSocketAcceptParams.decode(new Decoder(message));
        }

        public static TcpServerSocketAcceptParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            TcpServerSocketAcceptParams result = new TcpServerSocketAcceptParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.sendStream = decoder0.readConsumerHandle(8, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.receiveStream = decoder0.readProducerHandle(12, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.clientSocket = decoder0.readInterfaceRequest(16, false);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.sendStream, 8, false);
            encoder0.encode(this.receiveStream, 12, false);
            encoder0.encode(this.clientSocket, 16, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            TcpServerSocketAcceptParams other = (TcpServerSocketAcceptParams)object;
            if (!BindingsHelper.equals(this.sendStream, other.sendStream)) {
                return false;
            }
            if (!BindingsHelper.equals(this.receiveStream, other.receiveStream)) {
                return false;
            }
            return BindingsHelper.equals(this.clientSocket, other.clientSocket);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.sendStream);
            result = 31 * result + BindingsHelper.hashCode(this.receiveStream);
            result = 31 * result + BindingsHelper.hashCode(this.clientSocket);
            return result;
        }
    }

    static final class Stub
    extends Interface.Stub<TcpServerSocket> {
        Stub(Core core, TcpServerSocket impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(0)) {
                    return false;
                }
                switch (header.getType()) {
                    case -2: {
                        return InterfaceControlMessagesHelper.handleRunOrClosePipe(MANAGER, messageWithHeader);
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(Message message, MessageReceiver receiver) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(1)) {
                    return false;
                }
                switch (header.getType()) {
                    case -1: {
                        return InterfaceControlMessagesHelper.handleRun(this.getCore(), MANAGER, messageWithHeader, receiver);
                    }
                    case 0: {
                        TcpServerSocketAcceptParams data = TcpServerSocketAcceptParams.deserialize(messageWithHeader.getPayload());
                        ((TcpServerSocket)this.getImpl()).accept(data.sendStream, data.receiveStream, data.clientSocket, new TcpServerSocketAcceptResponseParamsProxyToResponder(this.getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class Proxy
    extends Interface.AbstractProxy
    implements TcpServerSocket.Proxy {
        Proxy(Core core, MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void accept(DataPipe.ConsumerHandle sendStream, DataPipe.ProducerHandle receiveStream, InterfaceRequest<TcpConnectedSocket> clientSocket, TcpServerSocket.AcceptResponse callback) {
            TcpServerSocketAcceptParams _message = new TcpServerSocketAcceptParams();
            _message.sendStream = sendStream;
            _message.receiveStream = receiveStream;
            _message.clientSocket = clientSocket;
            this.getProxyHandler().getMessageReceiver().acceptWithResponder(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(0, 1, 0L)), new TcpServerSocketAcceptResponseParamsForwardToCallback(callback));
        }
    }
}

