/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojom.mojo;

import java.util.Arrays;
import org.chromium.mojo.bindings.BindingsHelper;
import org.chromium.mojo.bindings.DataHeader;
import org.chromium.mojo.bindings.Decoder;
import org.chromium.mojo.bindings.DeserializationException;
import org.chromium.mojo.bindings.Encoder;
import org.chromium.mojo.bindings.Interface;
import org.chromium.mojo.bindings.InterfaceControlMessagesHelper;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.MessageHeader;
import org.chromium.mojo.bindings.MessageReceiver;
import org.chromium.mojo.bindings.MessageReceiverWithResponder;
import org.chromium.mojo.bindings.ServiceMessage;
import org.chromium.mojo.bindings.Struct;
import org.chromium.mojo.system.Core;
import org.chromium.mojom.mojo.NetAddress;
import org.chromium.mojom.mojo.NetworkError;
import org.chromium.mojom.mojo.UdpSocketReceiver;

class UdpSocketReceiver_Internal {
    public static final Interface.Manager<UdpSocketReceiver, UdpSocketReceiver.Proxy> MANAGER = new Interface.Manager<UdpSocketReceiver, UdpSocketReceiver.Proxy>(){

        @Override
        public String getName() {
            return "mojo::UDPSocketReceiver";
        }

        @Override
        public int getVersion() {
            return 0;
        }

        @Override
        public Proxy buildProxy(Core core, MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        public Stub buildStub(Core core, UdpSocketReceiver impl) {
            return new Stub(core, impl);
        }

        public UdpSocketReceiver[] buildArray(int size) {
            return new UdpSocketReceiver[size];
        }
    };
    private static final int ON_RECEIVED_ORDINAL = 0;

    UdpSocketReceiver_Internal() {
    }

    static final class UdpSocketReceiverOnReceivedParams
    extends Struct {
        private static final int STRUCT_SIZE = 32;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(32, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public NetworkError result;
        public NetAddress srcAddr;
        public byte[] data;

        private UdpSocketReceiverOnReceivedParams(int version) {
            super(32, version);
        }

        public UdpSocketReceiverOnReceivedParams() {
            this(0);
        }

        public static UdpSocketReceiverOnReceivedParams deserialize(Message message) {
            return UdpSocketReceiverOnReceivedParams.decode(new Decoder(message));
        }

        public static UdpSocketReceiverOnReceivedParams decode(Decoder decoder0) {
            Decoder decoder1;
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UdpSocketReceiverOnReceivedParams result = new UdpSocketReceiverOnReceivedParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                decoder1 = decoder0.readPointer(8, false);
                result.result = NetworkError.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                decoder1 = decoder0.readPointer(16, true);
                result.srcAddr = NetAddress.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.data = decoder0.readBytes(24, 1, -1);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.result, 8, false);
            encoder0.encode(this.srcAddr, 16, true);
            encoder0.encode(this.data, 24, 1, -1);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            UdpSocketReceiverOnReceivedParams other = (UdpSocketReceiverOnReceivedParams)object;
            if (!BindingsHelper.equals(this.result, other.result)) {
                return false;
            }
            if (!BindingsHelper.equals(this.srcAddr, other.srcAddr)) {
                return false;
            }
            return Arrays.equals(this.data, other.data);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(result);
            result = 31 * result + BindingsHelper.hashCode(this.srcAddr);
            result = 31 * result + Arrays.hashCode(this.data);
            return result;
        }
    }

    static final class Stub
    extends Interface.Stub<UdpSocketReceiver> {
        Stub(Core core, UdpSocketReceiver impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(0)) {
                    return false;
                }
                switch (header.getType()) {
                    case -2: {
                        return InterfaceControlMessagesHelper.handleRunOrClosePipe(MANAGER, messageWithHeader);
                    }
                    case 0: {
                        UdpSocketReceiverOnReceivedParams data = UdpSocketReceiverOnReceivedParams.deserialize(messageWithHeader.getPayload());
                        ((UdpSocketReceiver)this.getImpl()).onReceived(data.result, data.srcAddr, data.data);
                        return true;
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(Message message, MessageReceiver receiver) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(1)) {
                    return false;
                }
                switch (header.getType()) {
                    case -1: {
                        return InterfaceControlMessagesHelper.handleRun(this.getCore(), MANAGER, messageWithHeader, receiver);
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class Proxy
    extends Interface.AbstractProxy
    implements UdpSocketReceiver.Proxy {
        Proxy(Core core, MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void onReceived(NetworkError result, NetAddress srcAddr, byte[] data) {
            UdpSocketReceiverOnReceivedParams _message = new UdpSocketReceiverOnReceivedParams();
            _message.result = result;
            _message.srcAddr = srcAddr;
            _message.data = data;
            this.getProxyHandler().getMessageReceiver().accept(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(0)));
        }
    }
}

