/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojom.mojo;

import java.util.Arrays;
import org.chromium.mojo.bindings.BindingsHelper;
import org.chromium.mojo.bindings.DataHeader;
import org.chromium.mojo.bindings.Decoder;
import org.chromium.mojo.bindings.DeserializationException;
import org.chromium.mojo.bindings.Encoder;
import org.chromium.mojo.bindings.Interface;
import org.chromium.mojo.bindings.InterfaceControlMessagesHelper;
import org.chromium.mojo.bindings.InterfaceRequest;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.MessageHeader;
import org.chromium.mojo.bindings.MessageReceiver;
import org.chromium.mojo.bindings.MessageReceiverWithResponder;
import org.chromium.mojo.bindings.ServiceMessage;
import org.chromium.mojo.bindings.SideEffectFreeCloseable;
import org.chromium.mojo.bindings.Struct;
import org.chromium.mojo.system.Core;
import org.chromium.mojom.mojo.NetAddress;
import org.chromium.mojom.mojo.NetworkError;
import org.chromium.mojom.mojo.UdpSocket;
import org.chromium.mojom.mojo.UdpSocketReceiver;

class UdpSocket_Internal {
    public static final Interface.Manager<UdpSocket, UdpSocket.Proxy> MANAGER = new Interface.Manager<UdpSocket, UdpSocket.Proxy>(){

        @Override
        public String getName() {
            return "mojo::UDPSocket";
        }

        @Override
        public int getVersion() {
            return 0;
        }

        @Override
        public Proxy buildProxy(Core core, MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        public Stub buildStub(Core core, UdpSocket impl) {
            return new Stub(core, impl);
        }

        public UdpSocket[] buildArray(int size) {
            return new UdpSocket[size];
        }
    };
    private static final int ALLOW_ADDRESS_REUSE_ORDINAL = 0;
    private static final int BIND_ORDINAL = 1;
    private static final int CONNECT_ORDINAL = 2;
    private static final int SET_SEND_BUFFER_SIZE_ORDINAL = 3;
    private static final int SET_RECEIVE_BUFFER_SIZE_ORDINAL = 4;
    private static final int NEGOTIATE_MAX_PENDING_SEND_REQUESTS_ORDINAL = 5;
    private static final int RECEIVE_MORE_ORDINAL = 6;
    private static final int SEND_TO_ORDINAL = 7;

    UdpSocket_Internal() {
    }

    static class UdpSocketSendToResponseParamsProxyToResponder
    implements UdpSocket.SendToResponse {
        private final Core mCore;
        private final MessageReceiver mMessageReceiver;
        private final long mRequestId;

        UdpSocketSendToResponseParamsProxyToResponder(Core core, MessageReceiver messageReceiver, long requestId) {
            this.mCore = core;
            this.mMessageReceiver = messageReceiver;
            this.mRequestId = requestId;
        }

        @Override
        public void call(NetworkError result) {
            UdpSocketSendToResponseParams _response = new UdpSocketSendToResponseParams();
            _response.result = result;
            ServiceMessage _message = _response.serializeWithHeader(this.mCore, new MessageHeader(7, 2, this.mRequestId));
            this.mMessageReceiver.accept(_message);
        }
    }

    static class UdpSocketSendToResponseParamsForwardToCallback
    extends SideEffectFreeCloseable
    implements MessageReceiver {
        private final UdpSocket.SendToResponse mCallback;

        UdpSocketSendToResponseParamsForwardToCallback(UdpSocket.SendToResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(7, 2)) {
                    return false;
                }
                UdpSocketSendToResponseParams response = UdpSocketSendToResponseParams.deserialize(messageWithHeader.getPayload());
                this.mCallback.call(response.result);
                return true;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class UdpSocketSendToResponseParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public NetworkError result;

        private UdpSocketSendToResponseParams(int version) {
            super(16, version);
        }

        public UdpSocketSendToResponseParams() {
            this(0);
        }

        public static UdpSocketSendToResponseParams deserialize(Message message) {
            return UdpSocketSendToResponseParams.decode(new Decoder(message));
        }

        public static UdpSocketSendToResponseParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UdpSocketSendToResponseParams result = new UdpSocketSendToResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                Decoder decoder1 = decoder0.readPointer(8, false);
                result.result = NetworkError.decode(decoder1);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.result, 8, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            UdpSocketSendToResponseParams other = (UdpSocketSendToResponseParams)object;
            return BindingsHelper.equals(this.result, other.result);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(result);
            return result;
        }
    }

    static final class UdpSocketSendToParams
    extends Struct {
        private static final int STRUCT_SIZE = 24;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(24, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public NetAddress destAddr;
        public byte[] data;

        private UdpSocketSendToParams(int version) {
            super(24, version);
        }

        public UdpSocketSendToParams() {
            this(0);
        }

        public static UdpSocketSendToParams deserialize(Message message) {
            return UdpSocketSendToParams.decode(new Decoder(message));
        }

        public static UdpSocketSendToParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UdpSocketSendToParams result = new UdpSocketSendToParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                Decoder decoder1 = decoder0.readPointer(8, true);
                result.destAddr = NetAddress.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.data = decoder0.readBytes(16, 0, -1);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.destAddr, 8, true);
            encoder0.encode(this.data, 16, 0, -1);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            UdpSocketSendToParams other = (UdpSocketSendToParams)object;
            if (!BindingsHelper.equals(this.destAddr, other.destAddr)) {
                return false;
            }
            return Arrays.equals(this.data, other.data);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.destAddr);
            result = 31 * result + Arrays.hashCode(this.data);
            return result;
        }
    }

    static final class UdpSocketReceiveMoreParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int datagramNumber;

        private UdpSocketReceiveMoreParams(int version) {
            super(16, version);
        }

        public UdpSocketReceiveMoreParams() {
            this(0);
        }

        public static UdpSocketReceiveMoreParams deserialize(Message message) {
            return UdpSocketReceiveMoreParams.decode(new Decoder(message));
        }

        public static UdpSocketReceiveMoreParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UdpSocketReceiveMoreParams result = new UdpSocketReceiveMoreParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.datagramNumber = decoder0.readInt(8);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.datagramNumber, 8);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            UdpSocketReceiveMoreParams other = (UdpSocketReceiveMoreParams)object;
            return this.datagramNumber == other.datagramNumber;
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.datagramNumber);
            return result;
        }
    }

    static class UdpSocketNegotiateMaxPendingSendRequestsResponseParamsProxyToResponder
    implements UdpSocket.NegotiateMaxPendingSendRequestsResponse {
        private final Core mCore;
        private final MessageReceiver mMessageReceiver;
        private final long mRequestId;

        UdpSocketNegotiateMaxPendingSendRequestsResponseParamsProxyToResponder(Core core, MessageReceiver messageReceiver, long requestId) {
            this.mCore = core;
            this.mMessageReceiver = messageReceiver;
            this.mRequestId = requestId;
        }

        @Override
        public void call(Integer actualSize) {
            UdpSocketNegotiateMaxPendingSendRequestsResponseParams _response = new UdpSocketNegotiateMaxPendingSendRequestsResponseParams();
            _response.actualSize = actualSize;
            ServiceMessage _message = _response.serializeWithHeader(this.mCore, new MessageHeader(5, 2, this.mRequestId));
            this.mMessageReceiver.accept(_message);
        }
    }

    static class UdpSocketNegotiateMaxPendingSendRequestsResponseParamsForwardToCallback
    extends SideEffectFreeCloseable
    implements MessageReceiver {
        private final UdpSocket.NegotiateMaxPendingSendRequestsResponse mCallback;

        UdpSocketNegotiateMaxPendingSendRequestsResponseParamsForwardToCallback(UdpSocket.NegotiateMaxPendingSendRequestsResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(5, 2)) {
                    return false;
                }
                UdpSocketNegotiateMaxPendingSendRequestsResponseParams response = UdpSocketNegotiateMaxPendingSendRequestsResponseParams.deserialize(messageWithHeader.getPayload());
                this.mCallback.call(response.actualSize);
                return true;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class UdpSocketNegotiateMaxPendingSendRequestsResponseParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int actualSize;

        private UdpSocketNegotiateMaxPendingSendRequestsResponseParams(int version) {
            super(16, version);
        }

        public UdpSocketNegotiateMaxPendingSendRequestsResponseParams() {
            this(0);
        }

        public static UdpSocketNegotiateMaxPendingSendRequestsResponseParams deserialize(Message message) {
            return UdpSocketNegotiateMaxPendingSendRequestsResponseParams.decode(new Decoder(message));
        }

        public static UdpSocketNegotiateMaxPendingSendRequestsResponseParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UdpSocketNegotiateMaxPendingSendRequestsResponseParams result = new UdpSocketNegotiateMaxPendingSendRequestsResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.actualSize = decoder0.readInt(8);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.actualSize, 8);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            UdpSocketNegotiateMaxPendingSendRequestsResponseParams other = (UdpSocketNegotiateMaxPendingSendRequestsResponseParams)object;
            return this.actualSize == other.actualSize;
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.actualSize);
            return result;
        }
    }

    static final class UdpSocketNegotiateMaxPendingSendRequestsParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int requestedSize;

        private UdpSocketNegotiateMaxPendingSendRequestsParams(int version) {
            super(16, version);
        }

        public UdpSocketNegotiateMaxPendingSendRequestsParams() {
            this(0);
        }

        public static UdpSocketNegotiateMaxPendingSendRequestsParams deserialize(Message message) {
            return UdpSocketNegotiateMaxPendingSendRequestsParams.decode(new Decoder(message));
        }

        public static UdpSocketNegotiateMaxPendingSendRequestsParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UdpSocketNegotiateMaxPendingSendRequestsParams result = new UdpSocketNegotiateMaxPendingSendRequestsParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.requestedSize = decoder0.readInt(8);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.requestedSize, 8);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            UdpSocketNegotiateMaxPendingSendRequestsParams other = (UdpSocketNegotiateMaxPendingSendRequestsParams)object;
            return this.requestedSize == other.requestedSize;
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.requestedSize);
            return result;
        }
    }

    static class UdpSocketSetReceiveBufferSizeResponseParamsProxyToResponder
    implements UdpSocket.SetReceiveBufferSizeResponse {
        private final Core mCore;
        private final MessageReceiver mMessageReceiver;
        private final long mRequestId;

        UdpSocketSetReceiveBufferSizeResponseParamsProxyToResponder(Core core, MessageReceiver messageReceiver, long requestId) {
            this.mCore = core;
            this.mMessageReceiver = messageReceiver;
            this.mRequestId = requestId;
        }

        @Override
        public void call(NetworkError result) {
            UdpSocketSetReceiveBufferSizeResponseParams _response = new UdpSocketSetReceiveBufferSizeResponseParams();
            _response.result = result;
            ServiceMessage _message = _response.serializeWithHeader(this.mCore, new MessageHeader(4, 2, this.mRequestId));
            this.mMessageReceiver.accept(_message);
        }
    }

    static class UdpSocketSetReceiveBufferSizeResponseParamsForwardToCallback
    extends SideEffectFreeCloseable
    implements MessageReceiver {
        private final UdpSocket.SetReceiveBufferSizeResponse mCallback;

        UdpSocketSetReceiveBufferSizeResponseParamsForwardToCallback(UdpSocket.SetReceiveBufferSizeResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(4, 2)) {
                    return false;
                }
                UdpSocketSetReceiveBufferSizeResponseParams response = UdpSocketSetReceiveBufferSizeResponseParams.deserialize(messageWithHeader.getPayload());
                this.mCallback.call(response.result);
                return true;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class UdpSocketSetReceiveBufferSizeResponseParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public NetworkError result;

        private UdpSocketSetReceiveBufferSizeResponseParams(int version) {
            super(16, version);
        }

        public UdpSocketSetReceiveBufferSizeResponseParams() {
            this(0);
        }

        public static UdpSocketSetReceiveBufferSizeResponseParams deserialize(Message message) {
            return UdpSocketSetReceiveBufferSizeResponseParams.decode(new Decoder(message));
        }

        public static UdpSocketSetReceiveBufferSizeResponseParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UdpSocketSetReceiveBufferSizeResponseParams result = new UdpSocketSetReceiveBufferSizeResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                Decoder decoder1 = decoder0.readPointer(8, false);
                result.result = NetworkError.decode(decoder1);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.result, 8, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            UdpSocketSetReceiveBufferSizeResponseParams other = (UdpSocketSetReceiveBufferSizeResponseParams)object;
            return BindingsHelper.equals(this.result, other.result);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(result);
            return result;
        }
    }

    static final class UdpSocketSetReceiveBufferSizeParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int size;

        private UdpSocketSetReceiveBufferSizeParams(int version) {
            super(16, version);
        }

        public UdpSocketSetReceiveBufferSizeParams() {
            this(0);
        }

        public static UdpSocketSetReceiveBufferSizeParams deserialize(Message message) {
            return UdpSocketSetReceiveBufferSizeParams.decode(new Decoder(message));
        }

        public static UdpSocketSetReceiveBufferSizeParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UdpSocketSetReceiveBufferSizeParams result = new UdpSocketSetReceiveBufferSizeParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.size = decoder0.readInt(8);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.size, 8);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            UdpSocketSetReceiveBufferSizeParams other = (UdpSocketSetReceiveBufferSizeParams)object;
            return this.size == other.size;
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.size);
            return result;
        }
    }

    static class UdpSocketSetSendBufferSizeResponseParamsProxyToResponder
    implements UdpSocket.SetSendBufferSizeResponse {
        private final Core mCore;
        private final MessageReceiver mMessageReceiver;
        private final long mRequestId;

        UdpSocketSetSendBufferSizeResponseParamsProxyToResponder(Core core, MessageReceiver messageReceiver, long requestId) {
            this.mCore = core;
            this.mMessageReceiver = messageReceiver;
            this.mRequestId = requestId;
        }

        @Override
        public void call(NetworkError result) {
            UdpSocketSetSendBufferSizeResponseParams _response = new UdpSocketSetSendBufferSizeResponseParams();
            _response.result = result;
            ServiceMessage _message = _response.serializeWithHeader(this.mCore, new MessageHeader(3, 2, this.mRequestId));
            this.mMessageReceiver.accept(_message);
        }
    }

    static class UdpSocketSetSendBufferSizeResponseParamsForwardToCallback
    extends SideEffectFreeCloseable
    implements MessageReceiver {
        private final UdpSocket.SetSendBufferSizeResponse mCallback;

        UdpSocketSetSendBufferSizeResponseParamsForwardToCallback(UdpSocket.SetSendBufferSizeResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(3, 2)) {
                    return false;
                }
                UdpSocketSetSendBufferSizeResponseParams response = UdpSocketSetSendBufferSizeResponseParams.deserialize(messageWithHeader.getPayload());
                this.mCallback.call(response.result);
                return true;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class UdpSocketSetSendBufferSizeResponseParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public NetworkError result;

        private UdpSocketSetSendBufferSizeResponseParams(int version) {
            super(16, version);
        }

        public UdpSocketSetSendBufferSizeResponseParams() {
            this(0);
        }

        public static UdpSocketSetSendBufferSizeResponseParams deserialize(Message message) {
            return UdpSocketSetSendBufferSizeResponseParams.decode(new Decoder(message));
        }

        public static UdpSocketSetSendBufferSizeResponseParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UdpSocketSetSendBufferSizeResponseParams result = new UdpSocketSetSendBufferSizeResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                Decoder decoder1 = decoder0.readPointer(8, false);
                result.result = NetworkError.decode(decoder1);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.result, 8, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            UdpSocketSetSendBufferSizeResponseParams other = (UdpSocketSetSendBufferSizeResponseParams)object;
            return BindingsHelper.equals(this.result, other.result);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(result);
            return result;
        }
    }

    static final class UdpSocketSetSendBufferSizeParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int size;

        private UdpSocketSetSendBufferSizeParams(int version) {
            super(16, version);
        }

        public UdpSocketSetSendBufferSizeParams() {
            this(0);
        }

        public static UdpSocketSetSendBufferSizeParams deserialize(Message message) {
            return UdpSocketSetSendBufferSizeParams.decode(new Decoder(message));
        }

        public static UdpSocketSetSendBufferSizeParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UdpSocketSetSendBufferSizeParams result = new UdpSocketSetSendBufferSizeParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.size = decoder0.readInt(8);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.size, 8);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            UdpSocketSetSendBufferSizeParams other = (UdpSocketSetSendBufferSizeParams)object;
            return this.size == other.size;
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.size);
            return result;
        }
    }

    static class UdpSocketConnectResponseParamsProxyToResponder
    implements UdpSocket.ConnectResponse {
        private final Core mCore;
        private final MessageReceiver mMessageReceiver;
        private final long mRequestId;

        UdpSocketConnectResponseParamsProxyToResponder(Core core, MessageReceiver messageReceiver, long requestId) {
            this.mCore = core;
            this.mMessageReceiver = messageReceiver;
            this.mRequestId = requestId;
        }

        @Override
        public void call(NetworkError result, NetAddress localAddr, InterfaceRequest<UdpSocketReceiver> receiver) {
            UdpSocketConnectResponseParams _response = new UdpSocketConnectResponseParams();
            _response.result = result;
            _response.localAddr = localAddr;
            _response.receiver = receiver;
            ServiceMessage _message = _response.serializeWithHeader(this.mCore, new MessageHeader(2, 2, this.mRequestId));
            this.mMessageReceiver.accept(_message);
        }
    }

    static class UdpSocketConnectResponseParamsForwardToCallback
    extends SideEffectFreeCloseable
    implements MessageReceiver {
        private final UdpSocket.ConnectResponse mCallback;

        UdpSocketConnectResponseParamsForwardToCallback(UdpSocket.ConnectResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(2, 2)) {
                    return false;
                }
                UdpSocketConnectResponseParams response = UdpSocketConnectResponseParams.deserialize(messageWithHeader.getPayload());
                this.mCallback.call(response.result, response.localAddr, response.receiver);
                return true;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class UdpSocketConnectResponseParams
    extends Struct {
        private static final int STRUCT_SIZE = 32;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(32, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public NetworkError result;
        public NetAddress localAddr;
        public InterfaceRequest<UdpSocketReceiver> receiver;

        private UdpSocketConnectResponseParams(int version) {
            super(32, version);
        }

        public UdpSocketConnectResponseParams() {
            this(0);
        }

        public static UdpSocketConnectResponseParams deserialize(Message message) {
            return UdpSocketConnectResponseParams.decode(new Decoder(message));
        }

        public static UdpSocketConnectResponseParams decode(Decoder decoder0) {
            Decoder decoder1;
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UdpSocketConnectResponseParams result = new UdpSocketConnectResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                decoder1 = decoder0.readPointer(8, false);
                result.result = NetworkError.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                decoder1 = decoder0.readPointer(16, true);
                result.localAddr = NetAddress.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.receiver = decoder0.readInterfaceRequest(24, true);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.result, 8, false);
            encoder0.encode(this.localAddr, 16, true);
            encoder0.encode(this.receiver, 24, true);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            UdpSocketConnectResponseParams other = (UdpSocketConnectResponseParams)object;
            if (!BindingsHelper.equals(this.result, other.result)) {
                return false;
            }
            if (!BindingsHelper.equals(this.localAddr, other.localAddr)) {
                return false;
            }
            return BindingsHelper.equals(this.receiver, other.receiver);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(result);
            result = 31 * result + BindingsHelper.hashCode(this.localAddr);
            result = 31 * result + BindingsHelper.hashCode(this.receiver);
            return result;
        }
    }

    static final class UdpSocketConnectParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public NetAddress remoteAddr;

        private UdpSocketConnectParams(int version) {
            super(16, version);
        }

        public UdpSocketConnectParams() {
            this(0);
        }

        public static UdpSocketConnectParams deserialize(Message message) {
            return UdpSocketConnectParams.decode(new Decoder(message));
        }

        public static UdpSocketConnectParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UdpSocketConnectParams result = new UdpSocketConnectParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                Decoder decoder1 = decoder0.readPointer(8, false);
                result.remoteAddr = NetAddress.decode(decoder1);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.remoteAddr, 8, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            UdpSocketConnectParams other = (UdpSocketConnectParams)object;
            return BindingsHelper.equals(this.remoteAddr, other.remoteAddr);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.remoteAddr);
            return result;
        }
    }

    static class UdpSocketBindResponseParamsProxyToResponder
    implements UdpSocket.BindResponse {
        private final Core mCore;
        private final MessageReceiver mMessageReceiver;
        private final long mRequestId;

        UdpSocketBindResponseParamsProxyToResponder(Core core, MessageReceiver messageReceiver, long requestId) {
            this.mCore = core;
            this.mMessageReceiver = messageReceiver;
            this.mRequestId = requestId;
        }

        @Override
        public void call(NetworkError result, NetAddress boundAddr, InterfaceRequest<UdpSocketReceiver> receiver) {
            UdpSocketBindResponseParams _response = new UdpSocketBindResponseParams();
            _response.result = result;
            _response.boundAddr = boundAddr;
            _response.receiver = receiver;
            ServiceMessage _message = _response.serializeWithHeader(this.mCore, new MessageHeader(1, 2, this.mRequestId));
            this.mMessageReceiver.accept(_message);
        }
    }

    static class UdpSocketBindResponseParamsForwardToCallback
    extends SideEffectFreeCloseable
    implements MessageReceiver {
        private final UdpSocket.BindResponse mCallback;

        UdpSocketBindResponseParamsForwardToCallback(UdpSocket.BindResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(1, 2)) {
                    return false;
                }
                UdpSocketBindResponseParams response = UdpSocketBindResponseParams.deserialize(messageWithHeader.getPayload());
                this.mCallback.call(response.result, response.boundAddr, response.receiver);
                return true;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class UdpSocketBindResponseParams
    extends Struct {
        private static final int STRUCT_SIZE = 32;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(32, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public NetworkError result;
        public NetAddress boundAddr;
        public InterfaceRequest<UdpSocketReceiver> receiver;

        private UdpSocketBindResponseParams(int version) {
            super(32, version);
        }

        public UdpSocketBindResponseParams() {
            this(0);
        }

        public static UdpSocketBindResponseParams deserialize(Message message) {
            return UdpSocketBindResponseParams.decode(new Decoder(message));
        }

        public static UdpSocketBindResponseParams decode(Decoder decoder0) {
            Decoder decoder1;
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UdpSocketBindResponseParams result = new UdpSocketBindResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                decoder1 = decoder0.readPointer(8, false);
                result.result = NetworkError.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                decoder1 = decoder0.readPointer(16, true);
                result.boundAddr = NetAddress.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.receiver = decoder0.readInterfaceRequest(24, true);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.result, 8, false);
            encoder0.encode(this.boundAddr, 16, true);
            encoder0.encode(this.receiver, 24, true);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            UdpSocketBindResponseParams other = (UdpSocketBindResponseParams)object;
            if (!BindingsHelper.equals(this.result, other.result)) {
                return false;
            }
            if (!BindingsHelper.equals(this.boundAddr, other.boundAddr)) {
                return false;
            }
            return BindingsHelper.equals(this.receiver, other.receiver);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(result);
            result = 31 * result + BindingsHelper.hashCode(this.boundAddr);
            result = 31 * result + BindingsHelper.hashCode(this.receiver);
            return result;
        }
    }

    static final class UdpSocketBindParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public NetAddress addr;

        private UdpSocketBindParams(int version) {
            super(16, version);
        }

        public UdpSocketBindParams() {
            this(0);
        }

        public static UdpSocketBindParams deserialize(Message message) {
            return UdpSocketBindParams.decode(new Decoder(message));
        }

        public static UdpSocketBindParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UdpSocketBindParams result = new UdpSocketBindParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                Decoder decoder1 = decoder0.readPointer(8, false);
                result.addr = NetAddress.decode(decoder1);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.addr, 8, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            UdpSocketBindParams other = (UdpSocketBindParams)object;
            return BindingsHelper.equals(this.addr, other.addr);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.addr);
            return result;
        }
    }

    static class UdpSocketAllowAddressReuseResponseParamsProxyToResponder
    implements UdpSocket.AllowAddressReuseResponse {
        private final Core mCore;
        private final MessageReceiver mMessageReceiver;
        private final long mRequestId;

        UdpSocketAllowAddressReuseResponseParamsProxyToResponder(Core core, MessageReceiver messageReceiver, long requestId) {
            this.mCore = core;
            this.mMessageReceiver = messageReceiver;
            this.mRequestId = requestId;
        }

        @Override
        public void call(NetworkError result) {
            UdpSocketAllowAddressReuseResponseParams _response = new UdpSocketAllowAddressReuseResponseParams();
            _response.result = result;
            ServiceMessage _message = _response.serializeWithHeader(this.mCore, new MessageHeader(0, 2, this.mRequestId));
            this.mMessageReceiver.accept(_message);
        }
    }

    static class UdpSocketAllowAddressReuseResponseParamsForwardToCallback
    extends SideEffectFreeCloseable
    implements MessageReceiver {
        private final UdpSocket.AllowAddressReuseResponse mCallback;

        UdpSocketAllowAddressReuseResponseParamsForwardToCallback(UdpSocket.AllowAddressReuseResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(0, 2)) {
                    return false;
                }
                UdpSocketAllowAddressReuseResponseParams response = UdpSocketAllowAddressReuseResponseParams.deserialize(messageWithHeader.getPayload());
                this.mCallback.call(response.result);
                return true;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class UdpSocketAllowAddressReuseResponseParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public NetworkError result;

        private UdpSocketAllowAddressReuseResponseParams(int version) {
            super(16, version);
        }

        public UdpSocketAllowAddressReuseResponseParams() {
            this(0);
        }

        public static UdpSocketAllowAddressReuseResponseParams deserialize(Message message) {
            return UdpSocketAllowAddressReuseResponseParams.decode(new Decoder(message));
        }

        public static UdpSocketAllowAddressReuseResponseParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UdpSocketAllowAddressReuseResponseParams result = new UdpSocketAllowAddressReuseResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                Decoder decoder1 = decoder0.readPointer(8, false);
                result.result = NetworkError.decode(decoder1);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.result, 8, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            UdpSocketAllowAddressReuseResponseParams other = (UdpSocketAllowAddressReuseResponseParams)object;
            return BindingsHelper.equals(this.result, other.result);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(result);
            return result;
        }
    }

    static final class UdpSocketAllowAddressReuseParams
    extends Struct {
        private static final int STRUCT_SIZE = 8;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(8, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private UdpSocketAllowAddressReuseParams(int version) {
            super(8, version);
        }

        public UdpSocketAllowAddressReuseParams() {
            this(0);
        }

        public static UdpSocketAllowAddressReuseParams deserialize(Message message) {
            return UdpSocketAllowAddressReuseParams.decode(new Decoder(message));
        }

        public static UdpSocketAllowAddressReuseParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UdpSocketAllowAddressReuseParams result = new UdpSocketAllowAddressReuseParams(mainDataHeader.elementsOrVersion);
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            return this.getClass() == object.getClass();
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            return result;
        }
    }

    static final class Stub
    extends Interface.Stub<UdpSocket> {
        Stub(Core core, UdpSocket impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(0)) {
                    return false;
                }
                switch (header.getType()) {
                    case -2: {
                        return InterfaceControlMessagesHelper.handleRunOrClosePipe(MANAGER, messageWithHeader);
                    }
                    case 6: {
                        UdpSocketReceiveMoreParams data = UdpSocketReceiveMoreParams.deserialize(messageWithHeader.getPayload());
                        ((UdpSocket)this.getImpl()).receiveMore(data.datagramNumber);
                        return true;
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(Message message, MessageReceiver receiver) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(1)) {
                    return false;
                }
                switch (header.getType()) {
                    case -1: {
                        return InterfaceControlMessagesHelper.handleRun(this.getCore(), MANAGER, messageWithHeader, receiver);
                    }
                    case 0: {
                        UdpSocketAllowAddressReuseParams.deserialize(messageWithHeader.getPayload());
                        ((UdpSocket)this.getImpl()).allowAddressReuse(new UdpSocketAllowAddressReuseResponseParamsProxyToResponder(this.getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case 1: {
                        UdpSocketBindParams data = UdpSocketBindParams.deserialize(messageWithHeader.getPayload());
                        ((UdpSocket)this.getImpl()).bind(data.addr, new UdpSocketBindResponseParamsProxyToResponder(this.getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case 2: {
                        UdpSocketConnectParams data = UdpSocketConnectParams.deserialize(messageWithHeader.getPayload());
                        ((UdpSocket)this.getImpl()).connect(data.remoteAddr, new UdpSocketConnectResponseParamsProxyToResponder(this.getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case 3: {
                        UdpSocketSetSendBufferSizeParams data = UdpSocketSetSendBufferSizeParams.deserialize(messageWithHeader.getPayload());
                        ((UdpSocket)this.getImpl()).setSendBufferSize(data.size, new UdpSocketSetSendBufferSizeResponseParamsProxyToResponder(this.getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case 4: {
                        UdpSocketSetReceiveBufferSizeParams data = UdpSocketSetReceiveBufferSizeParams.deserialize(messageWithHeader.getPayload());
                        ((UdpSocket)this.getImpl()).setReceiveBufferSize(data.size, new UdpSocketSetReceiveBufferSizeResponseParamsProxyToResponder(this.getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case 5: {
                        UdpSocketNegotiateMaxPendingSendRequestsParams data = UdpSocketNegotiateMaxPendingSendRequestsParams.deserialize(messageWithHeader.getPayload());
                        ((UdpSocket)this.getImpl()).negotiateMaxPendingSendRequests(data.requestedSize, new UdpSocketNegotiateMaxPendingSendRequestsResponseParamsProxyToResponder(this.getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case 7: {
                        UdpSocketSendToParams data = UdpSocketSendToParams.deserialize(messageWithHeader.getPayload());
                        ((UdpSocket)this.getImpl()).sendTo(data.destAddr, data.data, new UdpSocketSendToResponseParamsProxyToResponder(this.getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class Proxy
    extends Interface.AbstractProxy
    implements UdpSocket.Proxy {
        Proxy(Core core, MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void allowAddressReuse(UdpSocket.AllowAddressReuseResponse callback) {
            UdpSocketAllowAddressReuseParams _message = new UdpSocketAllowAddressReuseParams();
            this.getProxyHandler().getMessageReceiver().acceptWithResponder(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(0, 1, 0L)), new UdpSocketAllowAddressReuseResponseParamsForwardToCallback(callback));
        }

        @Override
        public void bind(NetAddress addr, UdpSocket.BindResponse callback) {
            UdpSocketBindParams _message = new UdpSocketBindParams();
            _message.addr = addr;
            this.getProxyHandler().getMessageReceiver().acceptWithResponder(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(1, 1, 0L)), new UdpSocketBindResponseParamsForwardToCallback(callback));
        }

        @Override
        public void connect(NetAddress remoteAddr, UdpSocket.ConnectResponse callback) {
            UdpSocketConnectParams _message = new UdpSocketConnectParams();
            _message.remoteAddr = remoteAddr;
            this.getProxyHandler().getMessageReceiver().acceptWithResponder(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(2, 1, 0L)), new UdpSocketConnectResponseParamsForwardToCallback(callback));
        }

        @Override
        public void setSendBufferSize(int size, UdpSocket.SetSendBufferSizeResponse callback) {
            UdpSocketSetSendBufferSizeParams _message = new UdpSocketSetSendBufferSizeParams();
            _message.size = size;
            this.getProxyHandler().getMessageReceiver().acceptWithResponder(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(3, 1, 0L)), new UdpSocketSetSendBufferSizeResponseParamsForwardToCallback(callback));
        }

        @Override
        public void setReceiveBufferSize(int size, UdpSocket.SetReceiveBufferSizeResponse callback) {
            UdpSocketSetReceiveBufferSizeParams _message = new UdpSocketSetReceiveBufferSizeParams();
            _message.size = size;
            this.getProxyHandler().getMessageReceiver().acceptWithResponder(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(4, 1, 0L)), new UdpSocketSetReceiveBufferSizeResponseParamsForwardToCallback(callback));
        }

        @Override
        public void negotiateMaxPendingSendRequests(int requestedSize, UdpSocket.NegotiateMaxPendingSendRequestsResponse callback) {
            UdpSocketNegotiateMaxPendingSendRequestsParams _message = new UdpSocketNegotiateMaxPendingSendRequestsParams();
            _message.requestedSize = requestedSize;
            this.getProxyHandler().getMessageReceiver().acceptWithResponder(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(5, 1, 0L)), new UdpSocketNegotiateMaxPendingSendRequestsResponseParamsForwardToCallback(callback));
        }

        @Override
        public void receiveMore(int datagramNumber) {
            UdpSocketReceiveMoreParams _message = new UdpSocketReceiveMoreParams();
            _message.datagramNumber = datagramNumber;
            this.getProxyHandler().getMessageReceiver().accept(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(6)));
        }

        @Override
        public void sendTo(NetAddress destAddr, byte[] data, UdpSocket.SendToResponse callback) {
            UdpSocketSendToParams _message = new UdpSocketSendToParams();
            _message.destAddr = destAddr;
            _message.data = data;
            this.getProxyHandler().getMessageReceiver().acceptWithResponder(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(7, 1, 0L)), new UdpSocketSendToResponseParamsForwardToCallback(callback));
        }
    }
}

