/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojom.mojo;

import org.chromium.mojo.bindings.BindingsHelper;
import org.chromium.mojo.bindings.DataHeader;
import org.chromium.mojo.bindings.Decoder;
import org.chromium.mojo.bindings.DeserializationException;
import org.chromium.mojo.bindings.Encoder;
import org.chromium.mojo.bindings.Interface;
import org.chromium.mojo.bindings.InterfaceControlMessagesHelper;
import org.chromium.mojo.bindings.InterfaceRequest;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.MessageHeader;
import org.chromium.mojo.bindings.MessageReceiver;
import org.chromium.mojo.bindings.MessageReceiverWithResponder;
import org.chromium.mojo.bindings.ServiceMessage;
import org.chromium.mojo.bindings.Struct;
import org.chromium.mojo.system.Core;
import org.chromium.mojom.mojo.UrlLoader;
import org.chromium.mojom.mojo.UrlLoaderFactory;

class UrlLoaderFactory_Internal {
    public static final Interface.Manager<UrlLoaderFactory, UrlLoaderFactory.Proxy> MANAGER = new Interface.Manager<UrlLoaderFactory, UrlLoaderFactory.Proxy>(){

        @Override
        public String getName() {
            return "mojo::URLLoaderFactory";
        }

        @Override
        public int getVersion() {
            return 0;
        }

        @Override
        public Proxy buildProxy(Core core, MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        public Stub buildStub(Core core, UrlLoaderFactory impl) {
            return new Stub(core, impl);
        }

        public UrlLoaderFactory[] buildArray(int size) {
            return new UrlLoaderFactory[size];
        }
    };
    private static final int CREATE_URL_LOADER_ORDINAL = 0;

    UrlLoaderFactory_Internal() {
    }

    static final class UrlLoaderFactoryCreateUrlLoaderParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public InterfaceRequest<UrlLoader> loader;

        private UrlLoaderFactoryCreateUrlLoaderParams(int version) {
            super(16, version);
        }

        public UrlLoaderFactoryCreateUrlLoaderParams() {
            this(0);
        }

        public static UrlLoaderFactoryCreateUrlLoaderParams deserialize(Message message) {
            return UrlLoaderFactoryCreateUrlLoaderParams.decode(new Decoder(message));
        }

        public static UrlLoaderFactoryCreateUrlLoaderParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UrlLoaderFactoryCreateUrlLoaderParams result = new UrlLoaderFactoryCreateUrlLoaderParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.loader = decoder0.readInterfaceRequest(8, false);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.loader, 8, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            UrlLoaderFactoryCreateUrlLoaderParams other = (UrlLoaderFactoryCreateUrlLoaderParams)object;
            return BindingsHelper.equals(this.loader, other.loader);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.loader);
            return result;
        }
    }

    static final class Stub
    extends Interface.Stub<UrlLoaderFactory> {
        Stub(Core core, UrlLoaderFactory impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(0)) {
                    return false;
                }
                switch (header.getType()) {
                    case -2: {
                        return InterfaceControlMessagesHelper.handleRunOrClosePipe(MANAGER, messageWithHeader);
                    }
                    case 0: {
                        UrlLoaderFactoryCreateUrlLoaderParams data = UrlLoaderFactoryCreateUrlLoaderParams.deserialize(messageWithHeader.getPayload());
                        ((UrlLoaderFactory)this.getImpl()).createUrlLoader(data.loader);
                        return true;
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(Message message, MessageReceiver receiver) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(1)) {
                    return false;
                }
                switch (header.getType()) {
                    case -1: {
                        return InterfaceControlMessagesHelper.handleRun(this.getCore(), MANAGER, messageWithHeader, receiver);
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class Proxy
    extends Interface.AbstractProxy
    implements UrlLoaderFactory.Proxy {
        Proxy(Core core, MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void createUrlLoader(InterfaceRequest<UrlLoader> loader) {
            UrlLoaderFactoryCreateUrlLoaderParams _message = new UrlLoaderFactoryCreateUrlLoaderParams();
            _message.loader = loader;
            this.getProxyHandler().getMessageReceiver().accept(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(0)));
        }
    }
}

