/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojom.mojo;

import org.chromium.mojo.bindings.BindingsHelper;
import org.chromium.mojo.bindings.DataHeader;
import org.chromium.mojo.bindings.Decoder;
import org.chromium.mojo.bindings.Encoder;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.Struct;
import org.chromium.mojom.mojo.NetworkError;

public final class UrlLoaderStatus
extends Struct {
    private static final int STRUCT_SIZE = 24;
    private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(24, 0)};
    private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public NetworkError error;
    public boolean isLoading;

    private UrlLoaderStatus(int version) {
        super(24, version);
    }

    public UrlLoaderStatus() {
        this(0);
    }

    public static UrlLoaderStatus deserialize(Message message) {
        return UrlLoaderStatus.decode(new Decoder(message));
    }

    public static UrlLoaderStatus decode(Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        UrlLoaderStatus result = new UrlLoaderStatus(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            Decoder decoder1 = decoder0.readPointer(8, true);
            result.error = NetworkError.decode(decoder1);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.isLoading = decoder0.readBoolean(16, 0);
        }
        return result;
    }

    @Override
    protected final void encode(Encoder encoder) {
        Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(this.error, 8, true);
        encoder0.encode(this.isLoading, 16, 0);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UrlLoaderStatus other = (UrlLoaderStatus)object;
        if (!BindingsHelper.equals(this.error, other.error)) {
            return false;
        }
        return this.isLoading == other.isLoading;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.getClass().hashCode();
        result = 31 * result + BindingsHelper.hashCode(this.error);
        result = 31 * result + BindingsHelper.hashCode(this.isLoading);
        return result;
    }
}

