/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojom.mojo;

import org.chromium.mojo.bindings.BindingsHelper;
import org.chromium.mojo.bindings.DataHeader;
import org.chromium.mojo.bindings.Decoder;
import org.chromium.mojo.bindings.DeserializationException;
import org.chromium.mojo.bindings.Encoder;
import org.chromium.mojo.bindings.Interface;
import org.chromium.mojo.bindings.InterfaceControlMessagesHelper;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.MessageHeader;
import org.chromium.mojo.bindings.MessageReceiver;
import org.chromium.mojo.bindings.MessageReceiverWithResponder;
import org.chromium.mojo.bindings.ServiceMessage;
import org.chromium.mojo.bindings.SideEffectFreeCloseable;
import org.chromium.mojo.bindings.Struct;
import org.chromium.mojo.system.Core;
import org.chromium.mojom.mojo.UrlLoader;
import org.chromium.mojom.mojo.UrlLoaderStatus;
import org.chromium.mojom.mojo.UrlRequest;
import org.chromium.mojom.mojo.UrlResponse;

class UrlLoader_Internal {
    public static final Interface.Manager<UrlLoader, UrlLoader.Proxy> MANAGER = new Interface.Manager<UrlLoader, UrlLoader.Proxy>(){

        @Override
        public String getName() {
            return "mojo::URLLoader";
        }

        @Override
        public int getVersion() {
            return 0;
        }

        @Override
        public Proxy buildProxy(Core core, MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        public Stub buildStub(Core core, UrlLoader impl) {
            return new Stub(core, impl);
        }

        public UrlLoader[] buildArray(int size) {
            return new UrlLoader[size];
        }
    };
    private static final int START_ORDINAL = 0;
    private static final int FOLLOW_REDIRECT_ORDINAL = 1;
    private static final int QUERY_STATUS_ORDINAL = 2;

    UrlLoader_Internal() {
    }

    static class UrlLoaderQueryStatusResponseParamsProxyToResponder
    implements UrlLoader.QueryStatusResponse {
        private final Core mCore;
        private final MessageReceiver mMessageReceiver;
        private final long mRequestId;

        UrlLoaderQueryStatusResponseParamsProxyToResponder(Core core, MessageReceiver messageReceiver, long requestId) {
            this.mCore = core;
            this.mMessageReceiver = messageReceiver;
            this.mRequestId = requestId;
        }

        @Override
        public void call(UrlLoaderStatus status) {
            UrlLoaderQueryStatusResponseParams _response = new UrlLoaderQueryStatusResponseParams();
            _response.status = status;
            ServiceMessage _message = _response.serializeWithHeader(this.mCore, new MessageHeader(2, 2, this.mRequestId));
            this.mMessageReceiver.accept(_message);
        }
    }

    static class UrlLoaderQueryStatusResponseParamsForwardToCallback
    extends SideEffectFreeCloseable
    implements MessageReceiver {
        private final UrlLoader.QueryStatusResponse mCallback;

        UrlLoaderQueryStatusResponseParamsForwardToCallback(UrlLoader.QueryStatusResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(2, 2)) {
                    return false;
                }
                UrlLoaderQueryStatusResponseParams response = UrlLoaderQueryStatusResponseParams.deserialize(messageWithHeader.getPayload());
                this.mCallback.call(response.status);
                return true;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class UrlLoaderQueryStatusResponseParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public UrlLoaderStatus status;

        private UrlLoaderQueryStatusResponseParams(int version) {
            super(16, version);
        }

        public UrlLoaderQueryStatusResponseParams() {
            this(0);
        }

        public static UrlLoaderQueryStatusResponseParams deserialize(Message message) {
            return UrlLoaderQueryStatusResponseParams.decode(new Decoder(message));
        }

        public static UrlLoaderQueryStatusResponseParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UrlLoaderQueryStatusResponseParams result = new UrlLoaderQueryStatusResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                Decoder decoder1 = decoder0.readPointer(8, false);
                result.status = UrlLoaderStatus.decode(decoder1);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.status, 8, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            UrlLoaderQueryStatusResponseParams other = (UrlLoaderQueryStatusResponseParams)object;
            return BindingsHelper.equals(this.status, other.status);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.status);
            return result;
        }
    }

    static final class UrlLoaderQueryStatusParams
    extends Struct {
        private static final int STRUCT_SIZE = 8;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(8, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private UrlLoaderQueryStatusParams(int version) {
            super(8, version);
        }

        public UrlLoaderQueryStatusParams() {
            this(0);
        }

        public static UrlLoaderQueryStatusParams deserialize(Message message) {
            return UrlLoaderQueryStatusParams.decode(new Decoder(message));
        }

        public static UrlLoaderQueryStatusParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UrlLoaderQueryStatusParams result = new UrlLoaderQueryStatusParams(mainDataHeader.elementsOrVersion);
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            return this.getClass() == object.getClass();
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            return result;
        }
    }

    static class UrlLoaderFollowRedirectResponseParamsProxyToResponder
    implements UrlLoader.FollowRedirectResponse {
        private final Core mCore;
        private final MessageReceiver mMessageReceiver;
        private final long mRequestId;

        UrlLoaderFollowRedirectResponseParamsProxyToResponder(Core core, MessageReceiver messageReceiver, long requestId) {
            this.mCore = core;
            this.mMessageReceiver = messageReceiver;
            this.mRequestId = requestId;
        }

        @Override
        public void call(UrlResponse response) {
            UrlLoaderFollowRedirectResponseParams _response = new UrlLoaderFollowRedirectResponseParams();
            _response.response = response;
            ServiceMessage _message = _response.serializeWithHeader(this.mCore, new MessageHeader(1, 2, this.mRequestId));
            this.mMessageReceiver.accept(_message);
        }
    }

    static class UrlLoaderFollowRedirectResponseParamsForwardToCallback
    extends SideEffectFreeCloseable
    implements MessageReceiver {
        private final UrlLoader.FollowRedirectResponse mCallback;

        UrlLoaderFollowRedirectResponseParamsForwardToCallback(UrlLoader.FollowRedirectResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(1, 2)) {
                    return false;
                }
                UrlLoaderFollowRedirectResponseParams response = UrlLoaderFollowRedirectResponseParams.deserialize(messageWithHeader.getPayload());
                this.mCallback.call(response.response);
                return true;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class UrlLoaderFollowRedirectResponseParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public UrlResponse response;

        private UrlLoaderFollowRedirectResponseParams(int version) {
            super(16, version);
        }

        public UrlLoaderFollowRedirectResponseParams() {
            this(0);
        }

        public static UrlLoaderFollowRedirectResponseParams deserialize(Message message) {
            return UrlLoaderFollowRedirectResponseParams.decode(new Decoder(message));
        }

        public static UrlLoaderFollowRedirectResponseParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UrlLoaderFollowRedirectResponseParams result = new UrlLoaderFollowRedirectResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                Decoder decoder1 = decoder0.readPointer(8, false);
                result.response = UrlResponse.decode(decoder1);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.response, 8, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            UrlLoaderFollowRedirectResponseParams other = (UrlLoaderFollowRedirectResponseParams)object;
            return BindingsHelper.equals(this.response, other.response);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.response);
            return result;
        }
    }

    static final class UrlLoaderFollowRedirectParams
    extends Struct {
        private static final int STRUCT_SIZE = 8;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(8, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private UrlLoaderFollowRedirectParams(int version) {
            super(8, version);
        }

        public UrlLoaderFollowRedirectParams() {
            this(0);
        }

        public static UrlLoaderFollowRedirectParams deserialize(Message message) {
            return UrlLoaderFollowRedirectParams.decode(new Decoder(message));
        }

        public static UrlLoaderFollowRedirectParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UrlLoaderFollowRedirectParams result = new UrlLoaderFollowRedirectParams(mainDataHeader.elementsOrVersion);
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            return this.getClass() == object.getClass();
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            return result;
        }
    }

    static class UrlLoaderStartResponseParamsProxyToResponder
    implements UrlLoader.StartResponse {
        private final Core mCore;
        private final MessageReceiver mMessageReceiver;
        private final long mRequestId;

        UrlLoaderStartResponseParamsProxyToResponder(Core core, MessageReceiver messageReceiver, long requestId) {
            this.mCore = core;
            this.mMessageReceiver = messageReceiver;
            this.mRequestId = requestId;
        }

        @Override
        public void call(UrlResponse response) {
            UrlLoaderStartResponseParams _response = new UrlLoaderStartResponseParams();
            _response.response = response;
            ServiceMessage _message = _response.serializeWithHeader(this.mCore, new MessageHeader(0, 2, this.mRequestId));
            this.mMessageReceiver.accept(_message);
        }
    }

    static class UrlLoaderStartResponseParamsForwardToCallback
    extends SideEffectFreeCloseable
    implements MessageReceiver {
        private final UrlLoader.StartResponse mCallback;

        UrlLoaderStartResponseParamsForwardToCallback(UrlLoader.StartResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(0, 2)) {
                    return false;
                }
                UrlLoaderStartResponseParams response = UrlLoaderStartResponseParams.deserialize(messageWithHeader.getPayload());
                this.mCallback.call(response.response);
                return true;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class UrlLoaderStartResponseParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public UrlResponse response;

        private UrlLoaderStartResponseParams(int version) {
            super(16, version);
        }

        public UrlLoaderStartResponseParams() {
            this(0);
        }

        public static UrlLoaderStartResponseParams deserialize(Message message) {
            return UrlLoaderStartResponseParams.decode(new Decoder(message));
        }

        public static UrlLoaderStartResponseParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UrlLoaderStartResponseParams result = new UrlLoaderStartResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                Decoder decoder1 = decoder0.readPointer(8, false);
                result.response = UrlResponse.decode(decoder1);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.response, 8, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            UrlLoaderStartResponseParams other = (UrlLoaderStartResponseParams)object;
            return BindingsHelper.equals(this.response, other.response);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.response);
            return result;
        }
    }

    static final class UrlLoaderStartParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public UrlRequest request;

        private UrlLoaderStartParams(int version) {
            super(16, version);
        }

        public UrlLoaderStartParams() {
            this(0);
        }

        public static UrlLoaderStartParams deserialize(Message message) {
            return UrlLoaderStartParams.decode(new Decoder(message));
        }

        public static UrlLoaderStartParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            UrlLoaderStartParams result = new UrlLoaderStartParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                Decoder decoder1 = decoder0.readPointer(8, false);
                result.request = UrlRequest.decode(decoder1);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.request, 8, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            UrlLoaderStartParams other = (UrlLoaderStartParams)object;
            return BindingsHelper.equals(this.request, other.request);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.request);
            return result;
        }
    }

    static final class Stub
    extends Interface.Stub<UrlLoader> {
        Stub(Core core, UrlLoader impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(0)) {
                    return false;
                }
                switch (header.getType()) {
                    case -2: {
                        return InterfaceControlMessagesHelper.handleRunOrClosePipe(MANAGER, messageWithHeader);
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(Message message, MessageReceiver receiver) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(1)) {
                    return false;
                }
                switch (header.getType()) {
                    case -1: {
                        return InterfaceControlMessagesHelper.handleRun(this.getCore(), MANAGER, messageWithHeader, receiver);
                    }
                    case 0: {
                        UrlLoaderStartParams data = UrlLoaderStartParams.deserialize(messageWithHeader.getPayload());
                        ((UrlLoader)this.getImpl()).start(data.request, new UrlLoaderStartResponseParamsProxyToResponder(this.getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case 1: {
                        UrlLoaderFollowRedirectParams.deserialize(messageWithHeader.getPayload());
                        ((UrlLoader)this.getImpl()).followRedirect(new UrlLoaderFollowRedirectResponseParamsProxyToResponder(this.getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case 2: {
                        UrlLoaderQueryStatusParams.deserialize(messageWithHeader.getPayload());
                        ((UrlLoader)this.getImpl()).queryStatus(new UrlLoaderQueryStatusResponseParamsProxyToResponder(this.getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class Proxy
    extends Interface.AbstractProxy
    implements UrlLoader.Proxy {
        Proxy(Core core, MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void start(UrlRequest request, UrlLoader.StartResponse callback) {
            UrlLoaderStartParams _message = new UrlLoaderStartParams();
            _message.request = request;
            this.getProxyHandler().getMessageReceiver().acceptWithResponder(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(0, 1, 0L)), new UrlLoaderStartResponseParamsForwardToCallback(callback));
        }

        @Override
        public void followRedirect(UrlLoader.FollowRedirectResponse callback) {
            UrlLoaderFollowRedirectParams _message = new UrlLoaderFollowRedirectParams();
            this.getProxyHandler().getMessageReceiver().acceptWithResponder(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(1, 1, 0L)), new UrlLoaderFollowRedirectResponseParamsForwardToCallback(callback));
        }

        @Override
        public void queryStatus(UrlLoader.QueryStatusResponse callback) {
            UrlLoaderQueryStatusParams _message = new UrlLoaderQueryStatusParams();
            this.getProxyHandler().getMessageReceiver().acceptWithResponder(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(2, 1, 0L)), new UrlLoaderQueryStatusResponseParamsForwardToCallback(callback));
        }
    }
}

