/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojom.mojo;

import java.util.Arrays;
import org.chromium.mojo.bindings.BindingsHelper;
import org.chromium.mojo.bindings.DataHeader;
import org.chromium.mojo.bindings.Decoder;
import org.chromium.mojo.bindings.Encoder;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.Struct;
import org.chromium.mojo.system.DataPipe;
import org.chromium.mojo.system.InvalidHandle;
import org.chromium.mojom.mojo.HttpHeader;
import org.chromium.mojom.mojo.NetworkError;

public final class UrlResponse
extends Struct {
    private static final int STRUCT_SIZE = 96;
    private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(96, 0)};
    private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public NetworkError error;
    public DataPipe.ConsumerHandle body = InvalidHandle.INSTANCE;
    public String url;
    public String site;
    public int statusCode;
    public String statusLine;
    public HttpHeader[] headers;
    public String mimeType;
    public String charset;
    public String redirectMethod;
    public String redirectUrl;
    public String redirectReferrer;

    private UrlResponse(int version) {
        super(96, version);
    }

    public UrlResponse() {
        this(0);
    }

    public static UrlResponse deserialize(Message message) {
        return UrlResponse.decode(new Decoder(message));
    }

    public static UrlResponse decode(Decoder decoder0) {
        Decoder decoder1;
        if (decoder0 == null) {
            return null;
        }
        DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        UrlResponse result = new UrlResponse(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            decoder1 = decoder0.readPointer(8, true);
            result.error = NetworkError.decode(decoder1);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.body = decoder0.readConsumerHandle(16, true);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.statusCode = decoder0.readInt(20);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.url = decoder0.readString(24, true);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.site = decoder0.readString(32, true);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.statusLine = decoder0.readString(40, true);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            decoder1 = decoder0.readPointer(48, true);
            if (decoder1 == null) {
                result.headers = null;
            } else {
                DataHeader si1 = decoder1.readDataHeaderForPointerArray(-1);
                result.headers = new HttpHeader[si1.elementsOrVersion];
                for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                    Decoder decoder2 = decoder1.readPointer(8 + 8 * i1, false);
                    result.headers[i1] = HttpHeader.decode(decoder2);
                }
            }
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.mimeType = decoder0.readString(56, true);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.charset = decoder0.readString(64, true);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.redirectMethod = decoder0.readString(72, true);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.redirectUrl = decoder0.readString(80, true);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.redirectReferrer = decoder0.readString(88, true);
        }
        return result;
    }

    @Override
    protected final void encode(Encoder encoder) {
        Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(this.error, 8, true);
        encoder0.encode(this.body, 16, true);
        encoder0.encode(this.statusCode, 20);
        encoder0.encode(this.url, 24, true);
        encoder0.encode(this.site, 32, true);
        encoder0.encode(this.statusLine, 40, true);
        if (this.headers == null) {
            encoder0.encodeNullPointer(48, true);
        } else {
            Encoder encoder1 = encoder0.encodePointerArray(this.headers.length, 48, -1);
            for (int i0 = 0; i0 < this.headers.length; ++i0) {
                encoder1.encode(this.headers[i0], 8 + 8 * i0, false);
            }
        }
        encoder0.encode(this.mimeType, 56, true);
        encoder0.encode(this.charset, 64, true);
        encoder0.encode(this.redirectMethod, 72, true);
        encoder0.encode(this.redirectUrl, 80, true);
        encoder0.encode(this.redirectReferrer, 88, true);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UrlResponse other = (UrlResponse)object;
        if (!BindingsHelper.equals(this.error, other.error)) {
            return false;
        }
        if (!BindingsHelper.equals(this.body, other.body)) {
            return false;
        }
        if (!BindingsHelper.equals(this.url, other.url)) {
            return false;
        }
        if (!BindingsHelper.equals(this.site, other.site)) {
            return false;
        }
        if (this.statusCode != other.statusCode) {
            return false;
        }
        if (!BindingsHelper.equals(this.statusLine, other.statusLine)) {
            return false;
        }
        if (!Arrays.deepEquals(this.headers, other.headers)) {
            return false;
        }
        if (!BindingsHelper.equals(this.mimeType, other.mimeType)) {
            return false;
        }
        if (!BindingsHelper.equals(this.charset, other.charset)) {
            return false;
        }
        if (!BindingsHelper.equals(this.redirectMethod, other.redirectMethod)) {
            return false;
        }
        if (!BindingsHelper.equals(this.redirectUrl, other.redirectUrl)) {
            return false;
        }
        return BindingsHelper.equals(this.redirectReferrer, other.redirectReferrer);
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.getClass().hashCode();
        result = 31 * result + BindingsHelper.hashCode(this.error);
        result = 31 * result + BindingsHelper.hashCode(this.body);
        result = 31 * result + BindingsHelper.hashCode(this.url);
        result = 31 * result + BindingsHelper.hashCode(this.site);
        result = 31 * result + BindingsHelper.hashCode(this.statusCode);
        result = 31 * result + BindingsHelper.hashCode(this.statusLine);
        result = 31 * result + Arrays.deepHashCode(this.headers);
        result = 31 * result + BindingsHelper.hashCode(this.mimeType);
        result = 31 * result + BindingsHelper.hashCode(this.charset);
        result = 31 * result + BindingsHelper.hashCode(this.redirectMethod);
        result = 31 * result + BindingsHelper.hashCode(this.redirectUrl);
        result = 31 * result + BindingsHelper.hashCode(this.redirectReferrer);
        return result;
    }
}

