/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojom.mojo;

import org.chromium.mojo.bindings.BindingsHelper;
import org.chromium.mojo.bindings.DataHeader;
import org.chromium.mojo.bindings.Decoder;
import org.chromium.mojo.bindings.DeserializationException;
import org.chromium.mojo.bindings.Encoder;
import org.chromium.mojo.bindings.Interface;
import org.chromium.mojo.bindings.InterfaceControlMessagesHelper;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.MessageHeader;
import org.chromium.mojo.bindings.MessageReceiver;
import org.chromium.mojo.bindings.MessageReceiverWithResponder;
import org.chromium.mojo.bindings.ServiceMessage;
import org.chromium.mojo.bindings.Struct;
import org.chromium.mojo.system.Core;
import org.chromium.mojo.system.DataPipe;
import org.chromium.mojo.system.InvalidHandle;
import org.chromium.mojom.mojo.WebSocketClient;

class WebSocketClient_Internal {
    public static final Interface.Manager<WebSocketClient, WebSocketClient.Proxy> MANAGER = new Interface.Manager<WebSocketClient, WebSocketClient.Proxy>(){

        @Override
        public String getName() {
            return "mojo::WebSocketClient";
        }

        @Override
        public int getVersion() {
            return 0;
        }

        @Override
        public Proxy buildProxy(Core core, MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        public Stub buildStub(Core core, WebSocketClient impl) {
            return new Stub(core, impl);
        }

        public WebSocketClient[] buildArray(int size) {
            return new WebSocketClient[size];
        }
    };
    private static final int DID_CONNECT_ORDINAL = 0;
    private static final int DID_RECEIVE_DATA_ORDINAL = 1;
    private static final int DID_RECEIVE_FLOW_CONTROL_ORDINAL = 2;
    private static final int DID_FAIL_ORDINAL = 3;
    private static final int DID_CLOSE_ORDINAL = 4;

    WebSocketClient_Internal() {
    }

    static final class WebSocketClientDidCloseParams
    extends Struct {
        private static final int STRUCT_SIZE = 24;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(24, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean wasClean;
        public short code;
        public String reason;

        private WebSocketClientDidCloseParams(int version) {
            super(24, version);
        }

        public WebSocketClientDidCloseParams() {
            this(0);
        }

        public static WebSocketClientDidCloseParams deserialize(Message message) {
            return WebSocketClientDidCloseParams.decode(new Decoder(message));
        }

        public static WebSocketClientDidCloseParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            WebSocketClientDidCloseParams result = new WebSocketClientDidCloseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.wasClean = decoder0.readBoolean(8, 0);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.code = decoder0.readShort(10);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.reason = decoder0.readString(16, false);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.wasClean, 8, 0);
            encoder0.encode(this.code, 10);
            encoder0.encode(this.reason, 16, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            WebSocketClientDidCloseParams other = (WebSocketClientDidCloseParams)object;
            if (this.wasClean != other.wasClean) {
                return false;
            }
            if (this.code != other.code) {
                return false;
            }
            return BindingsHelper.equals(this.reason, other.reason);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.wasClean);
            result = 31 * result + BindingsHelper.hashCode(this.code);
            result = 31 * result + BindingsHelper.hashCode(this.reason);
            return result;
        }
    }

    static final class WebSocketClientDidFailParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String message;

        private WebSocketClientDidFailParams(int version) {
            super(16, version);
        }

        public WebSocketClientDidFailParams() {
            this(0);
        }

        public static WebSocketClientDidFailParams deserialize(Message message) {
            return WebSocketClientDidFailParams.decode(new Decoder(message));
        }

        public static WebSocketClientDidFailParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            WebSocketClientDidFailParams result = new WebSocketClientDidFailParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.message = decoder0.readString(8, false);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.message, 8, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            WebSocketClientDidFailParams other = (WebSocketClientDidFailParams)object;
            return BindingsHelper.equals(this.message, other.message);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.message);
            return result;
        }
    }

    static final class WebSocketClientDidReceiveFlowControlParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public long quota;

        private WebSocketClientDidReceiveFlowControlParams(int version) {
            super(16, version);
        }

        public WebSocketClientDidReceiveFlowControlParams() {
            this(0);
        }

        public static WebSocketClientDidReceiveFlowControlParams deserialize(Message message) {
            return WebSocketClientDidReceiveFlowControlParams.decode(new Decoder(message));
        }

        public static WebSocketClientDidReceiveFlowControlParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            WebSocketClientDidReceiveFlowControlParams result = new WebSocketClientDidReceiveFlowControlParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.quota = decoder0.readLong(8);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.quota, 8);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            WebSocketClientDidReceiveFlowControlParams other = (WebSocketClientDidReceiveFlowControlParams)object;
            return this.quota == other.quota;
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.quota);
            return result;
        }
    }

    static final class WebSocketClientDidReceiveDataParams
    extends Struct {
        private static final int STRUCT_SIZE = 24;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(24, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean fin;
        public int type;
        public int numBytes;

        private WebSocketClientDidReceiveDataParams(int version) {
            super(24, version);
        }

        public WebSocketClientDidReceiveDataParams() {
            this(0);
        }

        public static WebSocketClientDidReceiveDataParams deserialize(Message message) {
            return WebSocketClientDidReceiveDataParams.decode(new Decoder(message));
        }

        public static WebSocketClientDidReceiveDataParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            WebSocketClientDidReceiveDataParams result = new WebSocketClientDidReceiveDataParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.fin = decoder0.readBoolean(8, 0);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.type = decoder0.readInt(12);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.numBytes = decoder0.readInt(16);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.fin, 8, 0);
            encoder0.encode(this.type, 12);
            encoder0.encode(this.numBytes, 16);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            WebSocketClientDidReceiveDataParams other = (WebSocketClientDidReceiveDataParams)object;
            if (this.fin != other.fin) {
                return false;
            }
            if (this.type != other.type) {
                return false;
            }
            return this.numBytes == other.numBytes;
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.fin);
            result = 31 * result + BindingsHelper.hashCode(this.type);
            result = 31 * result + BindingsHelper.hashCode(this.numBytes);
            return result;
        }
    }

    static final class WebSocketClientDidConnectParams
    extends Struct {
        private static final int STRUCT_SIZE = 32;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(32, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String selectedSubprotocol;
        public String extensions;
        public DataPipe.ConsumerHandle receiveStream = InvalidHandle.INSTANCE;

        private WebSocketClientDidConnectParams(int version) {
            super(32, version);
        }

        public WebSocketClientDidConnectParams() {
            this(0);
        }

        public static WebSocketClientDidConnectParams deserialize(Message message) {
            return WebSocketClientDidConnectParams.decode(new Decoder(message));
        }

        public static WebSocketClientDidConnectParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            WebSocketClientDidConnectParams result = new WebSocketClientDidConnectParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.selectedSubprotocol = decoder0.readString(8, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.extensions = decoder0.readString(16, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.receiveStream = decoder0.readConsumerHandle(24, false);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.selectedSubprotocol, 8, false);
            encoder0.encode(this.extensions, 16, false);
            encoder0.encode(this.receiveStream, 24, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            WebSocketClientDidConnectParams other = (WebSocketClientDidConnectParams)object;
            if (!BindingsHelper.equals(this.selectedSubprotocol, other.selectedSubprotocol)) {
                return false;
            }
            if (!BindingsHelper.equals(this.extensions, other.extensions)) {
                return false;
            }
            return BindingsHelper.equals(this.receiveStream, other.receiveStream);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.selectedSubprotocol);
            result = 31 * result + BindingsHelper.hashCode(this.extensions);
            result = 31 * result + BindingsHelper.hashCode(this.receiveStream);
            return result;
        }
    }

    static final class Stub
    extends Interface.Stub<WebSocketClient> {
        Stub(Core core, WebSocketClient impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(0)) {
                    return false;
                }
                switch (header.getType()) {
                    case -2: {
                        return InterfaceControlMessagesHelper.handleRunOrClosePipe(MANAGER, messageWithHeader);
                    }
                    case 0: {
                        WebSocketClientDidConnectParams data = WebSocketClientDidConnectParams.deserialize(messageWithHeader.getPayload());
                        ((WebSocketClient)this.getImpl()).didConnect(data.selectedSubprotocol, data.extensions, data.receiveStream);
                        return true;
                    }
                    case 1: {
                        WebSocketClientDidReceiveDataParams data = WebSocketClientDidReceiveDataParams.deserialize(messageWithHeader.getPayload());
                        ((WebSocketClient)this.getImpl()).didReceiveData(data.fin, data.type, data.numBytes);
                        return true;
                    }
                    case 2: {
                        WebSocketClientDidReceiveFlowControlParams data = WebSocketClientDidReceiveFlowControlParams.deserialize(messageWithHeader.getPayload());
                        ((WebSocketClient)this.getImpl()).didReceiveFlowControl(data.quota);
                        return true;
                    }
                    case 3: {
                        WebSocketClientDidFailParams data = WebSocketClientDidFailParams.deserialize(messageWithHeader.getPayload());
                        ((WebSocketClient)this.getImpl()).didFail(data.message);
                        return true;
                    }
                    case 4: {
                        WebSocketClientDidCloseParams data = WebSocketClientDidCloseParams.deserialize(messageWithHeader.getPayload());
                        ((WebSocketClient)this.getImpl()).didClose(data.wasClean, data.code, data.reason);
                        return true;
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(Message message, MessageReceiver receiver) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(1)) {
                    return false;
                }
                switch (header.getType()) {
                    case -1: {
                        return InterfaceControlMessagesHelper.handleRun(this.getCore(), MANAGER, messageWithHeader, receiver);
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class Proxy
    extends Interface.AbstractProxy
    implements WebSocketClient.Proxy {
        Proxy(Core core, MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void didConnect(String selectedSubprotocol, String extensions, DataPipe.ConsumerHandle receiveStream) {
            WebSocketClientDidConnectParams _message = new WebSocketClientDidConnectParams();
            _message.selectedSubprotocol = selectedSubprotocol;
            _message.extensions = extensions;
            _message.receiveStream = receiveStream;
            this.getProxyHandler().getMessageReceiver().accept(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(0)));
        }

        @Override
        public void didReceiveData(boolean fin, int type, int numBytes) {
            WebSocketClientDidReceiveDataParams _message = new WebSocketClientDidReceiveDataParams();
            _message.fin = fin;
            _message.type = type;
            _message.numBytes = numBytes;
            this.getProxyHandler().getMessageReceiver().accept(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(1)));
        }

        @Override
        public void didReceiveFlowControl(long quota) {
            WebSocketClientDidReceiveFlowControlParams _message = new WebSocketClientDidReceiveFlowControlParams();
            _message.quota = quota;
            this.getProxyHandler().getMessageReceiver().accept(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(2)));
        }

        @Override
        public void didFail(String message) {
            WebSocketClientDidFailParams _message = new WebSocketClientDidFailParams();
            _message.message = message;
            this.getProxyHandler().getMessageReceiver().accept(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(3)));
        }

        @Override
        public void didClose(boolean wasClean, short code, String reason) {
            WebSocketClientDidCloseParams _message = new WebSocketClientDidCloseParams();
            _message.wasClean = wasClean;
            _message.code = code;
            _message.reason = reason;
            this.getProxyHandler().getMessageReceiver().accept(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(4)));
        }
    }
}

