/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojom.mojo;

import java.util.Arrays;
import org.chromium.mojo.bindings.BindingsHelper;
import org.chromium.mojo.bindings.DataHeader;
import org.chromium.mojo.bindings.Decoder;
import org.chromium.mojo.bindings.DeserializationException;
import org.chromium.mojo.bindings.Encoder;
import org.chromium.mojo.bindings.Interface;
import org.chromium.mojo.bindings.InterfaceControlMessagesHelper;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.MessageHeader;
import org.chromium.mojo.bindings.MessageReceiver;
import org.chromium.mojo.bindings.MessageReceiverWithResponder;
import org.chromium.mojo.bindings.ServiceMessage;
import org.chromium.mojo.bindings.Struct;
import org.chromium.mojo.system.Core;
import org.chromium.mojo.system.DataPipe;
import org.chromium.mojo.system.InvalidHandle;
import org.chromium.mojom.mojo.WebSocket;
import org.chromium.mojom.mojo.WebSocketClient;

class WebSocket_Internal {
    public static final Interface.Manager<WebSocket, WebSocket.Proxy> MANAGER = new Interface.Manager<WebSocket, WebSocket.Proxy>(){

        @Override
        public String getName() {
            return "mojo::WebSocket";
        }

        @Override
        public int getVersion() {
            return 0;
        }

        @Override
        public Proxy buildProxy(Core core, MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        public Stub buildStub(Core core, WebSocket impl) {
            return new Stub(core, impl);
        }

        public WebSocket[] buildArray(int size) {
            return new WebSocket[size];
        }
    };
    private static final int CONNECT_ORDINAL = 0;
    private static final int SEND_ORDINAL = 1;
    private static final int FLOW_CONTROL_ORDINAL = 2;
    private static final int CLOSE_ORDINAL = 3;

    WebSocket_Internal() {
    }

    static final class WebSocketCloseParams
    extends Struct {
        private static final int STRUCT_SIZE = 24;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(24, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public short code;
        public String reason;

        private WebSocketCloseParams(int version) {
            super(24, version);
        }

        public WebSocketCloseParams() {
            this(0);
        }

        public static WebSocketCloseParams deserialize(Message message) {
            return WebSocketCloseParams.decode(new Decoder(message));
        }

        public static WebSocketCloseParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            WebSocketCloseParams result = new WebSocketCloseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.code = decoder0.readShort(8);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.reason = decoder0.readString(16, false);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.code, 8);
            encoder0.encode(this.reason, 16, false);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            WebSocketCloseParams other = (WebSocketCloseParams)object;
            if (this.code != other.code) {
                return false;
            }
            return BindingsHelper.equals(this.reason, other.reason);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.code);
            result = 31 * result + BindingsHelper.hashCode(this.reason);
            return result;
        }
    }

    static final class WebSocketFlowControlParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public long quota;

        private WebSocketFlowControlParams(int version) {
            super(16, version);
        }

        public WebSocketFlowControlParams() {
            this(0);
        }

        public static WebSocketFlowControlParams deserialize(Message message) {
            return WebSocketFlowControlParams.decode(new Decoder(message));
        }

        public static WebSocketFlowControlParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            WebSocketFlowControlParams result = new WebSocketFlowControlParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.quota = decoder0.readLong(8);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.quota, 8);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            WebSocketFlowControlParams other = (WebSocketFlowControlParams)object;
            return this.quota == other.quota;
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.quota);
            return result;
        }
    }

    static final class WebSocketSendParams
    extends Struct {
        private static final int STRUCT_SIZE = 24;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(24, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean fin;
        public int type;
        public int numBytes;

        private WebSocketSendParams(int version) {
            super(24, version);
        }

        public WebSocketSendParams() {
            this(0);
        }

        public static WebSocketSendParams deserialize(Message message) {
            return WebSocketSendParams.decode(new Decoder(message));
        }

        public static WebSocketSendParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            WebSocketSendParams result = new WebSocketSendParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.fin = decoder0.readBoolean(8, 0);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.type = decoder0.readInt(12);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.numBytes = decoder0.readInt(16);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.fin, 8, 0);
            encoder0.encode(this.type, 12);
            encoder0.encode(this.numBytes, 16);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            WebSocketSendParams other = (WebSocketSendParams)object;
            if (this.fin != other.fin) {
                return false;
            }
            if (this.type != other.type) {
                return false;
            }
            return this.numBytes == other.numBytes;
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.fin);
            result = 31 * result + BindingsHelper.hashCode(this.type);
            result = 31 * result + BindingsHelper.hashCode(this.numBytes);
            return result;
        }
    }

    static final class WebSocketConnectParams
    extends Struct {
        private static final int STRUCT_SIZE = 48;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(48, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String url;
        public String[] protocols;
        public String origin;
        public DataPipe.ConsumerHandle sendStream = InvalidHandle.INSTANCE;
        public WebSocketClient client;

        private WebSocketConnectParams(int version) {
            super(48, version);
        }

        public WebSocketConnectParams() {
            this(0);
        }

        public static WebSocketConnectParams deserialize(Message message) {
            return WebSocketConnectParams.decode(new Decoder(message));
        }

        public static WebSocketConnectParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            WebSocketConnectParams result = new WebSocketConnectParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.url = decoder0.readString(8, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                Decoder decoder1 = decoder0.readPointer(16, false);
                DataHeader si1 = decoder1.readDataHeaderForPointerArray(-1);
                result.protocols = new String[si1.elementsOrVersion];
                for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                    result.protocols[i1] = decoder1.readString(8 + 8 * i1, false);
                }
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.origin = decoder0.readString(24, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.sendStream = decoder0.readConsumerHandle(32, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.client = decoder0.readServiceInterface(36, false, WebSocketClient.MANAGER);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.url, 8, false);
            if (this.protocols == null) {
                encoder0.encodeNullPointer(16, false);
            } else {
                Encoder encoder1 = encoder0.encodePointerArray(this.protocols.length, 16, -1);
                for (int i0 = 0; i0 < this.protocols.length; ++i0) {
                    encoder1.encode(this.protocols[i0], 8 + 8 * i0, false);
                }
            }
            encoder0.encode(this.origin, 24, false);
            encoder0.encode(this.sendStream, 32, false);
            encoder0.encode(this.client, 36, false, WebSocketClient.MANAGER);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            WebSocketConnectParams other = (WebSocketConnectParams)object;
            if (!BindingsHelper.equals(this.url, other.url)) {
                return false;
            }
            if (!Arrays.deepEquals(this.protocols, other.protocols)) {
                return false;
            }
            if (!BindingsHelper.equals(this.origin, other.origin)) {
                return false;
            }
            if (!BindingsHelper.equals(this.sendStream, other.sendStream)) {
                return false;
            }
            return BindingsHelper.equals(this.client, other.client);
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.url);
            result = 31 * result + Arrays.deepHashCode(this.protocols);
            result = 31 * result + BindingsHelper.hashCode(this.origin);
            result = 31 * result + BindingsHelper.hashCode(this.sendStream);
            result = 31 * result + BindingsHelper.hashCode(this.client);
            return result;
        }
    }

    static final class Stub
    extends Interface.Stub<WebSocket> {
        Stub(Core core, WebSocket impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(0)) {
                    return false;
                }
                switch (header.getType()) {
                    case -2: {
                        return InterfaceControlMessagesHelper.handleRunOrClosePipe(MANAGER, messageWithHeader);
                    }
                    case 0: {
                        WebSocketConnectParams data = WebSocketConnectParams.deserialize(messageWithHeader.getPayload());
                        ((WebSocket)this.getImpl()).connect(data.url, data.protocols, data.origin, data.sendStream, data.client);
                        return true;
                    }
                    case 1: {
                        WebSocketSendParams data = WebSocketSendParams.deserialize(messageWithHeader.getPayload());
                        ((WebSocket)this.getImpl()).send(data.fin, data.type, data.numBytes);
                        return true;
                    }
                    case 2: {
                        WebSocketFlowControlParams data = WebSocketFlowControlParams.deserialize(messageWithHeader.getPayload());
                        ((WebSocket)this.getImpl()).flowControl(data.quota);
                        return true;
                    }
                    case 3: {
                        WebSocketCloseParams data = WebSocketCloseParams.deserialize(messageWithHeader.getPayload());
                        ((WebSocket)this.getImpl()).close(data.code, data.reason);
                        return true;
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(Message message, MessageReceiver receiver) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(1)) {
                    return false;
                }
                switch (header.getType()) {
                    case -1: {
                        return InterfaceControlMessagesHelper.handleRun(this.getCore(), MANAGER, messageWithHeader, receiver);
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class Proxy
    extends Interface.AbstractProxy
    implements WebSocket.Proxy {
        Proxy(Core core, MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void connect(String url, String[] protocols, String origin, DataPipe.ConsumerHandle sendStream, WebSocketClient client) {
            WebSocketConnectParams _message = new WebSocketConnectParams();
            _message.url = url;
            _message.protocols = protocols;
            _message.origin = origin;
            _message.sendStream = sendStream;
            _message.client = client;
            this.getProxyHandler().getMessageReceiver().accept(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(0)));
        }

        @Override
        public void send(boolean fin, int type, int numBytes) {
            WebSocketSendParams _message = new WebSocketSendParams();
            _message.fin = fin;
            _message.type = type;
            _message.numBytes = numBytes;
            this.getProxyHandler().getMessageReceiver().accept(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(1)));
        }

        @Override
        public void flowControl(long quota) {
            WebSocketFlowControlParams _message = new WebSocketFlowControlParams();
            _message.quota = quota;
            this.getProxyHandler().getMessageReceiver().accept(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(2)));
        }

        @Override
        public void close(short code, String reason) {
            WebSocketCloseParams _message = new WebSocketCloseParams();
            _message.code = code;
            _message.reason = reason;
            this.getProxyHandler().getMessageReceiver().accept(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(3)));
        }
    }
}

