/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import android.util.Log;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.ECParameterSpec;
import org.chromium.net.AndroidKeyStore;
import org.chromium.net.AndroidPrivateKey;

public class DefaultAndroidKeyStore
implements AndroidKeyStore {
    private static final String TAG = "AndroidKeyStoreInProcessImpl";

    public AndroidPrivateKey createKey(PrivateKey javaKey) {
        return new DefaultAndroidPrivateKey(javaKey, this);
    }

    @Override
    public byte[] getRSAKeyModulus(AndroidPrivateKey key) {
        PrivateKey javaKey = ((DefaultAndroidPrivateKey)key).getJavaKey();
        if (javaKey instanceof RSAKey) {
            return ((RSAKey)((Object)javaKey)).getModulus().toByteArray();
        }
        Log.w((String)TAG, (String)"Not a RSAKey instance!");
        return null;
    }

    @Override
    public byte[] getECKeyOrder(AndroidPrivateKey key) {
        PrivateKey javaKey = ((DefaultAndroidPrivateKey)key).getJavaKey();
        if (javaKey instanceof ECKey) {
            ECParameterSpec params = ((ECKey)((Object)javaKey)).getParams();
            return params.getOrder().toByteArray();
        }
        Log.w((String)TAG, (String)"Not an ECKey instance!");
        return null;
    }

    @Override
    public byte[] rawSignDigestWithPrivateKey(AndroidPrivateKey key, byte[] message) {
        PrivateKey javaKey = ((DefaultAndroidPrivateKey)key).getJavaKey();
        Signature signature = null;
        try {
            String keyAlgorithm = javaKey.getAlgorithm();
            if ("RSA".equalsIgnoreCase(keyAlgorithm)) {
                signature = Signature.getInstance("NONEwithRSA");
            } else if ("EC".equalsIgnoreCase(keyAlgorithm)) {
                signature = Signature.getInstance("NONEwithECDSA");
            }
        }
        catch (NoSuchAlgorithmException keyAlgorithm) {
            // empty catch block
        }
        if (signature == null) {
            Log.e((String)TAG, (String)("Unsupported private key algorithm: " + javaKey.getAlgorithm()));
            return null;
        }
        try {
            signature.initSign(javaKey);
            signature.update(message);
            return signature.sign();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception while signing message with " + javaKey.getAlgorithm() + " private key: " + e));
            return null;
        }
    }

    @Override
    public int getPrivateKeyType(AndroidPrivateKey key) {
        PrivateKey javaKey = ((DefaultAndroidPrivateKey)key).getJavaKey();
        String keyAlgorithm = javaKey.getAlgorithm();
        if ("RSA".equalsIgnoreCase(keyAlgorithm)) {
            return 0;
        }
        if ("EC".equalsIgnoreCase(keyAlgorithm)) {
            return 2;
        }
        return 255;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getOpenSSLKeyForPrivateKey(AndroidPrivateKey key) {
        Class<?> superClass;
        PrivateKey javaKey = ((DefaultAndroidPrivateKey)key).getJavaKey();
        if (javaKey == null) {
            Log.e((String)TAG, (String)"key == null");
            return null;
        }
        if (!(javaKey instanceof RSAPrivateKey)) {
            Log.e((String)TAG, (String)"does not implement RSAPrivateKey");
            return null;
        }
        try {
            superClass = Class.forName("org.apache.harmony.xnet.provider.jsse.OpenSSLRSAPrivateKey");
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Cannot find system OpenSSLRSAPrivateKey class: " + e));
            return null;
        }
        if (!superClass.isInstance(javaKey)) {
            Log.e((String)TAG, (String)("Private key is not an OpenSSLRSAPrivateKey instance, its class name is:" + javaKey.getClass().getCanonicalName()));
            return null;
        }
        try {
            Method getKey = superClass.getDeclaredMethod("getOpenSSLKey", new Class[0]);
            getKey.setAccessible(true);
            Object opensslKey = null;
            try {
                opensslKey = getKey.invoke((Object)javaKey, new Object[0]);
            }
            finally {
                getKey.setAccessible(false);
            }
            if (opensslKey == null) {
                Log.e((String)TAG, (String)"getOpenSSLKey() returned null");
                return null;
            }
            return opensslKey;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception while trying to retrieve system EVP_PKEY handle: " + e));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getOpenSSLHandleForPrivateKey(AndroidPrivateKey key) {
        Object opensslKey = this.getOpenSSLKeyForPrivateKey(key);
        if (opensslKey == null) {
            return 0L;
        }
        try {
            Method getPkeyContext;
            try {
                getPkeyContext = opensslKey.getClass().getDeclaredMethod("getPkeyContext", new Class[0]);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("No getPkeyContext() method on OpenSSLKey member:" + e));
                return 0L;
            }
            getPkeyContext.setAccessible(true);
            long evp_pkey = 0L;
            try {
                evp_pkey = ((Number)getPkeyContext.invoke(opensslKey, new Object[0])).longValue();
            }
            finally {
                getPkeyContext.setAccessible(false);
            }
            if (evp_pkey == 0L) {
                Log.e((String)TAG, (String)"getPkeyContext() returned null");
            }
            return evp_pkey;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception while trying to retrieve system EVP_PKEY handle: " + e));
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getOpenSSLEngineForPrivateKey(AndroidPrivateKey key) {
        Class<?> engineClass;
        try {
            engineClass = Class.forName("org.apache.harmony.xnet.provider.jsse.OpenSSLEngine");
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Cannot find system OpenSSLEngine class: " + e));
            return null;
        }
        Object opensslKey = this.getOpenSSLKeyForPrivateKey(key);
        if (opensslKey == null) {
            return null;
        }
        try {
            Method getEngine;
            try {
                getEngine = opensslKey.getClass().getDeclaredMethod("getEngine", new Class[0]);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("No getEngine() method on OpenSSLKey member:" + e));
                return null;
            }
            getEngine.setAccessible(true);
            Object engine = null;
            try {
                engine = getEngine.invoke(opensslKey, new Object[0]);
            }
            finally {
                getEngine.setAccessible(false);
            }
            if (engine == null) {
                Log.e((String)TAG, (String)"getEngine() returned null");
            }
            if (!engineClass.isInstance(engine)) {
                Log.e((String)TAG, (String)("Engine is not an OpenSSLEngine instance, its class name is:" + engine.getClass().getCanonicalName()));
                return null;
            }
            return engine;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception while trying to retrieve OpenSSLEngine object: " + e));
            return null;
        }
    }

    @Override
    public void releaseKey(AndroidPrivateKey key) {
    }

    private static class DefaultAndroidPrivateKey
    implements AndroidPrivateKey {
        final PrivateKey mKey;
        final DefaultAndroidKeyStore mStore;

        DefaultAndroidPrivateKey(PrivateKey key, DefaultAndroidKeyStore store) {
            this.mKey = key;
            this.mStore = store;
        }

        PrivateKey getJavaKey() {
            return this.mKey;
        }

        @Override
        public AndroidKeyStore getKeyStore() {
            return this.mStore;
        }
    }
}

