/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import android.accounts.AccountManager;
import android.accounts.AccountManagerCallback;
import android.accounts.AccountManagerFuture;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import java.io.IOException;
import org.chromium.base.ApplicationStatus;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.ThreadUtils;
import org.chromium.base.VisibleForTesting;

@JNINamespace(value="net::android")
public class HttpNegotiateAuthenticator {
    private Bundle mSpnegoContext = null;
    private final String mAccountType;
    private AccountManagerFuture<Bundle> mFuture;

    private HttpNegotiateAuthenticator(String accountType) {
        assert (!TextUtils.isEmpty((CharSequence)accountType));
        this.mAccountType = accountType;
    }

    @VisibleForTesting
    @CalledByNative
    static HttpNegotiateAuthenticator create(String accountType) {
        return new HttpNegotiateAuthenticator(accountType);
    }

    @VisibleForTesting
    @CalledByNative
    void getNextAuthToken(final long nativeResultObject, String principal, String authToken, boolean canDelegate) {
        assert (principal != null);
        String authTokenType = "SPNEGO:HOSTBASED:" + principal;
        Activity activity = ApplicationStatus.getLastTrackedFocusedActivity();
        if (activity == null) {
            this.nativeSetResult(nativeResultObject, -9, null);
            return;
        }
        AccountManager am = AccountManager.get((Context)activity);
        String[] features = new String[]{"SPNEGO"};
        Bundle options = new Bundle();
        if (authToken != null) {
            options.putString("incomingAuthToken", authToken);
        }
        if (this.mSpnegoContext != null) {
            options.putBundle("spnegoContext", this.mSpnegoContext);
        }
        options.putBoolean("canDelegate", canDelegate);
        this.mFuture = am.getAuthTokenByFeatures(this.mAccountType, authTokenType, features, activity, null, options, (AccountManagerCallback)new AccountManagerCallback<Bundle>(){

            public void run(AccountManagerFuture<Bundle> future) {
                try {
                    int status;
                    Bundle result = (Bundle)future.getResult();
                    HttpNegotiateAuthenticator.this.mSpnegoContext = result.getBundle("spnegoContext");
                    switch (result.getInt("spnegoResult", 1)) {
                        case 0: {
                            status = 0;
                            break;
                        }
                        case 1: {
                            status = -9;
                            break;
                        }
                        case 2: {
                            status = -3;
                            break;
                        }
                        case 3: {
                            status = -342;
                            break;
                        }
                        case 4: {
                            status = -320;
                            break;
                        }
                        case 5: {
                            status = -338;
                            break;
                        }
                        case 6: {
                            status = -339;
                            break;
                        }
                        case 7: {
                            status = -341;
                            break;
                        }
                        case 8: {
                            status = -344;
                            break;
                        }
                        case 9: {
                            status = -329;
                            break;
                        }
                        default: {
                            status = -9;
                        }
                    }
                    HttpNegotiateAuthenticator.this.nativeSetResult(nativeResultObject, status, result.getString("authtoken"));
                }
                catch (AuthenticatorException | OperationCanceledException | IOException e) {
                    HttpNegotiateAuthenticator.this.nativeSetResult(nativeResultObject, -3, null);
                }
            }
        }, new Handler(ThreadUtils.getUiThreadLooper()));
    }

    @VisibleForTesting
    native void nativeSetResult(long var1, int var3, String var4);
}

