/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import android.content.Context;
import java.util.ArrayList;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.NativeClassQualifiedName;
import org.chromium.base.ObserverList;
import org.chromium.net.NetworkChangeNotifierAutoDetect;

@JNINamespace(value="net")
public class NetworkChangeNotifier {
    private final Context mContext;
    private final ArrayList<Long> mNativeChangeNotifiers;
    private final ObserverList<ConnectionTypeObserver> mConnectionTypeObservers;
    private NetworkChangeNotifierAutoDetect mAutoDetector;
    private int mCurrentConnectionType = 0;
    private double mCurrentMaxBandwidth = Double.POSITIVE_INFINITY;
    private static NetworkChangeNotifier sInstance;

    private NetworkChangeNotifier(Context context) {
        this.mContext = context.getApplicationContext();
        this.mNativeChangeNotifiers = new ArrayList();
        this.mConnectionTypeObservers = new ObserverList();
    }

    @CalledByNative
    public static NetworkChangeNotifier init(Context context) {
        if (sInstance == null) {
            sInstance = new NetworkChangeNotifier(context);
        }
        return sInstance;
    }

    public static boolean isInitialized() {
        return sInstance != null;
    }

    static void resetInstanceForTests(Context context) {
        sInstance = new NetworkChangeNotifier(context);
    }

    @CalledByNative
    public int getCurrentConnectionType() {
        return this.mCurrentConnectionType;
    }

    @CalledByNative
    public double getCurrentMaxBandwidthInMbps() {
        return this.mCurrentMaxBandwidth;
    }

    public static double getMaxBandwidthForConnectionSubtype(int subtype) {
        return NetworkChangeNotifier.nativeGetMaxBandwidthForConnectionSubtype(subtype);
    }

    @CalledByNative
    public void addNativeObserver(long nativeChangeNotifier) {
        this.mNativeChangeNotifiers.add(nativeChangeNotifier);
    }

    @CalledByNative
    public void removeNativeObserver(long nativeChangeNotifier) {
        this.mNativeChangeNotifiers.remove(nativeChangeNotifier);
    }

    public static NetworkChangeNotifier getInstance() {
        assert (sInstance != null);
        return sInstance;
    }

    public static void setAutoDetectConnectivityState(boolean shouldAutoDetect) {
        NetworkChangeNotifier.getInstance().setAutoDetectConnectivityStateInternal(shouldAutoDetect, false);
    }

    private void destroyAutoDetector() {
        if (this.mAutoDetector != null) {
            this.mAutoDetector.destroy();
            this.mAutoDetector = null;
        }
    }

    public static void registerToReceiveNotificationsAlways() {
        NetworkChangeNotifier.getInstance().setAutoDetectConnectivityStateInternal(true, true);
    }

    private void setAutoDetectConnectivityStateInternal(boolean shouldAutoDetect, boolean alwaysWatchForChanges) {
        if (shouldAutoDetect) {
            if (this.mAutoDetector == null) {
                this.mAutoDetector = new NetworkChangeNotifierAutoDetect(new NetworkChangeNotifierAutoDetect.Observer(){

                    @Override
                    public void onConnectionTypeChanged(int newConnectionType) {
                        NetworkChangeNotifier.this.updateCurrentConnectionType(newConnectionType);
                    }

                    @Override
                    public void onMaxBandwidthChanged(double maxBandwidthMbps) {
                        NetworkChangeNotifier.this.updateCurrentMaxBandwidth(maxBandwidthMbps);
                    }
                }, this.mContext, alwaysWatchForChanges);
                NetworkChangeNotifierAutoDetect.NetworkState networkState = this.mAutoDetector.getCurrentNetworkState();
                this.updateCurrentConnectionType(this.mAutoDetector.getCurrentConnectionType(networkState));
                this.updateCurrentMaxBandwidth(this.mAutoDetector.getCurrentMaxBandwidthInMbps(networkState));
            }
        } else {
            this.destroyAutoDetector();
        }
    }

    @CalledByNative
    public static void forceConnectivityState(boolean networkAvailable) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().forceConnectivityStateInternal(networkAvailable);
    }

    private void forceConnectivityStateInternal(boolean forceOnline) {
        boolean connectionCurrentlyExists;
        boolean bl = connectionCurrentlyExists = this.mCurrentConnectionType != 6;
        if (connectionCurrentlyExists != forceOnline) {
            this.updateCurrentConnectionType(forceOnline ? 0 : 6);
            this.updateCurrentMaxBandwidth(forceOnline ? Double.POSITIVE_INFINITY : 0.0);
        }
    }

    private void updateCurrentConnectionType(int newConnectionType) {
        this.mCurrentConnectionType = newConnectionType;
        this.notifyObserversOfConnectionTypeChange(newConnectionType);
    }

    private void updateCurrentMaxBandwidth(double maxBandwidthMbps) {
        if (maxBandwidthMbps == this.mCurrentMaxBandwidth) {
            return;
        }
        this.mCurrentMaxBandwidth = maxBandwidthMbps;
        this.notifyObserversOfMaxBandwidthChange(maxBandwidthMbps);
    }

    void notifyObserversOfConnectionTypeChange(int newConnectionType) {
        for (Long nativeChangeNotifier : this.mNativeChangeNotifiers) {
            this.nativeNotifyConnectionTypeChanged(nativeChangeNotifier, newConnectionType);
        }
        for (ConnectionTypeObserver observer : this.mConnectionTypeObservers) {
            observer.onConnectionTypeChanged(newConnectionType);
        }
    }

    void notifyObserversOfMaxBandwidthChange(double maxBandwidthMbps) {
        for (Long nativeChangeNotifier : this.mNativeChangeNotifiers) {
            this.nativeNotifyMaxBandwidthChanged(nativeChangeNotifier, maxBandwidthMbps);
        }
    }

    public static void addConnectionTypeObserver(ConnectionTypeObserver observer) {
        NetworkChangeNotifier.getInstance().addConnectionTypeObserverInternal(observer);
    }

    private void addConnectionTypeObserverInternal(ConnectionTypeObserver observer) {
        this.mConnectionTypeObservers.addObserver(observer);
    }

    public static void removeConnectionTypeObserver(ConnectionTypeObserver observer) {
        NetworkChangeNotifier.getInstance().removeConnectionTypeObserverInternal(observer);
    }

    private void removeConnectionTypeObserverInternal(ConnectionTypeObserver observer) {
        this.mConnectionTypeObservers.removeObserver(observer);
    }

    @NativeClassQualifiedName(value="NetworkChangeNotifierDelegateAndroid")
    private native void nativeNotifyConnectionTypeChanged(long var1, int var3);

    @NativeClassQualifiedName(value="NetworkChangeNotifierDelegateAndroid")
    private native void nativeNotifyMaxBandwidthChanged(long var1, double var3);

    private static native double nativeGetMaxBandwidthForConnectionSubtype(int var0);

    public static NetworkChangeNotifierAutoDetect getAutoDetectorForTest() {
        return NetworkChangeNotifier.getInstance().mAutoDetector;
    }

    public static boolean isOnline() {
        int connectionType = NetworkChangeNotifier.getInstance().getCurrentConnectionType();
        return connectionType != 0 && connectionType != 6;
    }

    public static interface ConnectionTypeObserver {
        public void onConnectionTypeChanged(int var1);
    }
}

