/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.util.Log;
import org.chromium.base.ApplicationStatus;
import org.chromium.base.VisibleForTesting;
import org.chromium.net.NetworkChangeNotifier;

public class NetworkChangeNotifierAutoDetect
extends BroadcastReceiver
implements ApplicationStatus.ApplicationStateListener {
    private static final String TAG = "NetworkChangeNotifierAutoDetect";
    private static final int UNKNOWN_LINK_SPEED = -1;
    private final NetworkConnectivityIntentFilter mIntentFilter;
    private final Observer mObserver;
    private final Context mContext;
    private ConnectivityManagerDelegate mConnectivityManagerDelegate;
    private WifiManagerDelegate mWifiManagerDelegate;
    private boolean mRegistered;
    private int mConnectionType;
    private String mWifiSSID;
    private double mMaxBandwidthMbps;

    public NetworkChangeNotifierAutoDetect(Observer observer, Context context, boolean alwaysWatchForChanges) {
        this.mObserver = observer;
        this.mContext = context.getApplicationContext();
        this.mConnectivityManagerDelegate = new ConnectivityManagerDelegate(context);
        this.mWifiManagerDelegate = new WifiManagerDelegate(context);
        NetworkState networkState = this.mConnectivityManagerDelegate.getNetworkState();
        this.mConnectionType = this.getCurrentConnectionType(networkState);
        this.mWifiSSID = this.getCurrentWifiSSID(networkState);
        this.mMaxBandwidthMbps = this.getCurrentMaxBandwidthInMbps(networkState);
        this.mIntentFilter = new NetworkConnectivityIntentFilter(this.mWifiManagerDelegate.getHasWifiPermission());
        if (alwaysWatchForChanges) {
            this.registerReceiver();
        } else {
            ApplicationStatus.registerApplicationStateListener(this);
            this.onApplicationStateChange(this.getApplicationState());
        }
    }

    void setConnectivityManagerDelegateForTests(ConnectivityManagerDelegate delegate) {
        this.mConnectivityManagerDelegate = delegate;
    }

    void setWifiManagerDelegateForTests(WifiManagerDelegate delegate) {
        this.mWifiManagerDelegate = delegate;
    }

    @VisibleForTesting
    int getApplicationState() {
        return ApplicationStatus.getStateForApplication();
    }

    @VisibleForTesting
    boolean isReceiverRegisteredForTesting() {
        return this.mRegistered;
    }

    public void destroy() {
        this.unregisterReceiver();
    }

    private void registerReceiver() {
        if (!this.mRegistered) {
            this.mRegistered = true;
            this.mContext.registerReceiver((BroadcastReceiver)this, (IntentFilter)this.mIntentFilter);
        }
    }

    private void unregisterReceiver() {
        if (this.mRegistered) {
            this.mRegistered = false;
            this.mContext.unregisterReceiver((BroadcastReceiver)this);
        }
    }

    public NetworkState getCurrentNetworkState() {
        return this.mConnectivityManagerDelegate.getNetworkState();
    }

    public int getCurrentConnectionType(NetworkState networkState) {
        if (!networkState.isConnected()) {
            return 6;
        }
        switch (networkState.getNetworkType()) {
            case 9: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 7;
            }
            case 0: {
                switch (networkState.getNetworkSubType()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        return 3;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        return 4;
                    }
                    case 13: {
                        return 5;
                    }
                }
                return 0;
            }
        }
        return 0;
    }

    public double getCurrentMaxBandwidthInMbps(NetworkState networkState) {
        int link_speed;
        if (this.getCurrentConnectionType(networkState) == 2 && (link_speed = this.mWifiManagerDelegate.getLinkSpeedInMbps()) != -1) {
            return link_speed;
        }
        return NetworkChangeNotifier.getMaxBandwidthForConnectionSubtype(this.getCurrentConnectionSubtype(networkState));
    }

    private int getCurrentConnectionSubtype(NetworkState networkState) {
        if (!networkState.isConnected()) {
            return 31;
        }
        switch (networkState.getNetworkType()) {
            case 1: 
            case 6: 
            case 7: 
            case 9: {
                return 30;
            }
            case 0: {
                switch (networkState.getNetworkSubType()) {
                    case 1: {
                        return 4;
                    }
                    case 2: {
                        return 5;
                    }
                    case 4: {
                        return 2;
                    }
                    case 7: {
                        return 3;
                    }
                    case 11: {
                        return 1;
                    }
                    case 3: {
                        return 6;
                    }
                    case 5: {
                        return 7;
                    }
                    case 6: {
                        return 8;
                    }
                    case 8: {
                        return 11;
                    }
                    case 9: {
                        return 12;
                    }
                    case 10: {
                        return 9;
                    }
                    case 12: {
                        return 10;
                    }
                    case 14: {
                        return 13;
                    }
                    case 15: {
                        return 14;
                    }
                    case 13: {
                        return 15;
                    }
                }
                return 30;
            }
        }
        return 30;
    }

    private String getCurrentWifiSSID(NetworkState networkState) {
        if (this.getCurrentConnectionType(networkState) != 2) {
            return "";
        }
        return this.mWifiManagerDelegate.getWifiSSID();
    }

    public void onReceive(Context context, Intent intent) {
        NetworkState networkState = this.getCurrentNetworkState();
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
            this.connectionTypeChanged(networkState);
            this.maxBandwidthChanged(networkState);
        } else if ("android.net.wifi.RSSI_CHANGED".equals(intent.getAction())) {
            this.maxBandwidthChanged(networkState);
        }
    }

    @Override
    public void onApplicationStateChange(int newState) {
        NetworkState networkState = this.getCurrentNetworkState();
        if (newState == 1) {
            this.connectionTypeChanged(networkState);
            this.maxBandwidthChanged(networkState);
            this.registerReceiver();
        } else if (newState == 2) {
            this.unregisterReceiver();
        }
    }

    private void connectionTypeChanged(NetworkState networkState) {
        int newConnectionType = this.getCurrentConnectionType(networkState);
        String newWifiSSID = this.getCurrentWifiSSID(networkState);
        if (newConnectionType == this.mConnectionType && newWifiSSID.equals(this.mWifiSSID)) {
            return;
        }
        this.mConnectionType = newConnectionType;
        this.mWifiSSID = newWifiSSID;
        Log.d((String)TAG, (String)("Network connectivity changed, type is: " + this.mConnectionType));
        this.mObserver.onConnectionTypeChanged(newConnectionType);
    }

    private void maxBandwidthChanged(NetworkState networkState) {
        double newMaxBandwidthMbps = this.getCurrentMaxBandwidthInMbps(networkState);
        if (newMaxBandwidthMbps == this.mMaxBandwidthMbps) {
            return;
        }
        this.mMaxBandwidthMbps = newMaxBandwidthMbps;
        this.mObserver.onMaxBandwidthChanged(newMaxBandwidthMbps);
    }

    private static class NetworkConnectivityIntentFilter
    extends IntentFilter {
        NetworkConnectivityIntentFilter(boolean monitorRSSI) {
            this.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            if (monitorRSSI) {
                this.addAction("android.net.wifi.RSSI_CHANGED");
            }
        }
    }

    public static interface Observer {
        public void onConnectionTypeChanged(int var1);

        public void onMaxBandwidthChanged(double var1);
    }

    static class WifiManagerDelegate {
        private final Context mContext;
        private final WifiManager mWifiManager;
        private final boolean mHasWifiPermission;

        WifiManagerDelegate(Context context) {
            this.mContext = context;
            this.mHasWifiPermission = this.mContext.getPackageManager().checkPermission("android.permission.ACCESS_WIFI_STATE", this.mContext.getPackageName()) == 0;
            this.mWifiManager = this.mHasWifiPermission ? (WifiManager)this.mContext.getSystemService("wifi") : null;
        }

        WifiManagerDelegate() {
            this.mContext = null;
            this.mWifiManager = null;
            this.mHasWifiPermission = false;
        }

        String getWifiSSID() {
            String ssid;
            WifiInfo wifiInfo;
            Intent intent = this.mContext.registerReceiver(null, new IntentFilter("android.net.wifi.STATE_CHANGE"));
            if (intent != null && (wifiInfo = (WifiInfo)intent.getParcelableExtra("wifiInfo")) != null && (ssid = wifiInfo.getSSID()) != null) {
                return ssid;
            }
            return "";
        }

        int getLinkSpeedInMbps() {
            if (!this.mHasWifiPermission || this.mWifiManager == null) {
                return -1;
            }
            WifiInfo wifiInfo = this.mWifiManager.getConnectionInfo();
            if (wifiInfo == null) {
                return -1;
            }
            return wifiInfo.getLinkSpeed();
        }

        boolean getHasWifiPermission() {
            return this.mHasWifiPermission;
        }
    }

    static class ConnectivityManagerDelegate {
        private final ConnectivityManager mConnectivityManager;

        ConnectivityManagerDelegate(Context context) {
            this.mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        }

        ConnectivityManagerDelegate() {
            this.mConnectivityManager = null;
        }

        NetworkState getNetworkState() {
            NetworkInfo networkInfo = this.mConnectivityManager.getActiveNetworkInfo();
            if (networkInfo == null || !networkInfo.isConnected()) {
                return new NetworkState(false, -1, -1);
            }
            return new NetworkState(true, networkInfo.getType(), networkInfo.getSubtype());
        }
    }

    static class NetworkState {
        private final boolean mConnected;
        private final int mType;
        private final int mSubtype;

        public NetworkState(boolean connected, int type, int subtype) {
            this.mConnected = connected;
            this.mType = type;
            this.mSubtype = subtype;
        }

        public boolean isConnected() {
            return this.mConnected;
        }

        public int getNetworkType() {
            return this.mType;
        }

        public int getNetworkSubType() {
            return this.mSubtype;
        }
    }
}

