/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui;

import android.content.Context;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import org.chromium.base.ApiCompatibilityUtils;
import org.chromium.ui.ColorSuggestion;
import org.chromium.ui.R;

public class ColorSuggestionListAdapter
extends BaseAdapter
implements View.OnClickListener {
    private Context mContext;
    private ColorSuggestion[] mSuggestions;
    private OnColorSuggestionClickListener mListener;
    private static final int COLORS_PER_ROW = 4;

    ColorSuggestionListAdapter(Context context, ColorSuggestion[] suggestions) {
        this.mContext = context;
        this.mSuggestions = suggestions;
    }

    public void setOnColorSuggestionClickListener(OnColorSuggestionClickListener listener) {
        this.mListener = listener;
    }

    private void setUpColorButton(View button, int index) {
        if (index >= this.mSuggestions.length) {
            button.setTag(null);
            button.setContentDescription(null);
            button.setVisibility(4);
            return;
        }
        button.setTag((Object)this.mSuggestions[index]);
        button.setVisibility(0);
        ColorSuggestion suggestion = this.mSuggestions[index];
        LayerDrawable layers = (LayerDrawable)button.getBackground();
        GradientDrawable swatch = (GradientDrawable)layers.findDrawableByLayerId(R.id.color_button_swatch);
        swatch.setColor(suggestion.mColor);
        String description = suggestion.mLabel;
        if (TextUtils.isEmpty((CharSequence)description)) {
            description = String.format("#%06X", 0xFFFFFF & suggestion.mColor);
        }
        button.setContentDescription((CharSequence)description);
        button.setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View v) {
        if (this.mListener == null) {
            return;
        }
        ColorSuggestion suggestion = (ColorSuggestion)v.getTag();
        if (suggestion == null) {
            return;
        }
        this.mListener.onColorSuggestionClick(suggestion);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        LinearLayout layout2;
        if (convertView != null && convertView instanceof LinearLayout) {
            layout2 = (LinearLayout)convertView;
        } else {
            layout2 = new LinearLayout(this.mContext);
            layout2.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, -2));
            layout2.setOrientation(0);
            layout2.setBackgroundColor(-1);
            int buttonHeight = this.mContext.getResources().getDimensionPixelOffset(R.dimen.color_button_height);
            for (int i = 0; i < 4; ++i) {
                View button = new View(this.mContext);
                LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(0, buttonHeight, 1.0f);
                ApiCompatibilityUtils.setMarginStart((ViewGroup.MarginLayoutParams)layoutParams, -1);
                if (i == 3) {
                    ApiCompatibilityUtils.setMarginEnd((ViewGroup.MarginLayoutParams)layoutParams, -1);
                }
                button.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                button.setBackgroundResource(R.drawable.color_button_background);
                layout2.addView(button);
            }
        }
        for (int i = 0; i < 4; ++i) {
            this.setUpColorButton(layout2.getChildAt(i), position * 4 + i);
        }
        return layout2;
    }

    public long getItemId(int position) {
        return position;
    }

    public Object getItem(int position) {
        return null;
    }

    public int getCount() {
        return (this.mSuggestions.length + 4 - 1) / 4;
    }

    public static interface OnColorSuggestionClickListener {
        public void onColorSuggestionClick(ColorSuggestion var1);
    }
}

