/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui;

import android.content.Context;
import android.graphics.Rect;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListPopupWindow;
import android.widget.PopupWindow;
import java.lang.reflect.Method;
import org.chromium.base.ApiCompatibilityUtils;
import org.chromium.ui.R;
import org.chromium.ui.base.ViewAndroidDelegate;

public class DropdownPopupWindow
extends ListPopupWindow {
    private final Context mContext;
    private final ViewAndroidDelegate mViewAndroidDelegate;
    private final View mAnchorView;
    private float mAnchorWidth;
    private float mAnchorHeight;
    private float mAnchorX;
    private float mAnchorY;
    private boolean mRtl;
    private View.OnLayoutChangeListener mLayoutChangeListener;
    private PopupWindow.OnDismissListener mOnDismissListener;
    private CharSequence mDescription;
    ListAdapter mAdapter;

    public DropdownPopupWindow(Context context, ViewAndroidDelegate viewAndroidDelegate) {
        super(context, null, 0, R.style.DropdownPopupWindow);
        this.mContext = context;
        this.mViewAndroidDelegate = viewAndroidDelegate;
        this.mAnchorView = this.mViewAndroidDelegate.acquireAnchorView();
        this.mAnchorView.setId(R.id.dropdown_popup_window);
        this.mAnchorView.setTag((Object)this);
        this.mLayoutChangeListener = new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                if (v == DropdownPopupWindow.this.mAnchorView) {
                    DropdownPopupWindow.this.show();
                }
            }
        };
        this.mAnchorView.addOnLayoutChangeListener(this.mLayoutChangeListener);
        super.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                if (DropdownPopupWindow.this.mOnDismissListener != null) {
                    DropdownPopupWindow.this.mOnDismissListener.onDismiss();
                }
                DropdownPopupWindow.this.mAnchorView.removeOnLayoutChangeListener(DropdownPopupWindow.this.mLayoutChangeListener);
                DropdownPopupWindow.this.mAnchorView.setTag(null);
                DropdownPopupWindow.this.mViewAndroidDelegate.releaseAnchorView(DropdownPopupWindow.this.mAnchorView);
            }
        });
        this.setAnchorView(this.mAnchorView);
        Rect originalPadding = new Rect();
        this.getBackground().getPadding(originalPadding);
        this.setVerticalOffset(-originalPadding.top);
    }

    public void setAnchorRect(float x, float y, float width, float height) {
        this.mAnchorWidth = width;
        this.mAnchorHeight = height;
        this.mAnchorX = x;
        this.mAnchorY = y;
        if (this.mAnchorView != null) {
            this.mViewAndroidDelegate.setAnchorViewPosition(this.mAnchorView, this.mAnchorX, this.mAnchorY, this.mAnchorWidth, this.mAnchorHeight);
        }
    }

    public void setAdapter(ListAdapter adapter) {
        this.mAdapter = adapter;
        super.setAdapter(adapter);
    }

    public void show() {
        this.setInputMethodMode(1);
        int contentWidth = this.measureContentWidth();
        float contentWidthInDip = (float)contentWidth / this.mContext.getResources().getDisplayMetrics().density;
        Rect padding = new Rect();
        this.getBackground().getPadding(padding);
        if (contentWidthInDip + (float)padding.left + (float)padding.right > this.mAnchorWidth) {
            this.setContentWidth(contentWidth);
            Rect displayFrame = new Rect();
            this.mAnchorView.getWindowVisibleDisplayFrame(displayFrame);
            if (this.getWidth() > displayFrame.width()) {
                this.setWidth(displayFrame.width());
            }
        } else {
            this.setWidth(-2);
        }
        this.mViewAndroidDelegate.setAnchorViewPosition(this.mAnchorView, this.mAnchorX, this.mAnchorY, this.mAnchorWidth, this.mAnchorHeight);
        boolean wasShowing = this.isShowing();
        super.show();
        this.getListView().setDividerHeight(0);
        ApiCompatibilityUtils.setLayoutDirection((View)this.getListView(), this.mRtl ? 1 : 0);
        if (!wasShowing) {
            this.getListView().setContentDescription(this.mDescription);
            this.getListView().sendAccessibilityEvent(32);
        }
    }

    public void setOnDismissListener(PopupWindow.OnDismissListener listener) {
        this.mOnDismissListener = listener;
    }

    public void setRtl(boolean isRtl) {
        this.mRtl = isRtl;
    }

    public void disableHideOnOutsideTap() {
        try {
            Method setForceIgnoreOutsideTouch = ListPopupWindow.class.getMethod("setForceIgnoreOutsideTouch", Boolean.TYPE);
            setForceIgnoreOutsideTouch.invoke((Object)this, true);
        }
        catch (Exception e) {
            Log.e((String)"AutofillPopup", (String)"ListPopupWindow.setForceIgnoreOutsideTouch not found", (Throwable)e);
        }
    }

    public void setContentDescriptionForAccessibility(CharSequence description) {
        this.mDescription = description;
    }

    private int measureContentWidth() {
        assert (this.mAdapter != null) : "Set the adapter before showing the popup.";
        int maxWidth = 0;
        View[] itemViews = new View[this.mAdapter.getViewTypeCount()];
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        for (int i = 0; i < this.mAdapter.getCount(); ++i) {
            int type = this.mAdapter.getItemViewType(i);
            itemViews[type] = this.mAdapter.getView(i, itemViews[type], null);
            View itemView = itemViews[type];
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
            itemView.setLayoutParams((ViewGroup.LayoutParams)params);
            itemView.measure(widthMeasureSpec, heightMeasureSpec);
            maxWidth = Math.max(maxWidth, itemView.getMeasuredWidth());
        }
        return maxWidth;
    }
}

