/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.util.Log;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.chromium.base.ContentUriUtils;

public class UiUtils {
    private static final String TAG = "UiUtils";
    private static final int KEYBOARD_RETRY_ATTEMPTS = 10;
    private static final long KEYBOARD_RETRY_DELAY_MS = 100L;
    public static final String EXTERNAL_IMAGE_FILE_PATH = "browser-images";
    public static final String IMAGE_FILE_PATH = "images";
    private static final float KEYBOARD_DETECT_BOTTOM_THRESHOLD_DP = 100.0f;
    private static KeyboardShowingDelegate sKeyboardShowingDelegate;

    private UiUtils() {
    }

    public static void setKeyboardShowingDelegate(KeyboardShowingDelegate delegate) {
        sKeyboardShowingDelegate = delegate;
    }

    public static void showKeyboard(final View view) {
        final Handler handler = new Handler();
        final AtomicInteger attempt = new AtomicInteger();
        Runnable openRunnable = new Runnable(){

            @Override
            public void run() {
                InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
                try {
                    imm.showSoftInput(view, 0);
                }
                catch (IllegalArgumentException e) {
                    if (attempt.incrementAndGet() <= 10) {
                        handler.postDelayed((Runnable)this, 100L);
                    }
                    Log.e((String)UiUtils.TAG, (String)"Unable to open keyboard.  Giving up.", (Throwable)e);
                }
            }
        };
        openRunnable.run();
    }

    public static boolean hideKeyboard(View view) {
        InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
        return imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public static boolean isKeyboardShowing(Context context, View view) {
        if (sKeyboardShowingDelegate != null && sKeyboardShowingDelegate.disableKeyboardCheck(context, view)) {
            return false;
        }
        View rootView = view.getRootView();
        if (rootView == null) {
            return false;
        }
        Rect appRect = new Rect();
        rootView.getWindowVisibleDisplayFrame(appRect);
        float density = context.getResources().getDisplayMetrics().density;
        float bottomMarginDp = (float)Math.abs(rootView.getHeight() - appRect.height()) / density;
        return bottomMarginDp > 100.0f;
    }

    public static int insertBefore(ViewGroup container, View newView, View existingView) {
        return UiUtils.insertView(container, newView, existingView, false);
    }

    public static int insertAfter(ViewGroup container, View newView, View existingView) {
        return UiUtils.insertView(container, newView, existingView, true);
    }

    private static int insertView(ViewGroup container, View newView, View existingView, boolean after) {
        int index = container.indexOfChild(newView);
        if (index >= 0) {
            return index;
        }
        index = container.indexOfChild(existingView);
        if (index < 0) {
            return -1;
        }
        if (after) {
            ++index;
        }
        container.addView(newView, index);
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap generateScaledScreenshot(View currentView, int maximumDimension, Bitmap.Config bitmapConfig) {
        Bitmap screenshot = null;
        boolean drawingCacheEnabled = currentView.isDrawingCacheEnabled();
        try {
            Bitmap originalBitmap;
            UiUtils.prepareViewHierarchyForScreenshot(currentView, true);
            if (!drawingCacheEnabled) {
                currentView.setDrawingCacheEnabled(true);
            }
            if ((originalBitmap = currentView.getDrawingCache()) != null) {
                Bitmap scaledScreenshot;
                double originalHeight = originalBitmap.getHeight();
                double originalWidth = originalBitmap.getWidth();
                int newWidth = (int)originalWidth;
                int newHeight = (int)originalHeight;
                if (maximumDimension > 0) {
                    double scale = (double)maximumDimension / Math.max(originalWidth, originalHeight);
                    newWidth = (int)Math.round(originalWidth * scale);
                    newHeight = (int)Math.round(originalHeight * scale);
                }
                if ((scaledScreenshot = Bitmap.createScaledBitmap((Bitmap)originalBitmap, (int)newWidth, (int)newHeight, (boolean)true)).getConfig() != bitmapConfig) {
                    screenshot = scaledScreenshot.copy(bitmapConfig, false);
                    scaledScreenshot.recycle();
                    scaledScreenshot = null;
                } else {
                    screenshot = scaledScreenshot;
                }
            } else if (currentView.getMeasuredHeight() > 0 && currentView.getMeasuredWidth() > 0) {
                double originalHeight = currentView.getMeasuredHeight();
                double originalWidth = currentView.getMeasuredWidth();
                int newWidth = (int)originalWidth;
                int newHeight = (int)originalHeight;
                if (maximumDimension > 0) {
                    double scale = (double)maximumDimension / Math.max(originalWidth, originalHeight);
                    newWidth = (int)Math.round(originalWidth * scale);
                    newHeight = (int)Math.round(originalHeight * scale);
                }
                Bitmap bitmap = Bitmap.createBitmap((int)newWidth, (int)newHeight, (Bitmap.Config)bitmapConfig);
                Canvas canvas = new Canvas(bitmap);
                canvas.scale((float)((double)newWidth / originalWidth), (float)((double)newHeight / originalHeight));
                currentView.draw(canvas);
                screenshot = bitmap;
            }
        }
        catch (OutOfMemoryError e) {
            Log.d((String)TAG, (String)("Unable to capture screenshot and scale it down." + e.getMessage()));
        }
        finally {
            if (!drawingCacheEnabled) {
                currentView.setDrawingCacheEnabled(false);
            }
            UiUtils.prepareViewHierarchyForScreenshot(currentView, false);
        }
        return screenshot;
    }

    private static void prepareViewHierarchyForScreenshot(View view, boolean takingScreenshot) {
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                UiUtils.prepareViewHierarchyForScreenshot(viewGroup.getChildAt(i), takingScreenshot);
            }
        } else if (view instanceof SurfaceView) {
            view.setWillNotDraw(!takingScreenshot);
        }
    }

    public static File getDirectoryForImageCapture(Context context) throws IOException {
        File path;
        if (Build.VERSION.SDK_INT >= 18) {
            path = new File(context.getFilesDir(), IMAGE_FILE_PATH);
            if (!path.exists() && !path.mkdir()) {
                throw new IOException("Folder cannot be created.");
            }
        } else {
            File externalDataDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM);
            path = new File(externalDataDir.getAbsolutePath() + File.separator + EXTERNAL_IMAGE_FILE_PATH);
            if (!path.exists() && !path.mkdirs()) {
                path = externalDataDir;
            }
        }
        return path;
    }

    public static Uri getUriForImageCaptureFile(Context context, File file) {
        return Build.VERSION.SDK_INT >= 18 ? ContentUriUtils.getContentUriFromFile(context, file) : Uri.fromFile((File)file);
    }

    public static interface KeyboardShowingDelegate {
        public boolean disableKeyboardCheck(Context var1, View var2);
    }
}

