/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.autofill;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import org.chromium.base.ApiCompatibilityUtils;
import org.chromium.ui.R;
import org.chromium.ui.autofill.AutofillSuggestion;
import org.chromium.ui.autofill.SuggestionAdapter;
import org.chromium.ui.base.WindowAndroid;

public class AutofillKeyboardAccessory
extends ListView
implements AdapterView.OnItemClickListener,
WindowAndroid.KeyboardVisibilityListener {
    private final WindowAndroid mWindowAndroid;
    private final AutofillKeyboardAccessoryDelegate mAutofillCallback;

    public AutofillKeyboardAccessory(WindowAndroid windowAndroid, AutofillKeyboardAccessoryDelegate autofillCallback) {
        super((Context)windowAndroid.getActivity().get());
        assert (autofillCallback != null);
        assert (windowAndroid.getActivity().get() != null);
        this.mWindowAndroid = windowAndroid;
        this.mAutofillCallback = autofillCallback;
        this.mWindowAndroid.addKeyboardVisibilityListener(this);
        this.setOnItemClickListener(this);
        this.setContentDescription(this.getContext().getString(R.string.autofill_popup_content_description));
        this.setBackgroundColor(this.getResources().getColor(R.color.keyboard_accessory_suggestion_background_color));
    }

    @SuppressLint(value={"InlinedApi"})
    public void showWithSuggestions(AutofillSuggestion[] suggestions, boolean isRtl) {
        this.setAdapter((ListAdapter)new SuggestionAdapter(this.getContext(), suggestions));
        ApiCompatibilityUtils.setLayoutDirection((View)this, isRtl ? 1 : 0);
        int height = -2;
        int suggestionLimit = 2;
        ListAdapter listAdapter = this.getAdapter();
        if (listAdapter.getCount() > 2) {
            height = 0;
            for (int i = 0; i < 2; ++i) {
                View listItem = listAdapter.getView(i, null, (ViewGroup)this);
                height += listItem.getLayoutParams().height;
            }
        }
        this.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, height));
        if (this.getParent() == null) {
            ViewGroup container = this.mWindowAndroid.getKeyboardAccessoryView();
            container.addView((View)this);
            container.setVisibility(0);
            this.sendAccessibilityEvent(32);
        }
    }

    public void dismiss() {
        ViewGroup container = this.mWindowAndroid.getKeyboardAccessoryView();
        container.removeView((View)this);
        container.setVisibility(8);
        this.mWindowAndroid.removeKeyboardVisibilityListener(this);
        ((View)container.getParent()).requestLayout();
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        this.mAutofillCallback.suggestionSelected(position);
    }

    @Override
    public void keyboardVisibilityChanged(boolean isShowing) {
        if (!isShowing) {
            this.dismiss();
            this.mAutofillCallback.dismissed();
        }
    }

    public static interface AutofillKeyboardAccessoryDelegate {
        public void dismissed();

        public void suggestionSelected(int var1);
    }
}

