/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.autofill;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.PopupWindow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.chromium.ui.DropdownAdapter;
import org.chromium.ui.DropdownItem;
import org.chromium.ui.DropdownPopupWindow;
import org.chromium.ui.R;
import org.chromium.ui.autofill.AutofillSuggestion;
import org.chromium.ui.base.ViewAndroidDelegate;

public class AutofillPopup
extends DropdownPopupWindow
implements AdapterView.OnItemClickListener,
AdapterView.OnItemLongClickListener,
PopupWindow.OnDismissListener {
    private static final int ITEM_ID_SEPARATOR_ENTRY = -3;
    private final Context mContext;
    private final AutofillPopupDelegate mAutofillCallback;
    private List<AutofillSuggestion> mSuggestions;

    public AutofillPopup(Context context, ViewAndroidDelegate viewAndroidDelegate, AutofillPopupDelegate autofillCallback) {
        super(context, viewAndroidDelegate);
        this.mContext = context;
        this.mAutofillCallback = autofillCallback;
        this.setOnItemClickListener(this);
        this.setOnDismissListener(this);
        this.disableHideOnOutsideTap();
        this.setContentDescriptionForAccessibility(this.mContext.getString(R.string.autofill_popup_content_description));
    }

    @SuppressLint(value={"InlinedApi"})
    public void filterAndShow(AutofillSuggestion[] suggestions, boolean isRtl) {
        this.mSuggestions = new ArrayList<AutofillSuggestion>(Arrays.asList(suggestions));
        ArrayList<DropdownItem> cleanedData = new ArrayList<DropdownItem>();
        HashSet<Integer> separators = new HashSet<Integer>();
        for (int i = 0; i < suggestions.length; ++i) {
            int itemId = suggestions[i].getSuggestionId();
            if (itemId == -3) {
                separators.add(cleanedData.size());
                continue;
            }
            cleanedData.add(suggestions[i]);
        }
        this.setAdapter((ListAdapter)new DropdownAdapter(this.mContext, cleanedData, separators));
        this.setRtl(isRtl);
        this.show();
        this.getListView().setOnItemLongClickListener((AdapterView.OnItemLongClickListener)this);
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        DropdownAdapter adapter = (DropdownAdapter)parent.getAdapter();
        int listIndex = this.mSuggestions.indexOf(adapter.getItem(position));
        assert (listIndex > -1);
        this.mAutofillCallback.suggestionSelected(listIndex);
    }

    public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
        DropdownAdapter adapter = (DropdownAdapter)parent.getAdapter();
        AutofillSuggestion suggestion = (AutofillSuggestion)adapter.getItem(position);
        if (!suggestion.isDeletable()) {
            return false;
        }
        int listIndex = this.mSuggestions.indexOf(suggestion);
        assert (listIndex > -1);
        this.mAutofillCallback.deleteSuggestion(listIndex);
        return true;
    }

    public void onDismiss() {
        this.mAutofillCallback.dismissed();
    }

    public static interface AutofillPopupDelegate {
        public void dismissed();

        public void suggestionSelected(int var1);

        public void deleteSuggestion(int var1);
    }
}

